// NOTE:
//
// By using TGONLY.PRJ, this application will demonstrate the problems
// described in ADDENDUM.DOC.
//
// By using TVALID.PRJ, this application will demonstrate the fixes
// described in ADDENDUM.DOC.
//

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TButton
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TFileDialog
#define Uses_TInputLine
#define Uses_TKeys
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#include <tv.h>

// NOTE:
// THIS VALUE MUST MATCH THE LINES IN TGROUP.CPP AND TFILDLG.CPP!!!!!!
//
// IF YOU'VE PERMANENTLY CHANGED THE TURBO VISION SOURCE AS DESCRIBED IN
// ADDENDUM.DOC, REMOVE THIS LINE!
//

// const cmLoseFocus = 30;

// ****************************************************************************

class TTest : public TInputLine
{
public:
    TTest(const TRect& bounds, int aMaxLen) :
        TInputLine(bounds, aMaxLen) {}

    virtual Boolean valid(ushort command)
    {
//    	if((command == cmLoseFocus || command == cmOK || command == cmYes
//          || command == cmClose) && *data == EOS)

        if(command == cmLoseFocus && *data == EOS)
        {
            messageBox("Can't leave with empty line!", mfError | mfOKButton);
            return False;
        }

        return TInputLine::valid(command);
    }
};

// ****************************************************************************

const cmTestDlg = 100,
      cmFileDlg = 101;

class TApp : public TApplication
{
public:
    TApp() : TProgInit(initStatusLine, initMenuBar, initDeskTop)
    {
        enableCommand(cmTestDlg);
        enableCommand(cmFileDlg);
    }

    static TStatusLine* initStatusLine(TRect r)
    {
        r.a.y = r.b.y-1;
        return new TStatusLine(r,
            *new TStatusDef(0, 0xFFFF)+
            *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit)+
            *new TStatusItem("~Alt-D~ Test Dialog", kbAltD, cmTestDlg)+
            *new TStatusItem("~Alt-F~ File Dialog", kbAltF, cmFileDlg) );
    }

    virtual void handleEvent(TEvent& event);
};

void TApp::handleEvent(TEvent& event)
{
    TApplication::handleEvent(event);

    if(event.what == evCommand)
        switch(event.message.command)
        {
            case cmTestDlg:
                TDialog* dlg = new TDialog(TRect(0,0,80,15), "Test");
                dlg->options |= ofCentered;

                dlg->insert(new TStaticText(TRect(2,2,78,4),
                    "Click the mouse on the button with either or both "
                    "fields empty.  After you close the error message box, "
                    "move the mouse on and off the button."));
                dlg->insert(new TStaticText(TRect(2,4,78,6),
                    "It will act as if it is still selected.  Click anywhere "
                    "except on the button to get the input line to accept "
                    "text again."));

                dlg->insert(new TTest(TRect(3,7,13,8), 7));
                dlg->insert(new TTest(TRect(3,9,13,10), 7));

                dlg->insert(new TButton(TRect(3,11,13,13), "O~K~", cmOK,
                    bfNormal));

                dlg->selectNext(False);

                if(validView(dlg))
                {
                    deskTop->execView(dlg);
                    destroy(dlg);
                }
                clearEvent(event);
                break;

            case cmFileDlg:
                messageBox("Type in a non-existent directory "
                  "(i.e. '\\XYZ\\123\\*.*') and watch the "
                  "stack overflow when you hit ENTER!",
                  mfInformation | mfOKButton);

                messageBox("Reboot the PC when it does if you ran this "
                  "from the DOS prompt.  It will be in an unstable state.",
                  mfInformation | mfOKButton);

                TFileDialog *tfdlg = new TFileDialog("*.*", "Test", "~N~ame",
                   fdOpenButton, 10);

                if(validView(tfdlg))
                {
                    deskTop->execView(tfdlg);
                    destroy(tfdlg);
                }
                clearEvent(event);
                break;
        }
}

int main()
{
    TApp app;

    if(app.valid(cmValid))
        app.run();

    app.shutDown();

    return 0;
}
