// File    : VALIDATR.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 07/21/94 20:44:37
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// ****
// **** NOTE: See README.DOC for some bug fixes that the are required
// ****       before using the validator classes.
// ****
//
// This is a demo program that shows what the new Turbo Vision 2.0
// validator classes are capable of.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define Uses_TApplication       // Get the standard stuff pulled in.
#define Uses_TButton
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TInputLine
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TLabel
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu

#define Uses_TFilterValidator       // Get the validators pulled in.
#define Uses_TRangeValidator
#define Uses_TStringLookupValidator
#define Uses_TPXPictureValidator

#include <tv.h>

#define Uses_TNumericValidator      // Get the custom validators pulled in.
#define Uses_TEmptyPXValidator
#define Uses_TDoubleValidator
#define Uses_TICStringLookupValidator
#include <custmval.h>

const
    cmFilter       = 100,       // Commands for the demo.
    cmRange        = 101,
    cmStringLookup = 102,
    cmPXPicture1   = 103,
    cmPXPicture2   = 104,
    cmDerived      = 105;

class TMyApp : public TApplication
{
public:
    TMyApp();
    static TStatusLine *initStatusLine( TRect r );
    static TMenuBar *initMenuBar( TRect r );
    virtual void handleEvent( TEvent& event);

    void doFilterDemo(void);
    void doRangeDemo(void);
    void doStringLookupDemo(void);
    void doPXPictureDemo1(void);
    void doPXPictureDemo2(void);
    void doDerivedClassDemo(void);
};

TMyApp::TMyApp() :
  TProgInit( &TMyApp::initStatusLine, &TMyApp::initMenuBar,
    &TMyApp::initDeskTop)
{
}

TStatusLine *TMyApp::initStatusLine(TRect r)
{
    r.a.y = r.b.y - 1;
    return new TStatusLine( r,
        *new TStatusDef( 0, 0xFFFF ) +
            *new TStatusItem( 0, kbF10, cmMenu ) +
            *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) );
}

TMenuBar *TMyApp::initMenuBar( TRect r )
{
    r.b.y = r.a.y + 1;
    return new TMenuBar( r,
        *new TSubMenu( "~V~alidator Examples", kbAltF )+
            *new TMenuItem( "~F~ilter", cmFilter, kbNoKey)+
            *new TMenuItem( "~R~ange",  cmRange,   kbNoKey)+
            *new TMenuItem( "~S~tring Lookup",  cmStringLookup, kbNoKey)+
            *new TMenuItem( "~P~icture",  cmPXPicture1, kbNoKey)+
            *new TMenuItem( "~M~ore pictures",  cmPXPicture2, kbNoKey)+
            *new TMenuItem( "~D~erived classes", cmDerived, kbNoKey) );
}

void TMyApp::handleEvent(TEvent& event)
{
    TApplication::handleEvent(event);

    if(event.what == evCommand)
    {
        switch( event.message.command )
        {
            case cmFilter:
                doFilterDemo();
                break;

            case cmRange:
                doRangeDemo();
                break;

            case cmStringLookup:
                doStringLookupDemo();
                break;

            case cmPXPicture1:
                doPXPictureDemo1();
                break;

            case cmPXPicture2:
                doPXPictureDemo2();
                break;

            case cmDerived:
                doDerivedClassDemo();
                break;

            default:
                return;
        }
        clearEvent(event);
    }
}

void TMyApp::doFilterDemo(void)
{
    TDialog* dlg = new TDialog(TRect(5, 6, 74, 16), "Filter Validators");
    if(!dlg)
        return;

    dlg->options |= ofCentered;

    // The TFilterValidator is pretty simplistic.  It just accepts any
    // character in the given set in any order and ignores everything else.
    TInputLine *ln = new TInputLine(TRect(53, 2, 65, 3), 11,
        new TFilterValidator("1234567890"));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(35, 2, 52, 3), "Digits 0-9 only:", ln));

    ln = new TInputLine(TRect(53, 3, 65, 4), 11,
        new TFilterValidator("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(32, 3, 52, 4), "Uppercase A-Z only:", ln));

    ln = new TInputLine(TRect(53, 4, 65, 5), 11,
        new TFilterValidator("abcdefghijklmnopqrstuvwxyz"));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(32, 4, 52, 5), "Lowercase a-z only:", ln));

    ln = new TInputLine(TRect(53, 5, 65, 6), 11,
        new TFilterValidator("1234567890+-."));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(3, 5, 52, 6),
        "Digits 0-9, +, -, and/or . in no specific order:", ln));

    dlg->insert(new TButton(TRect(31, 7, 41, 9), "O~K~", cmOK, bfNormal));
    dlg->selectNext(False);

    // Note the new TProgram::executeDialog function too.  It insures that
    // the dialog is valid and, if it is, sets data from the passed pointer
    // (if not NULL), executes the dialog, retrieves data (if necessary),
    // and then destroys the dialog box.  This is a demo dialog with no data
    // to set or get.
    executeDialog(dlg, NULL);
}

void TMyApp::doRangeDemo(void)
{
    // TInputLine objects with a TRangeValidator can return either
    // normal text strings or actual signed long variables (Not unsigned
    // longs, unsigned or signed shorts/ints, or doubles.  You will need
    // to derive new classes for those, see below).
    //
    // See the necessary setup steps for returning a type long value below.
    struct dialogData
    {
        char Field1[11];    // Text
        long Field2;        // Numeric long
        char Field3[11];    // Text
        long Field4;        // Numeric long
        long Field5;        // Numeric long
    } dlgData;

    TDialog *dlg = new TDialog(TRect(16, 6, 63, 17), "Range Validators");
    if(!dlg)
        return;

    dlg->options |= ofCentered;

    // Standard TRangeValidators always work with type long values only.
    // This TInputLine will return its data as a string.
    TInputLine *ln = new TInputLine(TRect(31, 2, 44, 3), 11,
        new TRangeValidator(-32768L, 32767L));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(13, 2, 30, 3), "-32768 to 32767:", ln));

    // *****
    //
    TRangeValidator *rval = new TRangeValidator(10L, 90L);

    // This is what makes the TInputLine return the data as a type long.
    // Set the voTransfer bit of the associated TRangeValidator's options.
    rval->options |= voTransfer;
    //
    // *****

    // This TInputLine will return its data as a type long variable.
    ln = new TInputLine(TRect(31, 3, 44, 4), 11, rval);
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(20, 3, 30, 4), "10 to 90:", ln));

    // This TInputLine will return its data as a string.
    ln = new TInputLine(TRect(31, 4, 44, 5), 11,
        new TRangeValidator(-50L, 0L));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(20, 4, 30, 5), "-50 to 0:", ln));

    // This TInputLine will return its data as a type long variable.
    rval = new TRangeValidator(0L, 1000000L);
    rval->options |= voTransfer;
    ln = new TInputLine(TRect(31, 5, 44, 6), 11, rval);
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(16, 5, 30, 6), "0 to 1000000:", ln));

    // It's interesting to note that on this range validator, you can never
    // have an invalid result.  Typing in a number higher or lower than
    // either of the limits simply causes the value to "wrap" to an
    // appropriate negative or positive value because these are the limits
    // of the signed long data type that TRangeValidator uses.  You should
    // be aware that even though it isn't flagged as invalid, you may end up
    // with a value that isn't quite what you expected here.  In the
    // unlikely event that you need numbers larger than this, derive a new
    // validator that uses unsigned longs.  In the unlikely event that you
    // need values lower than this, you would probably derive a new class
    // and use a double but disallow entry of a decimal point.
    rval = new TRangeValidator(-2147483648L, 2147483647L);
    rval->options |= voTransfer;

    // This TInputLine will return its data as a type long variable.
    ln = new TInputLine(TRect(31, 6, 44, 7), 12, rval);
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(2, 6, 30, 7),
        "-2147483648 to +2147483647:", ln));

    dlg->insert(new TButton(TRect(21, 8, 31, 10), "O~K~", cmOK, bfNormal));
    dlg->selectNext(False);

    // Fill the data structure with some test values.
    strcpy(dlgData.Field1, "-32000");
    dlgData.Field2 = 21L;
    strcpy(dlgData.Field3, "0");
    dlgData.Field4 = 16384L;
    dlgData.Field5 = -2000000L;

    // Step over this line and, upon return, examine the data structure.
    // You should see the new values you entered if you didn't hit ESC to
    // cancel the dialog box.
    executeDialog(dlg, &dlgData);
}

// Probably not the greatest example in the world, but it'll give
// you the general idea.  The input lines in this example have ofValidate
// set so that the input is validated when you try to exit the field.
// Note that for the generic TStringLookupValidator, the entered data must
// match exactly including the case of the letters.
void TMyApp::doStringLookupDemo(void)
{
    struct dialogData
    {
        char CPU[21];
        char Compiler[21];
    } dlgData;

    short i;

    char *CPUList[] = { "8086", "8088", "80186", "Intel286",
                        "Intel386", "Intel486", "Pentium", NULL };

    char *CompilerList[] = { "Turbo C", "Turbo C++", "Borland C++", NULL };

    TDialog *dlg = new TDialog(TRect(19, 7, 61, 15),
        "String Lookup Validators");
    if(!dlg)
        return;

    dlg->options |= ofCentered;

    //
    // NOTE:  The string collections will be destroyed along with the
    //        input lines when the dialog box is destroyed.
    //
    TStringCollection *CPUs = new TStringCollection(5, 5);
    for(i = 0; CPUList[i]; i++)
        CPUs->insert(CPUList[i]);

    TStringCollection *Compilers = new TStringCollection(5, 5);
    for(i = 0; CompilerList[i]; i++)
        Compilers->insert(CompilerList[i]);

    TInputLine *ln = new TInputLine(TRect(14, 2, 36, 3), 21,
        new TStringLookupValidator(CPUs));

    // Validate on field exit
    ln->options |= ofValidate;

    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(7, 2, 13, 3), "CPUs:", ln));

    ln = new TInputLine(TRect(14, 3, 36, 4), 21,
        new TStringLookupValidator(Compilers));

    // Validate on field exit
    ln->options |= ofValidate;

    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(2, 3, 13, 4), "Compilers:", ln));

    dlg->insert(new TButton(TRect(16, 5, 26, 7), "O~K~", cmOK, bfNormal) );
    dlg->selectNext(False);

    // Initialize the data structure.
    strcpy(dlgData.CPU, "Intel386");
    strcpy(dlgData.Compiler, "Borland C++");

    // Step over this line and, upon return, examine the data structure.
    // You should see the new values you entered if you didn't hit ESC to
    // cancel the dialog box.
    executeDialog(dlg, &dlgData);
}

void TMyApp::doPXPictureDemo1(void)
{
    struct dialogData {
      char Field1[31];
      char Field2[31];
      char Field3[31];
      char Field4[31];
      char Field5[31];
      char Field6[31];
      char Field7[31];
      char Field8[31];
      char Field9[31];
      char Field10[31];
      char Field11[31];
    } dlgData;

    TDialog *dlg = new TDialog(TRect(0, 2, 80, 20),
        "Picture Validators");
    if(!dlg)
        return;

    dlg->options |= ofCentered;

    // First some real simple ones.
    TInputLine *ln = new TInputLine(TRect(46, 2, 78, 3), 31,
        new TPXPictureValidator("*!", False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(8, 2, 45, 3),
        "Any character, letters to uppercase:", ln));

    ln = new TInputLine(TRect(46, 3, 78, 4), 31,
        new TPXPictureValidator("*&", False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(5, 3, 45, 4),
        "Letter only, all uppercase (no spaces):", ln));

    ln = new TInputLine(TRect(46, 4, 78, 5), 31,
        new TPXPictureValidator("*?", False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(3, 4, 45, 5),
        "Upper/lowercase letters only (no spaces):", ln));

    ln = new TInputLine(TRect(46, 5, 78, 6), 31,
        new TPXPictureValidator("&*?", False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(9, 5, 45, 6),
        "As above, first letter capitalized:", ln));

    ln = new TInputLine(TRect(46, 6, 78, 7), 31,
        new TPXPictureValidator("!*@", False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(6, 6, 45, 7),
        "Capitalize first letter of first word:", ln));

    // A little more complex...
    ln = new TInputLine(TRect(46, 7, 78, 8), 31,
        new TPXPictureValidator("!*[ * !,@]", False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(6, 7, 45, 8),
        "Capitalize first letter of every word:", ln));

    ln = new TInputLine(TRect(46, 8, 78, 9), 31,
        new TPXPictureValidator("!*[{ ,-,.,(,;,}*{ ,-,.,(,;,}!,@]", False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(4, 8, 45, 9),
        "Capitalize after a space , - ( or . too:", ln));

    // This will return a number in string form.  The leading + or - is
    // optional as are the two decimal places.  Note that if one decimal place
    // is entered, they both must be filled in.
    ln = new TInputLine(TRect(46, 9, 78, 10), 31,
        new TPXPictureValidator("[+,-]*#[.##]", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(9, 9, 45, 10),
        "Number, +/- optional, .## optional:", ln));

    // As above, but the second decimal place is optional.
    ln = new TInputLine(TRect(46, 10, 78, 11), 31,
        new TPXPictureValidator("[+,-]*#[.#[#]]", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(13, 10, 45, 11),
        "As above, but either .# or .##:", ln));

    // This one can be used to enter numeric ranges such as page numbers.
    // For example: 1-4,9,12,14,200-400 or any combination thereof.  It
    // isn't perfect, but it does work.
    ln = new TInputLine(TRect(46, 11, 78, 12), 31,
        new TPXPictureValidator("*#[-*#][;,]*{*#[-*#][;,]}", False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(9, 11, 45, 12),
        "Numeric ranges (i.e. page numbers):", ln));

    // This one allows only valid filename characters to be entered.  It isn't
    // perfect because it can't validate proper form.  In other words, the
    // characters can be typed in any order for any length possibly forming an
    // illegally formatted filename.  However, it does filter the proper
    // characters and can at least insure that ':' is only used when a letter
    // is typed in the first position.  Note that # and & are used to allow
    // all digits and letters and they are also specified again along with
    // most of the other picture format characters each preceded by a
    // semi-colon so that they are interpreted as literal characters.
    // Here's a clearer breakdown of the picture below.
    //
    // {x:,{valid character}*[{valid character(s)}]
    //
    // The first part is either a drive specifier or any valid character
    // except the period used for an extension.  The rest of the string can
    // be composed of any number of the given valid characters.  The picture
    // below is split across two lines as two separate strings.  The compiler
    // will join them together properly at compile time.
    //
    ln = new TInputLine(TRect(46, 12, 78, 13), 31,
        new TPXPictureValidator(
        "{&:,{\\,#,&,;#,;?,;@,;&,;!,;;,;*,;{,;},$,%,(,),-,^,_,~}}"
        "*[{\\,#,&,;#,;?,;@,;&,;!,;;,;*,;{,;},$,%,(,),-,.,^,_,~}]"
        , False));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(9, 12, 45, 13),
        "DOS filename without form checking:", ln));

    dlg->insert(new TButton(TRect(37, 15, 47, 17), "O~K~", cmOK, bfNormal) );
    dlg->selectNext(False);

    // Initialize the data structure to blank fields.
    memset((void *)&dlgData, 0, sizeof(dialogData));

    // Step over this line and, upon return, examine the data structure.
    // You should see the new values you entered if you didn't hit ESC to
    // cancel the dialog box.
    executeDialog(dlg, &dlgData);
}

void TMyApp::doPXPictureDemo2(void)
{
    struct dialogData
    {
        char Field1[11];
        char Field2[11];
        char Field3[12];
        char Field4[12];
        char Field5[14];
        char Field6[21];
        char Field7[15];
        char Field8[9];
        char Field9[9];
        char Field10[9];
        char Field11[9];
        char Field12[4];
        char Field13[9];
        char Field14[5];
        char Field15[11];
        char Field16[21];
        char Field17[21];
    } dlgData;

    // NOTE: Due to the optional or grouped parts of some of these fields,
    //       it isn't always possible to delete characters from the start or
    //       from some point prior to the end of the string.  To correct
    //       an error, it is sometimes necessary to go to the end of the
    //       data and press backspace until you reach the point you want to
    //       fix.
    //
    TDialog *dlg = new TDialog(TRect(0, 0, 80, 23), "More Picture Validators");
    if(!dlg)
        return;

    dlg->options |= ofCentered;

    // Auto fill won't have any effect on the next two input lines because
    // the literal '-' character is inside an optional section.  You must
    // either hit '-' or the spacebar to enter it.
    TInputLine *ln = new TInputLine(TRect(48, 2, 60, 3), 11,
        new TPXPictureValidator("#####[-####]", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(6, 2, 47, 3),
        "US zip code with optional last 4 digits:", ln));

    // The picture in this one illustrates a problem that you may encounter.
    // As shown, the picture will work.  You can enter either type of zip
    // code and it will be accepted properly.  However, if you swap the
    // masks so that it reads "{#####[-####],&#&#&#}", it won't work if you
    // type in only a 5-digit US zip code, you will receive a validation
    // error when you try to exit.  This probably has something to
    // do with the fact that it is trying to validate the partial numeric
    // input against the second mask which requires letters.  So, if you
    // have picture masks that mix numeric and letter options in two or more
    // separate masks, you may need to swap things around to make it work.
    ln = new TInputLine(TRect(48, 3, 60, 4), 11,
        new TPXPictureValidator("{&#&#&#,#####[-####]}", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(12, 3, 47, 4),
        "US, Canadian, or British zip code:", ln));

    // On this input line, setting the auto fill parameter to True does
    // have an effect.  As you type, the dashes are filled in for you.
    ln = new TInputLine(TRect(48, 4, 61, 5), 12,
        new TPXPictureValidator("###-##-####", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(22, 4, 47, 5),
        "SSN with auto dash fill:", ln));

    // Unlike the input line above, the dashes are inside a group, so setting
    // auto fill to True has no effect here.  You must type the '-' or hit
    // the space bar to enter it.
    ln = new TInputLine(TRect(48, 5, 61, 6), 12,
        new TPXPictureValidator("###{-}##{-}####", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(13, 5, 47, 6),
        "SSN with dash fill by space or -:", ln));

    ln = new TInputLine(TRect(48, 6, 63, 7), 14,
        new TPXPictureValidator("[(###)]###-####", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(7, 6, 47, 7),
        "Phone number with or without area code:", ln));

    ln = new TInputLine(TRect(48, 7, 70, 8), 21,
        new TPXPictureValidator("[(###)]###-####[x#*#]", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(9, 7, 47, 8),
        "Phone number with optional extension:", ln));

    ln = new TInputLine(TRect(48, 8, 64, 9), 15,
        new TPXPictureValidator("[{1-800-,(###)}]###-####", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(2, 8, 47, 9),
        "Phone Number w/optional 1-800- or area code:", ln));

    // By removing the '[' and ']' from around the Seconds part of the
    // picture, you can force the user to enter HH:MM:SS.
    ln = new TInputLine(TRect(48, 9, 58, 10), 9,
        new TPXPictureValidator(
            "{0#,1#,2{0,1,2,3}}:{0,1,2,3,4,5}#[:{0,1,2,3,4,5}#]", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(20, 9, 47, 10),
        "Time HH:MM (optional :SS):", ln));

    ln = new TInputLine(TRect(48, 10, 58, 11), 9,
        new TPXPictureValidator(
            "{1{:,{0,1,2}:},{2,3,4,5,6,7,8,9}:}{0,1,2,3,4,5}# {AM,PM}",
            True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(26, 10, 47, 11), "Time HH:MM AM or PM:", ln));

    ln = new TInputLine(TRect(48, 11, 58, 12), 9,
        new TPXPictureValidator("{1[/,0,1,2],0#,#}/[#]#/##", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(20, 11, 47, 12),
        "Date with auto slash fill:", ln));

    ln = new TInputLine(TRect(48, 12, 58, 13), 9,
        new TPXPictureValidator("{1[0,1,2],0#,#}/01/##", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(14, 12, 47, 13),
        "Date forcing first of the month:", ln));

    ln = new TInputLine(TRect(48, 13, 53, 14), 4,
        new TPXPictureValidator(
            "Feb,Sep,Oct,Nov,Dec,J{an,u{n,l}},Ma{r,y},A{pr,ug}", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(21, 13, 47, 14),
        "Abbr. months of the year:", ln));

    ln = new TInputLine(TRect(48, 14, 58, 15), 9,
        new TPXPictureValidator("{1st item,2nd item,3rd item}", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(5, 14, 47, 15),
        "List selection example: (hit 1, 2, or 3):", ln));

    ln = new TInputLine(TRect(48, 15, 54, 16), 5,
        new TPXPictureValidator("M{iss,s.,r{.,s.}}", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(28, 15, 47, 16), "Miss/Ms./Mr./Mrs.:", ln));

    ln = new TInputLine(TRect(48, 16, 60, 17), 11,
        new TPXPictureValidator(
     "{D{r.,octor},Father,M{iss,r{s.,.[ ;& Mrs.]},s{.,gr.}},Pastor,Reverend}",
     True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(13, 16, 47, 17),
        "Extensive title entry (see code):", ln));

    // This places separators between characters as on a tax or insurance
    // form.  For the first one, you must either type '|' or hit the space bar
    // to fill it in.  Type '|' or hit the space bar between each character for
    // these to work.  Also, for either of these last two, you must end them
    // with '|' for the data to be valid.
    ln = new TInputLine(TRect(48, 17, 70, 18), 21,
        new TPXPictureValidator("|@|*[@|]", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(14, 17, 47, 18),
        "Separator example (lead with |):", ln));

    ln = new TInputLine(TRect(48, 18, 70, 19), 21,
        new TPXPictureValidator("@|*{@|}", True));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(11, 18, 47, 19),
        "Separator with no leading | needed:", ln));

    dlg->insert(new TButton(TRect(35, 20, 45, 22), "O~K~", cmOK, bfNormal));
    dlg->selectNext(False);

    // Initialize the data structure to blank fields.
    memset((void *)&dlgData, 0, sizeof(dialogData));

    // Step over this line and, upon return, examine the data structure.
    // You should see the new values you entered if you didn't hit ESC to
    // cancel the dialog box.
    executeDialog(dlg, &dlgData);
}

void TMyApp::doDerivedClassDemo(void)
{
    char *CityList[] = { "Spokane", "Seattle", "Tacoma", "Olympia", "Boise",
                         "Portland", "Las Vegas", "Dallas", "Houston", NULL };

    struct dataRec
    {
        short  Field1;
        ushort Field2;
        int    Field3;
        uint   Field4;
        long   Field5;
        double Field6;
        char   Field7[11];
        char   Field8[11];
    } dlgData;

    TDialog *dlg = new TDialog(TRect(16, 4, 64, 18), "Derived Validators");
    if(!dlg)
        return;

    dlg->options |= ofCentered;

    // The first five use the TNumericValidator class to return their data
    // as a true numeric type.  Note that the class will automatically set
    // its voTransfer bit so that you don't have to do it manually.  Also
    // note that the short and int types are each handled separately due to
    // the size difference in 32 bit protected mode.

    // The default type is set to nShort in the constructor of
    // TNumericValidator for this first one.
    TInputLine *ln = new TInputLine(TRect(33, 2, 45, 3), 11,
        new TNumericValidator(-50, 50));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(17, 2, 32, 3), "Numeric short:", ln));

    ln = new TInputLine(TRect(33, 3, 45, 4), 11,
        new TNumericValidator(0, 50, nUShort));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(8, 3, 32, 4), "Numeric unsigned short:", ln));

    ln = new TInputLine(TRect(33, 4, 45, 5), 11,
        new TNumericValidator(-50, 50, nInt));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(19, 4, 32, 5), "Numeric int:", ln));

    ln = new TInputLine(TRect(33, 5, 45, 6), 11,
        new TNumericValidator(0, 50, nUInt));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(10, 5, 32, 6), "Numeric unsigned int:", ln));

    // Unsigned long is not handled by this class because of the signed data
    // types above.
    ln = new TInputLine(TRect(33, 6, 45, 7), 11,
        new TNumericValidator(-500000, 500000, nLong));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(18, 6, 32, 7), "Numeric long:", ln));

    // This input line uses the TDoubleValidator to return the data as a
    // true type double value.  Again, it sets the voTransfer bit
    // automatically so that you don't have to.  Decimal places default to
    // two in the constructor.
    ln = new TInputLine(TRect(33, 7, 45, 8), 11,
        new TDoubleValidator(-19999.99, 19999.99));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(16, 7, 32, 8), "Numeric double:", ln));

    // A simple demonstration of the picture validator that allows an empty
    // (zero length) data string to be returned.  If data is entered, it must
    // still be in the proper format though.
    ln = new TInputLine(TRect(33, 8, 45, 9), 11,
        new TEmptyPXValidator("###-####"));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(2, 8, 32, 9),
        "Picture allowing empty field:", ln));

    // A string list validator that ignores case.  It fills the data string
    // with the properly cased text as you type.  Exact case matches are
    // given priority.  If one is not found, a search is made ignoring case.
    //
    // NOTE:  The string collection will be destroyed along with the
    //        input line when the dialog box is destroyed.
    //
    TStringCollection *Cities = new TStringCollection(5, 5);
    for(short i = 0; CityList[i]; i++)
        Cities->insert(CityList[i]);

    ln = new TInputLine(TRect(33, 9, 45, 10), 11,
        new TICStringLookupValidator(Cities));
    dlg->insert(ln);
    dlg->insert(new TLabel(TRect(2, 9, 32, 10),
        "Case insensitive string list:", ln));

    dlg->insert(new TButton(TRect(22, 11, 32, 13), "O~K~", cmOK, bfNormal));
    dlg->selectNext(False);

    // Initialize the data structure.
    dlgData.Field1 = 0;
    dlgData.Field2 = 0;
    dlgData.Field3 = 0;
    dlgData.Field4 = 0;
    dlgData.Field5 = 0;
    dlgData.Field6 = 0.0;
    dlgData.Field7[0] = dlgData.Field8[0] = EOS;

    // Step over this line and, upon return, examine the data structure.
    // You should see the new values you entered if you didn't hit ESC to
    // cancel the dialog box.
    executeDialog(dlg, &dlgData);
}

void main(void)
{
    TMyApp myApp;
    myApp.run();
    myApp.shutDown();
    exit(0);
}
