// File    : TDBLVAL.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 07/21/94 20:44:15
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// This is a derived TPXPictureValidator class that will allow TInputLine to
// return its data as a type double value.  It is derived from the
// TPXPictureValidator class to allow proper handling of +/- and placement
// of the decimal point and decimal place(s).  The picture is constructed
// internally.
//
// NOTE:  This class automatically sets the voTransfer bit so that the
//        data is automatically returned as a type double value.  To return
//        a character string, you must manually turn the bit off.  However,
//        turning it off makes the class not that much better than a basic
//        TPXPictureValidator.
//

#include <stdio.h>
#include <string.h>

#define Uses_MsgBox
#define Uses_TPXPictureValidator
#include <tv.h>

#define Uses_TDoubleValidator
#include <custmval.h>

// Error message string.  Decimal place formatting is dynamic.
const char * _NEAR TDoubleValidator::errorMsg =
    "Value not in the range %.*lf to %.*lf";

TDoubleValidator::TDoubleValidator(double aMin, double aMax,
  short aDecimals, Boolean autoFill) : TPXPictureValidator(NULL, autoFill),
    min(aMin),
    max(aMax),
    numDecimals(aDecimals)
{
    char picture[20];

    // Assume a type double value is to be returned.
    options |= voTransfer;

    // If min or max is less than zero, allow a sign.
    if(aMin < 0.0 || aMax < 0.0)
        strcpy(picture, "[+,-]");
    else
        picture[0] = EOS;

    // Add the picture allowing any number of digits to the right of
    // the decimal.
    strcat(picture, "*#");

    // If there are decimal places, add the necessary format characters
    // to handle them.  They are optional for entry though.
    if(aDecimals)
    {
        // A decimal point can be entered, but none of the actual digits
        // are required.
        strcat(picture, "[.[#]");

        while(--aDecimals)
            strcat(picture, "[#]");

        strcat(picture, "]");
    }

    // Now set the picture string.
    pic = newStr(picture);

    // Status *must* be set to vsOk here because the NULL picture
    // passed to the base TPXPictureValidator structure sets it to vsSyntax
    // which indicates an error.  If you leave it like that, validView()
    // interprets it as meaning something is wrong and the dialog
    // will not get executed.
    status = vsOk;
}

// Emulate the TRangeValidator error function.
void TDoubleValidator::error(void)
{
    messageBox(mfError | mfOKButton, errorMsg, numDecimals, min,
        numDecimals, max);
}

ushort TDoubleValidator::transfer(char* s, void* buffer, TVTransfer flag)
{
    double value;

    if(options & voTransfer)
    {
        switch ( flag )
        {
            case vtGetData:
                sscanf(s, "%lf", &value);
                *(double *)buffer = value;
                break;

            case vtSetData:
                sprintf(s, "%.*lf", numDecimals, *(double *)buffer);
                break;
        }
        return sizeof(double);
    }

    return 0;
}

Boolean TDoubleValidator::isValid(const char* s)
{
    double value;

    sscanf(s, "%lf", &value);

    // See if it's within limits.
    if(value < min || value > max)
        return False;

    // If it is, let the bas TPXPictureValidator have its say.
    return TPXPictureValidator::isValid(s);
}

#if !defined(NO_STREAMABLE)

TDoubleValidator::TDoubleValidator( StreamableInit s) : TPXPictureValidator(s)
{
}

void TDoubleValidator::write(opstream& os)
{
    TPXPictureValidator::write( os );
    os << min << max << numDecimals;
}

void *TDoubleValidator::read( ipstream& is )
{
    TPXPictureValidator::read( is );
    is >> min >> max >> numDecimals;
    return this;
}

TStreamable *TDoubleValidator::build()
{
    return new TDoubleValidator( streamableInit );
}

#endif
