// File    : SCUSTVAL.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 07/21/94 20:44:05
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// This file contains the stream manager registration objects for the
// custom validator classes.
//

#if !defined(NO_STREAMABLE)

#define Uses_TRangeValidator
#define Uses_TPXPictureValidator
#define Uses_TStringLookupValidator
#define Uses_TStreamableClass
#include <tv.h>

#define Uses_TNumericValidator
#define Uses_TEmptyPXValidator
#define Uses_TDoubleValidator
#define Uses_TICStringLookupValidator
#include <custmval.h>

__link(RRangeValidator)
__link(RPXPictureValidator)
__link(RStringLookupValidator)

TStreamableClass RNumericValidator( TNumericValidator::name,
    TNumericValidator::build, __DELTA(TNumericValidator));

TStreamableClass REmptyPXValidator( TEmptyPXValidator::name,
    TEmptyPXValidator::build, __DELTA(TEmptyPXValidator));

TStreamableClass RDoubleValidator( TDoubleValidator::name,
    TDoubleValidator::build, __DELTA(TDoubleValidator));

TStreamableClass RICStringLookupValidator( TICStringLookupValidator::name,
    TICStringLookupValidator::build, __DELTA(TICStringLookupValidator));

#endif
