// File    : MTPICVAL.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 07/21/94 20:43:43
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// This is identical to the standard TPXPictureValidator class, but it will
// allow an empty (zero length) field to be considered valid.
//

#include <string.h>

#define Uses_TPXPictureValidator
#include <tv.h>

#define Uses_TEmptyPXValidator
#include <custmval.h>

// This is the only function that needs overriding to allow empty fields
// to be valid.
Boolean TEmptyPXValidator::isValid(const char* s)
{
    char str[256];
    strcpy(str, s);

    if(pic)
    {
        TPicResult result = picture(str, False);

        // If it isn't empty and it isn't complete return False.
        if(result != prEmpty && result != prComplete)
            return False;
    }
    return True;
}

#if !defined(NO_STREAMABLE)

// The read() and write() functions are not overridden because no new data
// members where added to this class.
TEmptyPXValidator::TEmptyPXValidator( StreamableInit s) : TPXPictureValidator(s)
{
}

TStreamable *TEmptyPXValidator::build()
{
    return new TEmptyPXValidator( streamableInit );
}

#endif
