// File    : ICSTRVAL.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 07/21/94 20:43:36
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// This string validator class will ignore case when looking for a match.
// Also, if it finds one, it will copy the correctly formatted data to the
// input line's data.
//

#include <string.h>

#define Uses_TStringLookupValidator
#include <tv.h>

#define Uses_TICStringLookupValidator
#include <custmval.h>

// The data searched for always ends up as parameter a2.
static Boolean partialMatchCase(void* a1, void* a2)
{
    return Boolean(strncmp((const char*)a1, (const char*)a2,
        strlen((const char *)a2)) == 0);
}

// The data searched for always ends up as parameter a2.
static Boolean partialMatchNoCase(void* a1, void* a2)
{
    return Boolean(strnicmp((const char*)a1, (const char*)a2,
        strlen((const char *)a2)) == 0);
}

#pragma argsused
Boolean TICStringLookupValidator::isValidInput(char *s, Boolean suppressFill)
{
    // Search for a partial match with exact case first.
    char *match = (char *)strings->firstThat(partialMatchCase, (void *)s);

    if(match)
        return True;

    // An exact case match wasn't found, so search for a partial match
    // ignoring case.
    match = (char *)strings->firstThat(partialMatchNoCase, (void *)s);
    if(match)
    {
        // Copy the partial, properly cased text to the input string.
        strncpy(s, match, strlen(s));
        return True;
    }

    return False;   // No match found.
}

#if !defined(NO_STREAMABLE)

// The read() and write() functions are not overridden because no new data
// members where added to this class.
TICStringLookupValidator::TICStringLookupValidator( StreamableInit s) :
    TStringLookupValidator(s)
{
}

TStreamable *TICStringLookupValidator::build()
{
    return new TICStringLookupValidator( streamableInit );
}

#endif
