// File    : CUSTMVAL.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 07/21/94 20:42:42
// Note    : Hereby declared public domain
// Compiler: Borland C++ 4.02
//
// This is the header file for the custom validators.
//

#if !defined(__CUSTMVAL_H)
#define __CUSTMVAL_H

#if defined(Uses_TNumericValidator)

enum numType { nShort, nUShort, nInt, nUInt, nLong };

class TNumericValidator : public TPXPictureValidator
{
private:
    static const char * _NEAR errorMsg;

protected:
    long    min, max;
    numType type;       // Type of value to return when voTransfer is set.

public:
    TNumericValidator(long aMin, long aMax, numType aType = nShort,
        Boolean autoFill = True);

    virtual Boolean isValid(const char* s);
    virtual ushort transfer(char* s, void* buffer, TVTransfer flag);
    virtual void error(void);

protected:
    TNumericValidator( StreamableInit );
    virtual void write( opstream& os );
    virtual void* read( ipstream& is );

private:
    virtual const char *streamableName() const  { return name; };

public:
    static TStreamable *build();
    static const char * const _NEAR name;
};

inline ipstream& operator >> ( ipstream& is, TNumericValidator& v )
    { return is >> (TStreamable&)v; }
inline ipstream& operator >> ( ipstream& is, TNumericValidator*& v )
    { return is >> (void *&)v; }

inline opstream& operator << ( opstream& os, TNumericValidator& v )
    { return os << (TStreamable&)v; }
inline opstream& operator << ( opstream& os, TNumericValidator* v )
    { return os << (TStreamable *)v; }

#endif  // TNumericValidator

#if defined(Uses_TDoubleValidator)

class TDoubleValidator : public TPXPictureValidator
{
private:
    static const char * _NEAR errorMsg;

protected:
    double min, max;
    short  numDecimals;

public:
    TDoubleValidator(double aMin, double aMax, short aDecimals = 2,
        Boolean autoFill = True);

    virtual Boolean isValid(const char* s);
    virtual ushort transfer(char* s, void* buffer, TVTransfer flag);
    virtual void error(void);

protected:
    TDoubleValidator( StreamableInit );
    virtual void write( opstream& os );
    virtual void* read( ipstream& is );

private:
    virtual const char *streamableName() const  { return name; };

public:
    static TStreamable *build();
    static const char * const _NEAR name;
};

inline ipstream& operator >> ( ipstream& is, TDoubleValidator& v )
    { return is >> (TStreamable&)v; }
inline ipstream& operator >> ( ipstream& is, TDoubleValidator*& v )
    { return is >> (void *&)v; }

inline opstream& operator << ( opstream& os, TDoubleValidator& v )
    { return os << (TStreamable&)v; }
inline opstream& operator << ( opstream& os, TDoubleValidator* v )
    { return os << (TStreamable *)v; }

#endif  // TDoubleValidator

#if defined(Uses_TEmptyPXValidator)

class TEmptyPXValidator : public TPXPictureValidator
{
public:
    TEmptyPXValidator(const char* aPic, Boolean autoFill = True) :
        TPXPictureValidator(aPic, autoFill) {}

    virtual Boolean isValid(const char* s);

protected:
    TEmptyPXValidator( StreamableInit );

private:
    virtual const char *streamableName() const  { return name; };

public:
    static TStreamable *build();
    static const char * const _NEAR name;
};

inline ipstream& operator >> ( ipstream& is, TEmptyPXValidator& v )
    { return is >> (TStreamable&)v; }
inline ipstream& operator >> ( ipstream& is, TEmptyPXValidator*& v )
    { return is >> (void *&)v; }

inline opstream& operator << ( opstream& os, TEmptyPXValidator& v )
    { return os << (TStreamable&)v; }
inline opstream& operator << ( opstream& os, TEmptyPXValidator* v )
    { return os << (TStreamable *)v; }

#endif  // TEmptyPXValidator

#if defined(Uses_TICStringLookupValidator)

class TICStringLookupValidator : public TStringLookupValidator
{
public:
    TICStringLookupValidator(TStringCollection *aStrings) :
        TStringLookupValidator(aStrings) {}

    Boolean isValidInput(char *s, Boolean suppressFill);

protected:
    TICStringLookupValidator( StreamableInit );

private:
    virtual const char *streamableName() const  { return name; };

public:
    static TStreamable *build();
    static const char * const _NEAR name;
};

inline ipstream& operator >> ( ipstream& is, TICStringLookupValidator& v )
    { return is >> (TStreamable&)v; }
inline ipstream& operator >> ( ipstream& is, TICStringLookupValidator*& v )
    { return is >> (void *&)v; }

inline opstream& operator << ( opstream& os, TICStringLookupValidator& v )
    { return os << (TStreamable&)v; }
inline opstream& operator << ( opstream& os, TICStringLookupValidator* v )
    { return os << (TStreamable *)v; }

#endif  // TICStringLookupValidator

#endif  // __CUSTMVAL.H
