
/****************************************************************
***********\
 *  tswit.c  -- iRMX II task switch time measurement.
 *  Compiler: iC-286 V4.1 (LARGE model). Q1 1989, by R. P. Kar
\****************************************************************
**********/

#include <stdio.h>
#include <rmxc.h>

#define MAX_LOOPS 500000L

unsigned       el_time, pri, status;
unsigned long  strt_sec, end_sec;
selector       task1_t, task2_t;
unsigned long  count1, count2;
float          ts_time;

/* "union" used to decompose a pointer into segment:offset */
typedef struct {unsigned offset; selector sel;} ptr_s;
union { unsigned *pointer; ptr_s ptr; } ptr_u;

void task1()
{
  for (count1 = 0; count1 < MAX_LOOPS; count1++)
    rqsleep(0, &status);                    /* Task switch happens
here */
  rqdeletetask(NULL, &status);                           /* delete
self */
}

void task2()
{
  for (count2 = 0; count2 < MAX_LOOPS; count2++)
    rqsleep(0, &status);                   /* Task switch happens
here */
  rqdeletetask(NULL, &status);                          /* delete
self */
}

/*************************  MAIN PROGRAM 
*************************/

main()
{

printf("\nTask Switch measurement\n   Each task runs %D
times...\n\n",
           MAX_LOOPS);

/* Measure execution time of task1 and task2 when they are executed
   serially (without task switching). */
strt_sec = rqgettime(&status);                   /* Start of timing
period */

  for (count1 = 0; count1 < MAX_LOOPS; count1++)
    /* rqsleep(0, &status) */ ;
  for (count2 = 0; count2 < MAX_LOOPS; count2++)
    /* rqsleep(0, &status) */ ;
end_sec = rqgettime(&status);                      /* End of timing
period */

el_time = (unsigned)(end_sec - strt_sec);

/* Place a pointer to any variable in union "ptr_u", so the data
segment
   of this program becomes known. */
ptr_u.pointer = &status;

/* Get main program's priority level */
pri = rqgetpriority (NULL, &status);

/* Create two (identical) tasks, which just switch between
themselves */
task1_t = rqcreatetask (pri+1, task1, ptr_u.ptr.sel, 0L, 512, 0,
&status);
if (status != 0) printf("rqcreatetask error\n");

task2_t = rqcreatetask (pri+1, task2, ptr_u.ptr.sel, 0L, 512, 0,
&status);
strt_sec = rqgettime(&status);                  /* Start of timing
period */

/* Set main program's priority below task 1,2 so they run to
completion */
rqsetpriority( (selector)0, pri+2, &status );
rqsleep( 0, &status );

end_sec = rqgettime(&status);                     /* End of timing
period */

/* Set main program back to initial priority */
rqsetpriority( (selector)0, pri, &status );

el_time = (unsigned)(end_sec - strt_sec) - el_time;
ts_time = ( (float)el_time * 1000000.0 ) / ((float)MAX_LOOPS * 2.0)
;
printf("   Task switch time = %5.1f microseconds\n", ts_time);
dqexit(0);
}

