/*
	cp.C

	Version 1.1

	Copy & Paste

	Copyright (C) 1993, Geoff Friesen B.Sc.
	All rights reserved.

	Developed with: Borland C++ 3.1
*/

/*
	set ti=c:\borlandc\include
	t cp k 300 x

	The first line sets the ti environment variable to the
	include file path.  Since cp.C makes reference to the
	DOS.H and STDARG.H header files, the set statement is
	necessary.  It is assumed that DOS.H and STDARG.H are
	included in this directory.

	T invokes the t batch file.  The default hotkey letter
	is being set to k.  We are leaving 300 bytes for stack
	space.  An x (or any other character combination) fol-
	lowing the stack size indicates that we want setup and
	cleanup function calls included in the TSR result (the
	TSR utility is responsible for inserting these calls).

	Note: Memory location 0040:0084 contains the number of
	screen rows less one for the current video mode.  This
	value may not be correct in certain screen modes.
*/

#pragma inline

#if !defined(__TINY__)
#error Tiny Memory Model Expected
#endif

char *title = "\r\n"
	      "ͻ\r\n"
	      " CP v1.1  Copy & Paste                  \r\n"
	      "                                         \r\n"
	      " Copyright (C) 1993, Geoff Friesen B.Sc. \r\n"
	      " All rights reserved.                    \r\n"
	      "ͼ\r\n"
	      "$";

#include <dos.H>
#include <stdarg.H>

#define	CR	0x000d
#define	ESC	0x001b
#define	HOME	0x4700
#define	UP	0x4800
#define LEFT	0x4b00
#define	RIGHT	0x4d00
#define	END	0x4f00
#define	DOWN	0x5000

#define	MDA		0
#define	CGA		1
#define	EGA_BW		2
#define	EGA_COLOR	3
#define	VGA_BW		4
#define	VGA_COLOR	5

#define	BW80		2
#define	C80		3
#define	MONO		7

#define	LIGHTGRAY	7

#define	SCREEN_SAVE	0
#define	SCREEN_RESTORE	1

#define	CBLOCK		1
#define	CHIDE		2
#define	CLINE		4
#define	CSAVE		8
#define	CRESTORE	16
#define	CSETFUNC	32

#define VIDEO_INT       asm { \
				push bp; \
				int 10h; \
				pop bp; \
			}

int attribute = LIGHTGRAY;
int cmdlist;
void (*cfunc) (int cmd, ...);

#define IGNORE 0

char buffer [8000];             /* buffer used as clipboard         */
char *buff_head = buffer;
char *buff_tail = buffer;
char paste = 0;                 /* flag used to signal ints ...    */
				/* ... that pasting is required    */

void    cleanup         (void);
int	k_fetch		(void);
void    read_window     (int action, int left, int top, int right,
			 int bottom);
void    reverse_video   (int col, int row);
void    send_char       (int action, int c);
int     setup           (void);
int	upper		(int c);
int	v_aa		(void);
void	v_cursor	(int cmd, ...);
int	v_getmode	(void);
int	v_getshape	(void);
void	v_gotoxy	(int x, int y);
void	v_screen	(int cmd, int x, int y, int nx, int ny,
			 void *buffer);
void	v_setshape	(int shape);
int	v_wherex	(void);
int	v_wherey	(void);

void interrupt int9 (void);
void interrupt (*oldint9) (void);
void interrupt int1c (void);
void interrupt (*oldint1c) (void);

void main (void)
{
   int key, mode, shape, x, y;
   int left = 1, top = 1, right = 80, bottom, col, row, rows;

   if ((bottom = rows = peekb (0x40, 0x84)+1) > 50)
       return;

   mode = v_getmode ();
   if (mode != BW80 && mode != C80 && mode != MONO)
       return;

   v_cursor (CSAVE, &shape);
   v_cursor (CHIDE);

   x = v_wherex ();
   y = v_wherey ();

   do
   {
      reverse_video (left, top);

      key = upper (k_fetch ());

      reverse_video (left, top);

      if (key == ESC)
	  break;

      if (key == LEFT)
      {
	  if (--left < 1)
	      left = 80;
	  continue;
      }

      if (key == RIGHT)
      {
	  if (++left > 80)
	      left = 1;
	  continue;
      }

      if (key == UP)
      {
	  if (--top < 1)
	      top = rows;
	  continue;
      }

      if (key == DOWN)
      {
	  if (++top > rows)
	      top = 1;
	  continue;
      }

      if (key == HOME)
      {
	  top = 1;
	  left = 1;
	  continue;
      }

      if (key == END)
      {
	  top = rows;
	  left = 80;
	  continue;
      }

      if (key == 'P')
      {
	  disable();
	  paste = (buff_head == buff_tail) ? 0 : 1;
	  enable();
	  break;
      }

      if (key != CR)
	  continue;

      bottom = top;
      right = left;
      reverse_video (left, top); /* highlight block at (top,left) */

      do
      {
	 col = right;
	 row = bottom;

	 if ((key = upper (k_fetch ())) == UP)
	 {
	     if (--row < top)
		 continue;
	     bottom = row++;
	 }

	 if (key == DOWN)
	 {
	     if (++row > rows)
		 continue;
	     bottom = row;
	 }

	 if (key == UP || key == DOWN)
	 {
	     do
	     {
		 reverse_video (col--, row);
	     }
	     while (col >= left);
	     continue;
	 }

	 if (key == LEFT)
	 {
	     if (--col < left)
		 continue;
	     right = col++;
	 }

	 if (key == RIGHT)
	 {
	     if (++col > 80)
		 continue;
	     right = col;
	 }

	 if (key == LEFT || key == RIGHT)
	 {
	     do
	     {
		 reverse_video (col, row--);
	     }
	     while (row >= top);
	     continue;
	 }

	 if (key == ESC)
	 {
	     read_window (IGNORE, left, top, right, bottom);
	     break;
	 }

	 if (key == 'C')
	 {
	     read_window (!IGNORE, left, top, right, bottom);
	     break;
	 }
      }
      while (1);

      break;
   }
   while (1);

   v_gotoxy (x, y);
   v_cursor (CRESTORE, shape);
}

void cleanup (void)
{
   asm push ds

   asm push es
   asm pop ds

   asm mov ax, 2509h
   asm lds dx, oldint9
   asm int 21h

   asm push es
   asm pop ds

   asm mov ax, 251ch
   asm lds dx, oldint1c
   asm int 21h

   asm pop ds
}

void interrupt far (*getvect (int intr_num)) ()
{
   asm mov ah, 35h
   asm mov al, intr_num
   asm int 21h

   asm mov ax, bx
   asm mov dx, es
}

int k_fetch (void)
{
   asm mov ah, 0
   asm int 16h

   asm or al, al
   asm jz k_fetch1

   asm xor ah, ah

k_fetch1:;

}

void read_window (int action, int left, int top,
			 int right, int bottom)
{
   char buf [2];
   int c, col, row;

   buff_tail = buffer;

   for (row = top; row <= bottom; row++)
   {
	for (col = left; col <= right; col++)
	{
	     reverse_video (col, row);
	     v_screen (SCREEN_SAVE, col, row, 1, 1, buf);
	     c = *buf & 255;
	     if (c != CR)
		 send_char (action, c);
	}
	send_char (action, CR);
   }
}

void reverse_video (int col, int row)
{
   char buffer [2];

   v_screen (SCREEN_SAVE, col, row, 1, 1, buffer);
   buffer [1] = ~buffer [1];
   v_screen (SCREEN_RESTORE, col, row, 1, 1, buffer);
}

void send_char (int action, int c)
{
   if (action != IGNORE)
       *buff_tail++ = c;
}

int setup (void)
{
   oldint9 = getvect (0x9);     /* redirect int 9h */
   asm mov ax, 2509h
   asm lea dx, _int9
   asm int 21h

   oldint1c = getvect (0x1c);   /* redirect int 1ch */
   asm mov ax, 251ch
   asm lea dx, _int1c
   asm int 21h

   return 0;
}

int upper (int c)
{
   return (c >= 'a' && c <= 'z') ? c-32 : c;
}

int v_aa (void)
{
   asm mov ax,1a00h             /* Check for VGA */
   VIDEO_INT

   asm cmp al, 1ah              /* Found VGA? */
   asm jnz v_aa1                /* No, branch */

   asm cmp bl, 7                /* Active VGA connected to BW monitor? */
   asm jz v_aa4                 /* Yes, branch */

   asm cmp bl, 8                /* Active VGA connected to COL monitor? */
   asm jz v_aa3                 /* Yes, branch */

v_aa1:

   asm mov ah, 12h              /* Check for EGA */
   asm mov bl, 10h
   VIDEO_INT

   asm cmp bl, 10h              /* Found EGA? */
   asm jz v_aa2                 /* No, branch */

   asm mov ax, 0
   asm mov es, ax

   asm test BYTE PTR es:[487h], 8       /* EGA active? */
   asm jnz v_aa2                /* No, branch */

   asm test WORD PTR es:[463h], 40h     /* BW or COLOR monitor? */
   asm jnz v_aa5                /* Branch if COLOR */

   asm jmp SHORT v_aa6          /* Must be BW */

v_aa2:

   asm mov ax, 0
   asm mov es, ax

   asm test WORD PTR es:[463h], 40h     /* CGA? */
   asm jnz v_aa7                /* Yes, branch */

   asm jmp SHORT v_aa8          /* Must be MDA */

v_aa3:

   asm mov ax, VGA_COLOR
   asm jmp SHORT v_aa9

v_aa4:

   asm mov ax, VGA_BW
   asm jmp SHORT v_aa9

v_aa5:

   asm mov ax, EGA_COLOR
   asm jmp SHORT v_aa9

v_aa6:

   asm mov ax, EGA_BW
   asm jmp SHORT v_aa9

v_aa7:

   asm mov ax, CGA
   asm jmp SHORT v_aa9

v_aa8:

   asm mov ax, MDA

v_aa9:

   return _AX;
}

void v_cursor (int cmd, ...)
{
   int aa, ax;
   va_list ap;

   if (cmd == CSETFUNC)
   {
       va_start(ap, cmd);
       cfunc = va_arg(ap, void *);
       cmdlist = (cfunc) ? va_arg(ap, int) : 0;
       va_end(ap);
       return;
   }

   if (cfunc && cmdlist & cmd)
   {
       va_start(ap, cmd);
       (*cfunc) (cmd, ap);
       va_end(ap);
       return;
   }

   va_start(ap, cmd);

   aa = v_aa ();

   switch (cmd)
   {
      case CBLOCK   : if (aa == EGA_BW || aa == EGA_COLOR)
			  v_setshape (0x001e);
		      else
			  v_setshape ((aa == MDA) ? 0x000d : 0x0007);
		      break;

      case CHIDE    : v_setshape (0x2000);
		      break;

      case CLINE    : if (aa == EGA_BW || aa == EGA_COLOR)
		      {
			  asm mov ax, 1130h
			  VIDEO_INT

			  asm dec cx
			  asm dec cx

			  asm xor ax, ax
			  asm mov ah, cl

			  ax = _AX;

			  v_setshape (ax);
		      }
		      else
			  v_setshape ((aa == MDA) ? 0x0c0d : 0x0607);
		      break;

      case CSAVE    : *va_arg(ap, int *) = v_getshape ();
		      break;

      case CRESTORE : v_setshape (va_arg(ap, int));
   }

   va_end(ap);
}

int v_getmode (void)
{
   asm mov ah, 15
   VIDEO_INT
   asm mov ah, 0
}

int v_getshape (void)
{
   asm mov ah, 3
   VIDEO_INT
   asm mov ax, cx
}

void v_gotoxy (int x, int y)
{
   asm mov bx, 0
   asm mov es, bx

   asm mov ah, 2
   asm mov bh, es:[462h]

   asm mov dh, y
   asm add dh, -1

   asm mov dl, x
   asm add dl, -1

   VIDEO_INT
}

void v_screen (int cmd, int x, int y, int nx, int ny, void *buffer)
{
   int cols;
   char mode, page;

   asm push ds

   asm mov ah, 15
   VIDEO_INT

   asm mov mode, al
   asm mov BYTE PTR cols, ah
   asm mov BYTE PTR cols [1], 0
   asm shl WORD PTR cols, 1
   asm mov page, bh

   asm push ds
   asm pop es

   asm mov ax, 0b000h
   asm cmp BYTE PTR mode, MONO
   asm jz v_screen0

   asm add ah, page
   asm add ah, 8

v_screen0:

   asm mov si, ax

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen1

   asm mov ds, si
   asm sub si, si
   asm mov di, buffer
   asm jmp SHORT v_screen2

v_screen1:

   asm mov es, si
   asm sub di, di
   asm mov si, buffer

v_screen2:

   asm mov ax, y
   asm dec ax
   asm mov cx, cols
   asm mul cx
   asm mov cx, x
   asm dec cx
   asm shl cx, 1
   asm add ax, cx

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen3

   asm add si, ax
   asm jmp SHORT v_screen4

v_screen3:

   asm add di, ax

v_screen4:

   asm mov bx, ny
   asm mov cx, nx
   asm cld

v_screen5:

   asm rep movsw

   asm dec bx
   asm jz v_screen7

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen6

   asm sub si, nx
   asm sub si, nx
   asm add si, cols
   asm mov cx, nx
   asm jmp SHORT v_screen5

v_screen6:

   asm sub di, nx
   asm sub di, nx
   asm add di, cols
   asm mov cx, nx
   asm jmp SHORT v_screen5

v_screen7:

   asm pop ds
}

void v_setshape (int shape)
{
   asm mov ah, 1
   asm mov cx, shape
   VIDEO_INT
}

int v_wherex (void)
{
   asm mov bx, 0
   asm mov es, bx
   asm mov bl, es:[462h]
   asm shl bx, 1
   asm mov al, es:[bx+450h]
   asm sub ah, ah
   asm inc ax
}

int v_wherey (void)
{
   asm mov bx, 0
   asm mov es, bx
   asm mov bl, es:[462h]
   asm shl bx, 1
   asm mov al, es:[bx+451h]
   asm sub ah, ah
   asm inc ax
}

void interrupt int9 (void)
{
   asm cmp BYTE PTR cs:_paste, 0
   asm jnz int9_1

   asm pushf
   asm call DWORD PTR cs:_oldint9

   return;

int9_1:

   asm push ax

   asm in al, 60h

   asm cmp al, 1
   asm jnz int9_2

   asm mov BYTE PTR cs:_paste, 0
   asm mov WORD PTR cs:_buff_head, OFFSET _buffer
   asm mov WORD PTR cs:_buff_tail, OFFSET _buffer

int9_2:

   asm in al, 61h
   asm jmp $+2
   asm mov ah, al
   asm or al, 10000000b
   asm out 61h, al
   asm jmp $+2
   asm mov al, ah
   asm out 61h, al
   asm jmp $+2

   asm mov al, 20h
   asm out 20h, al

   asm pop ax
}

void interrupt int1c (void)
{
   (*oldint1c) ();

   if (!paste)
       return;

   if (buff_head < buff_tail)
   {
       asm mov ax, 40h
       asm mov es, ax

       asm mov bx, cs:_buff_head
       asm mov al, cs:[bx]

       asm mov cx, es:[1ah]
       asm mov dx, es:[1ch]

       asm inc dx
       asm inc dx

       asm cmp dx, es:[82h]
       asm jnz int1c_1

       asm mov dx, es:[80h]

int1c_1:

       asm cmp cx, dx
       asm jz int1c_2

       asm mov di, es:[1ch]
       asm mov es:[di], ax

       asm mov es:[1ch], dx

       asm inc bx
       asm mov cs:_buff_head, bx

int1c_2:

   }
   else
   {
       paste = 0;
       buff_head = buff_tail = buffer;
   }
}