/*
	cc.C

	Version 1.1

	Clock Calendar

	Sample TSR for TSRLIB v1.1

	Copyright (C) 1993, Geoff Friesen B.Sc.
	All rights reserved.

	Developed with: Borland C++ 3.1
*/

/*
	set ti=c:\borlandc\include
	t cc c

	The first line sets the ti environment variable to the
	include file path.  Since cc.C makes reference to the
	DOS.H header file, the set statement is necessary.  It
	is assumed that DOS.H is included in this directory.

	T invokes the t batch file.  The default hotkey letter
	is being set to c.

	Note: Memory location 0040:0084 contains the number of
	screen rows less one for the current video mode.  This
	value may not be correct in certain screen modes.
*/

#pragma inline

#if !defined(__TINY__)
#error Tiny Memory Model Expected
#endif

char *title = "\r\n"
	      "ͻ\r\n"
	      " CC v1.1  Clock Calendar                \r\n"
	      "                                         \r\n"
	      " Copyright (C) 1993, Geoff Friesen B.Sc. \r\n"
	      " All rights reserved.                    \r\n"
	      "ͼ\r\n"
	      "$";

#include <dos.H>

#define BW80            2
#define C80             3
#define MONO            7

#define BLACK           0
#define BLUE            1
#define GREEN           2
#define CYAN            3
#define RED             4
#define MAGENTA         5
#define BROWN           6
#define LIGHTGRAY       7

#define DARKGRAY        8
#define LIGHTBLUE       9
#define LIGHTGREEN      10
#define LIGHTCYAN       11
#define LIGHTRED        12
#define LIGHTMAGENTA    13
#define YELLOW          14
#define WHITE           15

#define BLINK           128

#define SINGLE_LINE     0
#define DOUBLE_LINE     1
#define BLOCK_LINE      2

#define SCREEN_SAVE     0
#define SCREEN_RESTORE  1

#define VIDEO_INT       asm { \
				push bp; \
				int 10h; \
				pop bp; \
			}

int attribute = LIGHTGRAY;

#define NATTR   5

int attr [NATTR];

int bw [] =
{
   WHITE,                               /* clock */
   (LIGHTGRAY << 4) | BLACK,            /* calendar back */
   WHITE,                               /* month */
   WHITE,                               /* year */
   WHITE                                /* current day */
};

int color [] =
{
   LIGHTGREEN,                          /* clock */
   (CYAN << 4) | BLACK,                 /* calendar back */
   LIGHTMAGENTA,                        /* month */
   LIGHTGREEN,                          /* year */
   YELLOW                               /* current day */
};

char clock_template [] = " 00:00:00  M ";

char *cal_template [] =
{
     "ͻ",
     "                                         ",
     "                                         ",
     " SUN   MON   TUE   WED   THU   FRI   SAT ",
     "͹",
     "                                   ",
     "Ķ",
     "                                   ",
     "Ķ",
     "                                   ",
     "Ķ",
     "                                   ",
     "Ķ",
     "                                   ",
     "Ķ",
     "                                      ",
     "ͼ"
};

#define NCOLS   43
#define NROWS   17

int column = (80-NCOLS)/2, row;

char buffer [(NCOLS+1)*(NROWS+1)*2];

int oldyear = 0;
int oldmonth = 0;
int oldday = 0;

char *months [] =
{
   "January",
   "February",
   "March",
   "April",
   "May",
   "June",
   "July",
   "August",
   "September",
   "October",
   "November",
   "December"
};

int days [] =
{
   31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};

void    draw_cal        (struct date *d);
void    draw_clock      (struct time *t);
int     fday            (int year, int month);
int     iskey           (void);
int     isleap          (int year);
int     strlen          (char *s);
void    update_cursor   (void);
int     v_cputs         (const char *str);
int     v_getmode       (void);
int     v_getshape      (void);
void    v_gotoxy        (int x, int y);
void    v_screen        (int cmd, int x, int y, int nx, int ny,
			 void *buffer);
void    v_setattr       (int attr);
void    v_setshape      (int shape);
void    v_shadow        (int x, int y, int nx, int ny);
int     v_wherex        (void);
int     v_wherey        (void);
void    write_day       (int year, int month, int day);
void    write_month     (int month);
void    write_year      (int year);

void main (void)
{
   struct date d;
   struct time t;
   int cshape, i, vmode, x, y;

   if ((vmode = v_getmode ()) != BW80 && vmode != C80 && vmode != MONO)
       return;

   row = (peekb(0x40, 0x84)+1-NROWS) >> 1;

   for (i = 0; i < NATTR; i++)
	attr [i] = (vmode == C80) ? color [i] : bw [i];

   cshape = v_getshape ();
   v_setshape (0x2000);         /* hide cursor */

   x = v_wherex ();
   y = v_wherey ();

   v_screen (SCREEN_SAVE, column, row, NCOLS+1, NROWS+1, buffer);

   while (1)
   {
      getdate (&d);
      draw_cal (&d);

      gettime (&t);
      draw_clock (&t);

      if (iskey ())
      {
	  asm mov ah, 0
	  asm int 16h

	  break;
      }
   }

   v_screen (SCREEN_RESTORE, column, row, NCOLS+1, NROWS+1, buffer);
   v_gotoxy (x, y);
   v_setshape (cshape);

   oldyear = oldmonth = oldday = 0;
}

void draw_cal (struct date *d)
{
   int i;

   if (d->da_year == oldyear && d->da_mon == oldmonth
       && d->da_day == oldday)
       return;

   v_setattr (attr [1]);

   for (i = 0; i < NROWS; i++)
   {
	v_gotoxy (column, row+i);
	v_cputs (cal_template [i]);
   }

   v_shadow (column, row, NCOLS, NROWS);

   write_year (d->da_year);
   write_month (d->da_mon);
   write_day (d->da_year, d->da_mon, d->da_day);

   oldyear = d->da_year;
   oldmonth = d->da_mon;
   oldday = d->da_day;
}

void draw_clock (struct time *t)
{
   clock_template [10] = (t->ti_hour < 12) ? 'A' : 'P';

   if (!t->ti_hour)
       t->ti_hour = 12;
   else
       if (t->ti_hour > 12)
	   t->ti_hour -=12;

   clock_template [1] = t->ti_hour / 10 + ((t->ti_hour < 10) ? ' ' : '0');
   clock_template [2] = t->ti_hour % 10 + '0';

   clock_template [4] = t->ti_min / 10 + '0';
   clock_template [5] = t->ti_min % 10 + '0';

   clock_template [7] = t->ti_sec / 10 + '0';
   clock_template [8] = t->ti_sec % 10 + '0';

   v_setattr (attr [0]);
   v_gotoxy (column+NCOLS-19, row+NROWS-2);
   v_cputs (clock_template);
}

int fday (int year, int month)
{
   int i, d = 0;

   for (i = 1583; i < year; i++)
   {
	if (isleap (i))
	    d += 366;
	else
	    d += 365;

	d %= 7;
   }

   for (i = 1; i < month; i++)
   {
	d += days [i-1];
	if (i == 2 && isleap (year))
	    d++;

	d %= 7;
   }

   if (!d)
       d = 7;

   return (d-1);
}

void getdate (struct date *dateblk)
{
   asm mov ah, 2ah
   asm int 21h

   asm mov bx, dateblk
   asm mov [bx], cx
   asm mov [bx+2], dx
}

void gettime (struct time *timeblk)
{
   asm mov ah, 2ch
   asm int 21h

   asm mov bx, timeblk
   asm mov [bx], cx
   asm mov [bx+2], dx
}

int iskey (void)
{
   asm mov ah, 1
   asm int 16h
   asm jnz iskey1

   asm mov ax, 0

iskey1:;

}

int isleap (int year)
{
   return (!(year & 3) && year % 100 || !(year % 400));
}

int strlen (char *s)
{
   int count = 0;

   while (*s++)
      count++;

   return count;
}

void update_cursor (void)
{
   asm mov bx, 0
   asm mov es, bx

   asm mov ax, di
   asm mov bl, es:[44ah]
   asm shl bl, 1
   asm div bl

   asm mov dh, al
   asm mov dl, ah
   asm shr dl, 1

   asm mov ah, 2
   asm mov bh, es:[462h]

   VIDEO_INT
}

int v_cputs (const char *str)
{
   if (!*str)
       return 0;

   asm push ds

   asm mov dx, 0b000h

   asm mov bx, 0
   asm mov es, bx
   asm mov di, bx

   asm mov bl, es:[462h]

   asm cmp BYTE PTR es:[449h], MONO
   asm jz v_cputs1

   asm add dh, 8
   asm add dh, bl

v_cputs1:

   asm shl bx, 1

   asm mov cl, es:[bx+451h]
   asm or cl, cl
   asm jz v_cputs3

   asm mov ch, 0

   asm mov al, es:[44ah]
   asm mov ah, 0
   asm shl ax, 1

v_cputs2:

   asm add di, ax
   asm loop v_cputs2

v_cputs3:

   asm mov al, es:[bx+450h]
   asm mov ah, 0
   asm shl ax, 1
   asm add di, ax

   asm mov es, dx
   asm mov si, str
   asm mov ah, BYTE PTR attribute
   asm cld

v_cputs4:

   asm lodsb
   asm cmp al, 0
   asm jz v_cputs5

   asm stosw
   asm jmp SHORT v_cputs4

v_cputs5:

   update_cursor ();

   asm dec si
   asm dec si
   asm lodsb
   asm mov ah, 0

   asm pop ds
}

int v_getmode (void)
{
   asm mov ah, 15
   VIDEO_INT
   asm mov ah, 0
}

int v_getshape (void)
{
   asm mov ah, 3
   VIDEO_INT
   asm mov ax, cx
}

void v_gotoxy (int x, int y)
{
   asm mov bx, 0
   asm mov es, bx

   asm mov ah, 2
   asm mov bh, es:[462h]

   asm mov dh, y
   asm add dh, -1

   asm mov dl, x
   asm add dl, -1

   VIDEO_INT
}

void v_screen (int cmd, int x, int y, int nx, int ny, void *buffer)
{
   int cols;
   char mode, page;

   asm push ds

   asm mov ah, 15
   VIDEO_INT

   asm mov mode, al
   asm mov BYTE PTR cols, ah
   asm mov BYTE PTR cols [1], 0
   asm shl WORD PTR cols, 1
   asm mov page, bh

   asm push ds
   asm pop es

   asm mov ax, 0b000h
   asm cmp BYTE PTR mode, MONO
   asm jz v_screen0

   asm add ah, page
   asm add ah, 8

v_screen0:

   asm mov si, ax

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen1

   asm mov ds, si
   asm sub si, si
   asm mov di, buffer
   asm jmp SHORT v_screen2

v_screen1:

   asm mov es, si
   asm sub di, di
   asm mov si, buffer

v_screen2:

   asm mov ax, y
   asm dec ax
   asm mov cx, cols
   asm mul cx
   asm mov cx, x
   asm dec cx
   asm shl cx, 1
   asm add ax, cx

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen3

   asm add si, ax
   asm jmp SHORT v_screen4

v_screen3:

   asm add di, ax

v_screen4:

   asm mov bx, ny
   asm mov cx, nx
   asm cld

v_screen5:

   asm rep movsw

   asm dec bx
   asm jz v_screen7

   asm cmp BYTE PTR cmd, 0
   asm jnz v_screen6

   asm sub si, nx
   asm sub si, nx
   asm add si, cols
   asm mov cx, nx
   asm jmp SHORT v_screen5

v_screen6:

   asm sub di, nx
   asm sub di, nx
   asm add di, cols
   asm mov cx, nx
   asm jmp SHORT v_screen5

v_screen7:

   asm pop ds
}

void v_setattr (int attr)
{
   attribute = attr;
}

void v_setshape (int shape)
{
   asm mov ah, 1
   asm mov cx, shape
   VIDEO_INT
}

void v_shadow (int x1, int y1, int nx, int ny)
{
   int i, x2, y2;
   char buffer [2];

   x2 = x1+nx-1;
   y2 = y1+ny-1;

   for (i = x1+1; i <= x2+1; i++)
   {
	v_screen (SCREEN_SAVE, i, y2+1, 1, 1, buffer);
	buffer [1] = LIGHTGRAY;
	v_screen (SCREEN_RESTORE, i, y2+1, 1, 1, buffer);
   }

   for (i = y1+1; i <= y2+1; i++)
   {
	v_screen (SCREEN_SAVE, x2+1, i, 1, 1, buffer);
	buffer [1] = LIGHTGRAY;
	v_screen (SCREEN_RESTORE, x2+1, i, 1, 1, buffer);
   }
}

int v_wherex (void)
{
   asm mov bx, 0
   asm mov es, bx
   asm mov bl, es:[462h]
   asm shl bx, 1
   asm mov al, es:[bx+450h]
   asm sub ah, ah
   asm inc ax
}

int v_wherey (void)
{
   asm mov bx, 0
   asm mov es, bx
   asm mov bl, es:[462h]
   asm shl bx, 1
   asm mov al, es:[bx+451h]
   asm sub ah, ah
   asm inc ax
}

void write_day (int year, int month, int day)
{
   int c, d, nd, r;
   char buffer [3];

   c = fday (year, month) * 6 + 3;
   r = 5;

   nd = days [month-1];
   if (month == 2 && isleap (year))
       nd++;

   v_setattr (attr [1]);

   buffer [2] = '\0';

   for (d = 1; d <= nd; d++)
   {
	buffer [0] = d / 10 +  ((d < 10) ? ' ' : '0');
	buffer [1] = d % 10 + '0';

	v_gotoxy (column+c, row+r);
	if (d == day)
	{
	    v_setattr (attr [4]);
	    v_cputs (buffer);
	    v_setattr (attr [1]);
	}
	else
	    v_cputs (buffer);

	if ((c += 6) > 39)
	{
	    c = 3;
	    r += 2;
	}
   }
}

void write_month (int month)
{
   v_gotoxy (column+((NCOLS-strlen (months [--month])) >> 1), row+1);
   v_setattr (attr [2]);
   v_cputs (months [month]);
}

void write_year (int year)
{
   char buffer [5];

   buffer [4] = '\0';
   buffer [3] = '0'+year % 10;
   year /= 10;
   buffer [2] = '0'+year % 10;
   year /= 10;
   buffer [1] = '0'+year % 10;
   year /= 10;
   buffer [0] = '0'+year;
   v_setattr (attr [3]);
   v_gotoxy (column+2, row+1);
   v_cputs (buffer);
   v_gotoxy (column+NCOLS-6, row+1);
   v_cputs (buffer);
}
