
/*
*----------------------------------------------------------------*
*       ScrEdit.H - Turbo ScrEdit C Interface Header File        *
*                                                                *
*                <C>opyright 1989 by iHn Systems                 *
*                         P.O. Box 1707                          *
*                     Tulare, CA. 93275-1707                     *
*                                                                *
* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*
* The file PRINTME.1ST explains how to create the Turbo ScrEdit  *
* Interface object code libraries that this header file is used  *
* with. See Page 6 of PRINTME.1ST for more details.              *
*                                                                *
*----------------------------------------------------------------*/
#if defined (__TINY__) || defined (__SMALL__)
   #error "TINY and SMALL memory models are not supported";
#endif

typedef union
 {
 struct s1
     {
     char           filler;
     char           s_name         [128] [17];
     unsigned char  s_number       [128];
     int            s_recordnumber [128];
     int            s_fieldsrecno  [128];
     int            s_rangerecno   [128];
     unsigned char  s_first        [128];
     unsigned char  s_count        [128];
     unsigned char  s_compiledind  [128];
     int            s_rangerecnext;
     int            s_rangelinenext;
     int            s_sfiled;
     }A;
 struct s2
     {
     char           filler;
     char           s_video     [3840];
     char           s_workarray [80] [2];
     }B;
 struct s3
     {
     char          filler;
     unsigned char s_fieldname     [128] [17];
     unsigned char s_row           [128];
     unsigned char s_col           [128];
     unsigned char s_len           [128];
     unsigned char s_type          [128];
     unsigned char s_prev          [128];
     unsigned char s_next          [128];
     unsigned char s_datalen       [128];
     unsigned char s_normalbg      [128];
     unsigned char s_normalfg      [128];
     unsigned char s_promptbg      [128];
     unsigned char s_promptfg      [128];
     unsigned char s_displaybg     [128];
     unsigned char s_displayfg     [128];
     unsigned int  s_rangenextrec  [128];
     unsigned char s_rangenextline [128];
     }C;
 struct s4
     {
     char          filler;
     char          s_rangelist [51] [79];
     int           s_rangerec  [51];
     unsigned char s_rangeline [51];
     }D;
 } s_rec_def;

s_rec_def *s_indx, *s_record, *s_field, *s_validate;

int long s_cursorold;

enum s_cursors
  {S_OFF,S_BOLD,S_NORMAL,S_INVERSEBOLD,S_INVERSENORMAL,S_GETCURSOR};
void far *s_videomem;
enum s_cursors s_cursor;
char s_enterafterfield;
unsigned char s_tabatendoffield;
unsigned char s_clearifnotrightarrow;
unsigned char s_clearnotright;
char s_sound;
char s_helpsound;
char s_usersound;
char s_errorsound;
char s_numlock;
char s_fkey;
char s_shift;
char s_alt;
char s_ctrl;
char s_esc;
char s_f1;
char s_f2;
char s_f3;
char s_f4;
char s_f5;
char s_f6;
char s_f7;
char s_f8;
char s_f9;
char s_f10;
char s_f11;
char s_f12;
char s_enter;
char s_bksp;
char s_home;
char s_up;
char s_pgup;
char s_left;
char s_right;
char s_end;
char s_down;
char s_pgdn;
char s_ins;
char s_del;
char s_tab;
char s_showstatus;
char s_scrolllock;
char s_caps;
char s_leftshift;
char s_rightshift;
char s_insertmode;
char s_insertkey;
char s_deletekey;
char s_backspace;
int  s_firstfield;
int  s_point;
int  s_freq;
int  s_dur;
int  s_helpfreq;
int  s_helpdur;
int  s_errorfreq;
int  s_errordur;
int  s_userfreq;
int  s_userdur;
unsigned char s_alphamaskmsg[81];
unsigned char s_numericmaskmsg[81];
unsigned char s_numericfieldmsg[81];
unsigned char s_alphafieldmsg[81];
unsigned char s_usermask[81];
unsigned char s_userhelp[81];
unsigned char s_workstr [81];
unsigned char s_msg [81];
unsigned char s_editstr [81];
unsigned char s_blanks [81];
unsigned char s_ch;
unsigned char s_changescreen;
unsigned char S_FirstTime = 1;
unsigned char s_sound_hold;
unsigned char s_mono;
unsigned char s_upcase;
unsigned char s_validate_finished;
unsigned char s_screenvalid;
unsigned char s_wait;
unsigned char s_leftarrow;
unsigned char s_rightarrow;
unsigned char
 s_delayscreen,
 s_delayed,
 S_FileOpen,
 s_enterastab,
 s_fastvideo,
 S_PosLastChar,
 s_bw,
 s_dupfields,
 s_setdupefields,
 s_entrytype,
 s_disptype,
 s_duptype,
 s_ftype,
 s_initialvalue[81],
 s_editmask [81],
 s_editmasktypes[7],
 s_autohelpmsg [81],
 s_errormsg [81],
 s_usermsg [81],
 s_quickhelp,
 s_force_editmask,
 s_autohelp,
 s_autovalidate,
 s_stlabelcolor,
 s_stlabelfg,
 s_stlabelbg,
 s_stfg,
 s_stbg,
 s_userfg,
 s_userbg,
 s_errorfg,
 s_errorbg,
 s_helpfg,
 s_helpbg,
 s_stcolor;
int
 s_vrec,
 s_recno,
 s_validateline,
 s_validatefield,
 s_helppos,
 s_nextpos,
 s_lastpos,
 s_str_pos,
 s_attrib,
 s_messbg,
 s_messfg,
 s_num,
 s_f_key,
 s_direction,
 s_decimal,
 s_prevfield,
 s_fieldnum,
 s_sub,
 s_currline,
 s_nextrec;

unsigned char
 s_newstr       [81],
 s_padding      [81],
 s_workattrib   [81],
 s_normattrib   [81],
 s_stprev   [41],
 s_stline   [41],
 s_stattrib [41],
 s_ins_str      [2],
 s_nextline,
 s_reverse,
 s_skip,
 s_matched,
 s_min_max_loaded,
 s_endofline,
 s_insideif,
 s_curstr[81],
 s_editstrhold[81],
 s_compmin[81],
 s_compmax[81],
 s_compfield[81],
 s_opcode[81],
 s_opcode1[81];

double
 S_Round [8] = {.5,.5,.05,.005,.0005,.00005,.000005,.0000005},
 s_numeric,
 s_compmin_Numeric,
 s_compmax_Numeric;

char S_MouseFirstTime = '1';
unsigned char
 s_mouseinstalled,
 s_mousevisable,
 S_mouseactive,
 S_mouseevent,
 s_msleftpressed,
 s_msrightpressed,
 s_msmiddlepressed,
 s_msleftreleased,
 s_msrightreleased,
 s_msmiddlereleased;

unsigned
 s_msX,
 s_msY,
 s_msrowHold,
 s_mscolHold,
 s_msrow,
 s_mscol,
 s_msAx,
 s_msBx,
 s_msCx,
 s_msDx,
 s_buttons;

typedef struct{
  char far *Ptr[255];
  }S_Vectors;
S_Vectors far *S_VectorRec;

typedef struct {
  unsigned Ax, Bx, Cx, Dx;
  char     mouseevent;
  char     mouseactive;
  } S_EventRecord;
S_EventRecord far *s_ms;

void     s_activatemouse(void);
void     s_analizemouse(void);
void     s_disablemouse(void);
void     s_hidemouse(void);
void     s_initmouse(void);
void     s_movemouse(void);
void     s_removemouse(void);
void     s_resetmouse(void);
void     s_resetmouseflags(void);
void     s_restoremouse(void);
void     s_setmousecursor(char,char,char,char);
void     s_setmouseevent(char*);
void far s_setmouseflags (void);
void     s_setmouserange(int,int,int,int);
void     s_showmouse(void);

void s_resetkeyflags (void);
void s_setcursor(char);
void s_init(void);
void s_openscreenfile (char*);
void s_closescreenfile(void);
void s_beep(int,int);
void s_write (int,int,int,char*,char*);
void s_displaymessage(int,int,char);
void s_loadscreen(char *);
void s_displayscreenfield(int,int,int,int,int,int,int,int,int,char*);
void s_editstring (int,int,int,int,int,int,int,int,int,int,char*);
void s_validatescreen(void);
void s_nextkey(void);
void s_readkey(void);
void s_readfield(void);
void s_readscreen(void);
void s_cleardupes(void);
void s_storecolorchanges(void);
void s_refreshscreen(void);
void s_clearscreen(int);

unsigned char s_isdupe(int);
unsigned char s_setdupe(int);
unsigned char s_resetdupe(int);
unsigned char s_changescreencolor(int,int,int,int,int,int,int);
unsigned char s_changefieldcolor(int,int,int,int);
unsigned char s_setdisplayon(int);
unsigned char s_setdisplayoff(int);
