//*************************************************************
//  File name: init.c
//
//  Description: 
//      Initializes the app and instance
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//*************************************************************

#include "global.h"

//*************************************************************
//
//  InitApplication
//
//  Purpose:
//		Initializes the application (window classes)
//
//
//  Parameters:
//      HANDLE hInstance - hInstance from WinMain
//      
//
//  Return: (BOOL)
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
//*************************************************************

BOOL InitApplication (HANDLE hInstance)
{
    WNDCLASS  wc;

    wc.style = NULL;             
    wc.lpfnWndProc = MainWndProc;
                                 
    wc.cbClsExtra = 0;           
    wc.cbWndExtra = 0;           
    wc.hInstance = hInstance;    
    wc.hIcon = LoadIcon(hInstance, "MAINICON");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject( WHITE_BRUSH );
    wc.lpszMenuName  = szMainMenu;  
    wc.lpszClassName = szMainClass;

    if ( !RegisterClass(&wc) )
        return FALSE;

    return TRUE;

} //*** InitApplication

//*************************************************************
//
//  InitInstance
//
//  Purpose:
//		Initializes each instance (window creation)
//
//
//  Parameters:
//      HANDLE hInstance
//      int nCmdShow
//      
//
//  Return: (BOOL)
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
//*************************************************************

BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{

    ghInst = hInstance;

    ghWndMain = CreateWindow( szMainClass, 
        "TrackPopup",  
        WS_OVERLAPPEDWINDOW,           
        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        NULL, NULL, hInstance, NULL );

    if (!ghWndMain)
        return (FALSE);

    ShowWindow(ghWndMain, nCmdShow);
    UpdateWindow(ghWndMain);
    return (TRUE);

} //*** InitInstance

//*** EOF: init.c
