//*************************************************************
//  File name: main.c
//
//  Description: 
//      WinMain and the WndProcs
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//*************************************************************

#include "global.h"

HANDLE  ghInst      = NULL;
HWND    ghWndMain   = NULL;
HMENU   ghPopupMenu = NULL;

char    szMainMenu[]    = "MainMenu";
char    szMainClass[]   = "MainClass";

//*************************************************************
//
//  WinMain
//
//  Purpose:
//              Entry point for all windows apps
//
//
//  Parameters:
//      HANDLE hInstance
//      HANDLE hPrevInstance
//      LPSTR lpCmdLine
//      int nCmdShow
//      
//
//  Return: (int PASCAL)
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
//*************************************************************

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;

    if (!hPrevInstance && !InitApplication(hInstance))
            return (FALSE);       

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    // Load popup menu from resources
    ghPopupMenu = LoadMenu( hInstance, "PopupMenu" );

    if (!ghPopupMenu)
        return FALSE;

    // Enter main message loop
    while (GetMessage(&msg, NULL, NULL, NULL))
    {
        TranslateMessage(&msg);      
        DispatchMessage(&msg);       
    }

    // Destroy popup menu
    DestroyMenu( ghPopupMenu );

    return (msg.wParam);      

} //*** WinMain

//*************************************************************
//
//  MainWndProc
//
//  Purpose:
//              Main Window procedure
//
//
//  Parameters:
//      HWND hWnd
//      unsigned msg
//      WORD wParam
//      LONG lParam
//      
//
//  Return: (long FAR PASCAL)
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
//*************************************************************

long FAR PASCAL MainWndProc(HWND hWnd, unsigned msg, WORD wParam, LONG lParam)
{
    FARPROC lpProc;
    static  RECT rcRect = {50,70,350,250};

    switch (msg) 
    {
        case WM_COMMAND: 
            switch ( wParam )
            {
                case IDM_ABOUT:
                    // Show about box
                    lpProc = MakeProcInstance(About, ghInst);
                    DialogBox(ghInst, "AboutBox", hWnd, lpProc);    
                    FreeProcInstance(lpProc);
                break;
            }
        break;

        case WM_PAINT:
        {
            PAINTSTRUCT ps;
            HBRUSH      hbr;

            // Paint instructions
            BeginPaint( hWnd, &ps );
            TextOut(ps.hdc,10,10,
                "Click left mouse button inside box to popup menu.",49);
            TextOut(ps.hdc,10,35,
                "The WM_LBUTTONUP won't dismiss the menu if it's inside the box.",63);

            hbr = SelectObject(ps.hdc,GetStockObject(HOLLOW_BRUSH));
                           
            Rectangle(ps.hdc,rcRect.left,rcRect.top,rcRect.right,rcRect.bottom);

            hbr = SelectObject(ps.hdc, hbr);
            EndPaint( hWnd, &ps );
        }
        break;

        case WM_LBUTTONDOWN:
        {
            POINT pt;
            
            pt.x = LOWORD(lParam);
            pt.y = HIWORD(lParam);

            // Is in the specified rectangle    
            if (PtInRect( &rcRect, pt ))
            {
                POINT pt;
                HMENU hMenu = GetSubMenu( ghPopupMenu, 0 );
                RECT  rcMenu = rcRect;

                pt.x = rcRect.right+4;
                pt.y = rcRect.top;

                // Every thing needs to be in screen coordinates    
                ClientToScreen( hWnd, &pt );
                ClientToScreen( hWnd, (LPPOINT)&(rcMenu.left) );
                ClientToScreen( hWnd, (LPPOINT)&(rcMenu.right) );

                // Bring up menu
                TrackPopupMenu( hMenu, TPM_LEFTALIGN|TPM_LEFTBUTTON,
                    pt.x, pt.y, 0, hWnd, &rcMenu );
            }
        }
        break;

        case WM_DESTROY:
            PostQuitMessage(0);
        break;
    }
    return (DefWindowProc(hWnd, msg, wParam, lParam));

} //*** MainWndProc

//*************************************************************
//
//  About
//
//  Purpose:
//              the About dialog box procedure
//
//
//  Parameters:
//      HWND hDlg
//      unsigned msg
//      WORD wParam
//      LONG lParam
//      
//
//  Return: (BOOL FAR PASCAL)
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Created
//
//*************************************************************

BOOL FAR PASCAL About(HWND hDlg, unsigned msg, WORD wParam, LONG lParam)
{
    switch (msg) 
    {
        case WM_INITDIALOG: 
            return TRUE;

        case WM_COMMAND:
            if (wParam == IDOK || wParam == IDCANCEL) 
            {
                EndDialog(hDlg, TRUE);         
                return TRUE;
            }
        break;
    }
    return FALSE;

} //*** About

//*** EOF: main.c
