
// text.cpp
//----------------------------------------------------------------------------
#include "test.hpp"
//----------------------------------------------------------------------------

main()
{
	register b;

	init_px_engine();
	
	init_px_file();

	add_records();
	
	display_records();
		
	search_primary();

	search_secondary();
		
}

//----------------------------------------------------------------------------

int TMYPXFILE :: create_data_file()
{
  register b;

  b=init_descriptors(7,1,1);
  if(b)
    return(b);

  add_field("S","rec_num");
  add_field("A30","name");
  add_field("A40","address");
  add_field("A20","city");
  add_field("A2","state");
  add_field("A9","zip");
  add_field("$","net_income");

	add_secondary_index(7);
	
  b=init_data_file();
	
  return(b);

}

//----------------------------------------------------------------------------

void init_px_engine()
{
	register b;

  b=PXInit();
  if(b){
    printf("\n\n%s\n\n",PXErrMsg(b));;
    exit(1);
  }

	MyPXFile.set_data_buf((char *)&MyPXFile.data);
  MyPXFile.set_name("MYPXFILE");

	atexit(kill_px_engine);
	
}

//----------------------------------------------------------------------------

void init_px_file()
{
	register b;
  int eflag;
	
	b=MyPXFile.pxtblexist(&eflag);
  if(!b && eflag){
	  b=MyPXFile.pxtbldelete();		
  	if(b){
			printf("\n\n%s\n\n",PXErrMsg(b));;
			exit(1);
		}
	}
  
	mkdir("DATA");

  b=MyPXFile.create_data_file();
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}

}

//----------------------------------------------------------------------------

void add_records()
{
	register b;

	b=MyPXFile.OpenTable();			
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));
		exit(1);
	}
	
	MyPXFile.data.rec_num=1;
	strcpy(MyPXFile.data.name,"Mr. John and Janet Jones");
	strcpy(MyPXFile.data.address,"123 Main St");
	strcpy(MyPXFile.data.city,"Anytown");
	strcpy(MyPXFile.data.state,"NY");
	strcpy(MyPXFile.data.zip,"111110000");
	MyPXFile.data.net_income=45000.00;
	
  b=MyPXFile.InsertRecord();
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}
	
	MyPXFile.data.rec_num++;
	strcpy(MyPXFile.data.name,"Mr. Art and Ann Able");
	strcpy(MyPXFile.data.address,"121 Baker St");
	strcpy(MyPXFile.data.city,"Anytown");
	strcpy(MyPXFile.data.state,"NY");
	strcpy(MyPXFile.data.zip,"111110000");
	MyPXFile.data.net_income=33000.00;
	
  b=MyPXFile.InsertRecord();
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}
	
	MyPXFile.data.rec_num++;
	strcpy(MyPXFile.data.name,"Mr. Bert Broke");
	strcpy(MyPXFile.data.address,"10 1/2 Main St");
	strcpy(MyPXFile.data.city,"Anytown");
	strcpy(MyPXFile.data.state,"NY");
	strcpy(MyPXFile.data.zip,"111110000");
	MyPXFile.data.net_income=400.00;
	
  b=MyPXFile.InsertRecord();
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}
	
	MyPXFile.data.rec_num++;
	strcpy(MyPXFile.data.name,"Ms. Harley Davidson");
	strcpy(MyPXFile.data.address,"69 Main St");
	strcpy(MyPXFile.data.city,"Anytown");
	strcpy(MyPXFile.data.state,"NY");
	strcpy(MyPXFile.data.zip,"111110000");
	MyPXFile.data.net_income=110000.00;
	
  b=MyPXFile.InsertRecord();
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}

	b=MyPXFile.CloseTable();	
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}
	
}

//----------------------------------------------------------------------------

void display_records()
{
	register a,b;
	
	b=MyPXFile.OpenTable();	
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}
		
	b=MyPXFile.GetFirstRecord();
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}
	
	display_record();
	
	for(a=1;a<MyPXFile.total_records;a++){
	
		
    b=MyPXFile.GetNextRecord();
	  if(b){
		  printf("\n\n%s\n\n",PXErrMsg(b));;
		  exit(1);
	  }

		display_record();
				
	}
		
  b=MyPXFile.CloseTable();	
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}

}

//----------------------------------------------------------------------------

void search_primary()
{
  register b;

	b=MyPXFile.OpenTable();	
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}

	printf("\n\nSearch primary index for exact match\n");
	printf("------------------------------------\n\n");
	
	for(;;){

		for(;;){
			
		  printf("\n\n\nEnter record number (1-4, 0=Exit) :");
		  scanf("%d",&MyPXFile.data.rec_num);
	
			if(MyPXFile.data.rec_num >= 0 && MyPXFile.data.rec_num <= 4)
				break;
			
		}
			
	  if(!MyPXFile.data.rec_num)
		  return;	
		
		b=MyPXFile.SearchRecord("rec_num",1,NULL,SEARCHFIRST,LOAD_RECORDS);
		if(b){
			printf("\n\n%s\n\n",PXErrMsg(b));;
			exit(1);
		}

		display_record();
		
	}

	b=MyPXFile.CloseTable();	
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}

}

//----------------------------------------------------------------------------

void search_secondary()
{
  register b;

	b=MyPXFile.OpenTable();	
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}

	printf("\n\nSearch secondary index for closest match\n");
	printf("----------------------------------------\n\n");
	
	for(;;){

		for(;;){
			
		  printf("\n\n\nEnter net income (0=Exit) : $");
		  scanf("%lf",&MyPXFile.data.net_income);
	
			if(MyPXFile.data.net_income >= 0)
				break;
			
		}
			
	  if(!MyPXFile.data.net_income)
		  return;	
		
		b=MyPXFile.FindRecord("net_income",NULL,CLOSESTRECORD,LOAD_RECORDS);
		if(b){
			printf("\n\n%s\n\n",PXErrMsg(b));;
			exit(1);
		}

		display_record();
		
	}

	b=MyPXFile.CloseTable();	
	if(b){
		printf("\n\n%s\n\n",PXErrMsg(b));;
		exit(1);
	}

}

//----------------------------------------------------------------------------

void display_record()
{
	printf("\nRecord # %d\n   %s\n   %s\n   %s, %s %s\n  Net:$%7.2lf\n\n",
                                                   MyPXFile.data.rec_num,
                                                   MyPXFile.data.name,
                                                   MyPXFile.data.address,
                                                   MyPXFile.data.city,
                                                   MyPXFile.data.state,
                                                   MyPXFile.data.zip,
                                                   MyPXFile.data.net_income
																								);

}
																						
//----------------------------------------------------------------------------

void kill_px_engine()
{
  PXExit();
}

//----------------------------------------------------------------------------
