//Example provided by MARTZ Computing

#include <printer.h>
#include <owl.h>
#include <owlrc.h>

_CLASSDEF(TMyReport)
class TMyReport : public TReport {
  protected:
  WORD MaxPages;
  public:
  TMyReport() : TReport() {MaxPages = 5;};
  virtual BOOL Draw(WORD Page);
  protected:
  virtual void setDefaults(PRINTDLG*);
  virtual void PreDraw (PRINTDLG*);
  virtual void PostDraw(BOOL);
};

void
TMyReport::PreDraw(PRINTDLG *pd){
  TReport::PreDraw(pd);
  //Prepare for what was chosen by the user
  //suchas Page range (TPrinter takes care of it)
  //if you need to prepair for it.
}

void
TMyReport::PostDraw(BOOL isCancelled){
  TReport::PostDraw(isCancelled);
  //Do some proccessing if not cancelled
  //Example could be to save a record if
  //the report printed okay
}

void
TMyReport::setDefaults(PRINTDLG *pd){
  TReport::setDefaults(pd);
  pd->nMaxPage  = MaxPages;
  pd->nToPage   = MaxPages;
  pd->Flags    |= PD_NOSELECTION;
}

BOOL//SAME SOURCE AS IN TREPORT::DRAW()
TMyReport::Draw(WORD Page){
  LPSTR   S = new char[25];
  RECT    rt;
  LOGFONT lfont;

  //Setup Page
  SetMapMode(MM_LOENGLISH);
  rt = PageSize(TRUE);
  rt.right--;
  rt.bottom++;
  UpdateMeter(25);

  //Setup font and print text
  memset(&lfont,0,sizeof(lfont));
  lstrcpy(lfont.lfFaceName,"Arial");
  lfont.lfWeight = 700;//Bold
  lfont.lfQuality = PROOF_QUALITY;
  lfont.lfHeight = 50;
  Font(&lfont);
  wsprintf(S,"Example Page %i",Page);
  Text(S, rt, DT_CENTER|DT_VCENTER);
  UpdateMeter(50);

  //Setup font and print text
  lfont.lfWeight = 500;//Bold
  lfont.lfHeight = 20;
  Font(&lfont);
  rt.top    -= 100;
  rt.bottom  = rt.top - 20;
  Text("This is a sample application code", rt, DT_CENTER);
  UpdateMeter(75);

  //Draw a box around the text
  rt.top    += 5;
  rt.bottom -= 5;
  Box(rt);
  UpdateMeter(100);

  delete S;
  return Page <= MaxPages;
}

//*****************************************************************

#define CM_ABOUT 200
#define CM_PRINT 201
#define CM_SETUP 202

_CLASSDEF(TMyWindow)
class TMyWindow : public TWindow {
  protected:
  PTPrinter printer;
  public:
  TMyWindow(PTWindowsObject aParent);
  virtual ~TMyWindow();
  virtual void SetupWindow();
  virtual LPSTR GetClassName()
    { return "PrinterSample"; };
  protected:
  virtual void CMAbout(RTMessage) = [CM_FIRST + CM_ABOUT];
  virtual void CMPrint(RTMessage) = [CM_FIRST + CM_PRINT];
  virtual void CMSetup(RTMessage) = [CM_FIRST + CM_SETUP];
};

TMyWindow::TMyWindow(PTWindowsObject aParent)
          :TWindow(aParent,"Sample Print Window"){
  printer = new TPrinter(this);
};

TMyWindow::~TMyWindow(){
  if (printer) delete printer;
}

void
TMyWindow::SetupWindow(){
  HMENU hMenu;
  HMENU hFile;

  TWindow::SetupWindow();
  CenterWindow(HWindow);
  
  hFile = CreatePopupMenu();
  AppendMenu(hFile,MF_STRING,CM_ABOUT,"&About");
  AppendMenu(hFile,MF_SEPARATOR,0,0);
  AppendMenu(hFile,MF_STRING,CM_PRINT,"&Print...");
  AppendMenu(hFile,MF_STRING,CM_SETUP,"P&rinter setup...");
  AppendMenu(hFile,MF_SEPARATOR,0,0);
  AppendMenu(hFile,MF_STRING,CM_EXIT ,"&Exit");

  hMenu = CreateMenu();
  AppendMenu(hMenu,MF_POPUP,(UINT)hFile,"&File");
  SetMenu(HWindow,hMenu);
}

void TMyWindow::CMPrint(RTMessage){
  if (printer) printer->Print(new TMyReport, "This is my report");
}

void TMyWindow::CMSetup(RTMessage){
  if (printer) printer->Setup();
}

void TMyWindow::CMAbout(RTMessage){
  MessageBox(HWindow,
             "Example provided by MARTZ Computing\n"
             "Printer Library is copyright(c) 1993\n"
             "by MARTZ Computing"
             ,"Printer Sample v1.01",MB_OK);
}

//******************************************************************

_CLASSDEF(TSample)
class TSample : public TApplication {
public:
  TSample(LPSTR,HINSTANCE,HINSTANCE,LPSTR,int);
  virtual void InitMainWindow();
};

TSample::TSample(LPSTR AName, HINSTANCE AnInstance,
                   HINSTANCE APrevInst, LPSTR ACmdLine, int ACmdShow)
 :TApplication(AName,AnInstance,APrevInst,ACmdLine,ACmdShow){
}

void
TSample::InitMainWindow(){
  MainWindow = new TMyWindow(NULL);
}

//********************************************************************

int PASCAL
WinMain(HINSTANCE hInst, HINSTANCE hPInst, LPSTR lpCLine, int nCShow){
  HWND PrevWnd = FindWindow("PrinterSample",NULL);
  if (PrevWnd){ //Allows only one instance
     HWND ChildWnd = GetLastActivePopup(PrevWnd);
     if (PrevWnd != ChildWnd) PrevWnd = ChildWnd;
     BringWindowToTop(PrevWnd);
     ShowWindow(PrevWnd,SW_SHOWNORMAL);
     return FALSE;
  }
  TSample sample( "Printer DLL Sample" ,hInst,hPInst,lpCLine,nCShow );
  sample.Run();
  return sample.Status;
}