#ifndef __tooltip_h
#define __tooltip_h

#include <owl\controlb.h>
#include <owl\statusba.h>
#include <owl\buttonga.h>

class TTipControlBar;
class TTipStatusBar;

class TToolTip : private TWindow
{
	friend	TTipControlBar;
	friend	TTipStatusBar;

	UINT	uiTimer;
	BOOL	bEnabled;
	TSize	sizeText;

	void	KillTipTimer ();
	void	ShowNow ();
	void	PositionTip ();

protected:
	void	GetWindowClass (WNDCLASS &wc);
	LPSTR	GetClassName ();

	void 	Paint (TDC &dc, BOOL erase, TRect &rc);
	void	EvTimer (UINT uiTimerId);

	void	SetCaption (const char far* title);

public:
	TToolTip ();
	~TToolTip ();

	BOOL	AreTipsEnabled () 					{ return bEnabled; }
	void	EnableTips (BOOL bEnable = TRUE) 	{ bEnabled = bEnable; }
	void	HideTip ()							{ SetCaption (NULL) ; }
	
	DECLARE_RESPONSE_TABLE (TToolTip);
};

class TTipControlBar : public TControlBar
{
	TToolTip&	tooltip;

public:
	TTipControlBar (TToolTip& tip, TWindow* parent = 0, TTileDirection direction = Horizontal, TFont* font = new TGadgetWindowFont, TModule* module = 0);

	void 	EvMouseMove (UINT modKeys, TPoint& point);
	void 	EvLButtonDown (UINT modKeys, TPoint& point);

	DECLARE_RESPONSE_TABLE (TTipControlBar);
};

class TTipStatusBar : public TStatusBar
{
	TToolTip&	tooltip;

public:
	TTipStatusBar (	TToolTip& 				tip,
					TWindow*				parent = 0,
					TGadget::TBorderStyle 	borderStyle = TGadget::Recessed,
					UINT                  	modeIndicators = 0,
					TFont*                	font = new TGadgetWindowFont,
					TModule*              	module = 0);

	void 	SetHintText (const char *lpszText);
};

#endif