// Program : TOGMENU.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Sat 07/16/94 15:54:41
// Compiler: Borland C++ 3.1 to 4.02
//
// Demonstrates the toggle options enabled by the changes described in
// TOGMENU.DOC
//
// !!!!!!!!!!*********************************************************
// NOTE: This won't compile until you've made the changes described in
//       TOGMENU.DOC and updated the Turbo Vision library TV.LIB.
// !!!!!!!!!!*********************************************************
//
// To compile, adjust directories in makefile as needed, then run:
//
// BC++ 3.1/4.0 with TV 1.03:   make -DTV103
//
//       BC++ 4.02 with TV 2:   make -DTV2
//

#include <string.h>

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TEvent
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu
#include <tv.h>

const int
    cmToggle1    = 101,
    cmToggle2    = 102,
    cmToggle3    = 103,
    cmToggle4    = 104,
    cmEnableDisable = 105,
    cmStatus     = 106;

void AccessMenuBar(void);

// ****************************************************************************
class TTogMenuApp : public TApplication
{
public:
    TTogMenuApp(int argc, char *argv[]);

    static TStatusLine *initStatusLine(TRect r);
    static TMenuBar *initMenuBar(TRect r);

    virtual void handleEvent(TEvent &event);

    Boolean DisabledFlag;       // Flag for disabling a demo option.
};

TTogMenuApp::TTogMenuApp(int argc, char *argv[]) :
  TProgInit( &TTogMenuApp::initStatusLine, &TTogMenuApp::initMenuBar,
             &TTogMenuApp::initDeskTop)
{
    DisabledFlag = False;

    // If you have a configuration file, you could load the toggle item
    // settings and then use menuBar->ToggleStatus() to retrieve a pointer
    // to each toggle item and update each one with the new value from
    // the configuration file.
    // This example uses a command line argument to demonstrate.
    if(argc > 1)
        if(!stricmp(argv[1], "/OFF"))
        {
            // Get a pointer to the text.
            char *ptr = menuBar->ToggleStatus(cmToggle4);

            // Set new value.
            strncpy(ptr, "OFF", 3);
            DisabledFlag = True;    // Keep the demo consistent.
        }
}

TStatusLine *TTogMenuApp::initStatusLine(TRect r)
{
    r.a.y = r.b.y - 1;
    return new TStatusLine(r,
        *new TStatusDef(0, 0xFFFF) +
            *new TStatusItem(0, kbF10, cmMenu) +
            *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit));
}

TMenuBar *TTogMenuApp::initMenuBar(TRect r)
{
    r.b.y = r.a.y + 1;

    // This is how to set up a menu with toggle items.  All you have to do is
    // put the default toggle setting in the parameter normally used for the
    // hot key text.  Always surround it with '[ ]' so that the modified
    // TMenuView::execute() will know what to do.
    // Note that the same concept applies if using a resource file.  Create
    // the menu bar object and then write it out to the resource file.

    // Demonstrates use in a sub-menu.
    TMenuItem& ASubMenu = *new TSubMenu( "S~u~bMenu", kbNoKey) +
          *new TMenuItem("Toggle #~3~", cmToggle3, kbNoKey, hcNoContext,"[Setting 1]")+
          *new TMenuItem("Toggle #~4~", cmToggle4, kbNoKey, hcNoContext,"[ON ]")+
          *new TMenuItem("~E~nabled/Disabled Option", cmEnableDisable, kbF7, hcNoContext, "F7");

    return new TMenuBar( r,
      *new TSubMenu( "~T~oggle Items", kbAltC )+
          *new TMenuItem("Toggle #~1~", cmToggle1, kbNoKey, hcNoContext,"[ ]")+
          *new TMenuItem("Toggle #~2~", cmToggle2, kbNoKey, hcNoContext, "[\xFB]")+
          *new TMenuItem("~S~tatus of Toggle #2", cmStatus, kbF8, hcNoContext, "F8")+
          newLine()+
               ASubMenu+
          newLine()+
          *new TMenuItem("E~x~it", cmQuit, cmQuit, hcNoContext, "Alt-X"));
}

void TTogMenuApp::handleEvent(TEvent& event)
{
    char *ptr;

    TApplication::handleEvent(event);

    //
    // Catch the broadcast events that indicate a toggle item change.
    //
    if(event.what == evBroadcast)
    {
        switch(event.message.command)
        {
            case cmToggle1:
                // Get pointer to the 'param' text.
                ptr = (char *)event.message.infoPtr;

                // Toggle it on or off.
                *ptr = (*ptr == 'X') ? ' ' : 'X';
                break;

            case cmToggle2:
                // Same as above but uses a check mark character.
                ptr = (char *)event.message.infoPtr;
                *ptr = (*ptr == '\xFB') ? ' ' : '\xFB';
                break;

            case cmToggle3:
                // This uses multiple settings.  It cycles through three
                // different settings.
                ptr = (char *)event.message.infoPtr;

                // Note the use of strncmp/strncpy and not
                // strcmp/strcpy!
                if(!strncmp(ptr, "Setting 1", 9))
                    strncpy(ptr, "Setting 2", 9);       // From 1 to 2
                else
                    if(!strncmp(ptr, "Setting 2", 9))
                        strncpy(ptr, "Setting 3", 9);   // From 2 to 3
                    else
                        strncpy(ptr, "Setting 1", 9);   // From 3 back to 1
                break;

            case cmToggle4:
                // This demonstrates how you might toggle some option
                // on and off in your application.
                ptr = (char *)event.message.infoPtr;

                // Note the use of strncmp/strncpy and not
                // strcmp/strcpy!
                if(!strncmp(ptr, "ON ", 3))
                {
                    strncpy(ptr, "OFF", 3);

                    // Code to disable option, command, etc.
                    //  .
                    //  .
                    //  .
                    DisabledFlag = True;    // Example.
                }
                else
                {
                    // Include the extra space to blank the unused spot.
                    strncpy(ptr, "ON ", 3);

                    // Code to enable option, command, etc.
                    //  .
                    //  .
                    //  .
                    DisabledFlag = False;    // Example.
                }
                break;

            default:
                return;
        }
        clearEvent( event );       // Clear event after handling
    }

    // Make use of the toggle item settings.
    if(event.what == evCommand)
    {
        switch(event.message.command)
        {
            case cmEnableDisable:
                // This event only works when Toggle 4 is ON.
                if(DisabledFlag == False)
                    messageBox("Toggle #4 has enabled this option",
                        mfInformation | mfOKButton);

                messageBox("This is the rest of the event", mfInformation |
                    mfOKButton);
                break;

            case cmStatus:
                AccessMenuBar();        // Demonstrate access outside the
                break;                  // application instance.

            default:
                return;
        }
        clearEvent(event);
    }
}

void main(int argc, char *argv[])
{
    TTogMenuApp DemoApp(argc, argv);
    DemoApp.run();
    DemoApp.shutDown();
}

// See if the option is turned on or off from a function not related
// to the TTogMenuApp class.  menuBar is a static member of TProgram and
// can be accessed just like TProgram::deskTop.
void AccessMenuBar(void)
{
    // Pass TProgram::menuBar->ToggleStatus() the command you are
    // looking for and it will return a pointer to the setting.

    char *option = TProgram::menuBar->ToggleStatus(cmToggle2);

    if(*option == ' ')
        messageBox("Toggle #2 is clear", mfInformation | mfOKButton);
    else
        messageBox("Toggle #2 is set", mfInformation | mfOKButton);
}
