/* Functions and subroutines for use with the Mouse. */
#include <dos.h>
#define TRUE 1
#define FALSE 0
#define mouse_int 0x33

union REGS mice;

mouse_init(buttons)
int *buttons;
{
   mice.x.ax = 0;
   int86 (mouse_int, &mice, &mice);
   if (mice.x.ax==-1)
   {
      *buttons = mice.x.bx;
      return(TRUE);
   }
   else
   {
      *buttons = 0;
      return(FALSE);
   }
}  /* mouse_init */

show_cursor()
{
   mice.x.ax = 1;
   int86 (mouse_int, &mice, &mice);
}  /* show_cursor */

hide_cursor()
{
   mice.x.ax = 2;
   int86 (mouse_int, &mice, &mice);
}  /* hide_cursor */

get_pstn_stat (bstat, hpos, vpos)
int *bstat, *hpos, *vpos;
{
   mice.x.ax = 3;
   int86 (mouse_int, &mice, &mice);
   *bstat = mice.x.bx; /* bit 0 - left button (0 : up, 1 : down) */
   *hpos  = mice.x.cx;
   *vpos  = mice.x.dx;
}  /* get_pstn_stat */

set_cursor_pstn(hpos, vpos)
int hpos, vpos;
{
   mice.x.ax = 4;
   mice.x.cx = hpos;
   mice.x.dx = vpos;
   int86 (mouse_int, &mice, &mice);
}  /* set_cursor_pstn */

get_button_press (button, press, hpos, vpos)
int *button, *press, *hpos, *vpos;
{
   mice.x.ax = 5;
   mice.x.bx = *press;
   int86 (mouse_int, &mice, &mice);
   *button = mice.x.ax;
   *press  = mice.x.bx;
   *hpos   = mice.x.cx;
   *vpos   = mice.x.dx;
}  /* get_button_press */

get_button_release(button, release, hpos, vpos)
int *button, *release, *hpos, *vpos;
{
   mice.x.ax = 6;
   mice.x.bx = *release;
   int86 (mouse_int, &mice, &mice);
   *button  = mice.x.ax;
   *release = mice.x.bx;
   *hpos    = mice.x.cx;
   *vpos    = mice.x.dx;
}  /* get_button_release */

set_horiz_range (min_h, max_h)
int min_h, max_h;
{
   mice.x.ax = 7;
   mice.x.cx = min_h;
   mice.x.dx = max_h;
   int86 (mouse_int, &mice, &mice);
}  /* set_horiz_range */

set_vert_range (min_v, max_v)
int min_v, max_v;
{
   mice.x.ax = 8;
   mice.x.cx = min_v;
   mice.x.dx = max_v;
   int86 (mouse_int, &mice, &mice);
}  /* set_vert_range */

define_graph_cursor(h_spot, v_spot, pointer_mask)
int h_spot, v_spot;
int pointer_mask;
{
   mice.x.ax = 9;
   mice.x.bx = h_spot;
   mice.x.cx = v_spot;
   mice.x.dx = pointer_mask;
   int86 (mouse_int, &mice, &mice);
}  /* define_graph_cursor */

define_text_cursor (cursor, start_line, stop_line)
int cursor, start_line, stop_line;
{
   mice.x.ax = 10;
   mice.x.bx = cursor;
   mice.x.cx = start_line;
   mice.x.dx = stop_line;
   int86 (mouse_int, &mice, &mice);
}  /* define_text_cursor */

read_motion_cntr(h_count, v_count)
int *h_count, *v_count;
{
   mice.x.ax = 11;
   int86 (mouse_int, &mice, &mice);
   *h_count = mice.x.cx;
   *v_count = mice.x.dx;
}  /* read_motion_cntr */

set_motion_pixel_ratio(hratio, vratio)
int hratio, vratio;
{
   mice.x.ax = 15;
   mice.x.cx = hratio;
   mice.x.dx = vratio;
   int86 (mouse_int, &mice, &mice);
}  /* set_motion_pixel_ratio */

conditional_off (left, top, right, bottom)
int left, top, right, bottom;
{
   mice.x.ax = 16;
   mice.x.cx = left;
   mice.x.dx = top;
   mice.x.si = right;
   mice.x.di = bottom;
   int86 (mouse_int, &mice, &mice);
}  /* conditional_off */

mouse_dst (mickeys)
int mickeys;
{
   mice.x.ax = 19;
   mice.x.dx = mickeys;
   int86 (mouse_int, &mice, &mice);
}  /* mouse_dst */
