////////////////////////////////////////////
// Copyright (c) LPC Software, 1992
// File: MENU.HPP - class def for text menus
// Warning: do not change any values or names
// in this file. The objects created depend on
// the information in this file.
////////////////////////////////////////////
#ifndef MENU_HPP
#define MENU_HPP

#define  MAKE_COLOR(f, b) ( ( b << 4 ) | f )
#define  TRUE      1
#define  FALSE     0
#define  MONO      7
#define  COLOR     1
#define  REVERSE   112
// M E N U   C O N T R O L   K E Y S
#define  ENTER         13
#define  ESCAPE        27
#define  SP            32
#define  TAB           9
#define  RIGHT_ARROW   77
#define  LEFT_ARROW    75
#define  DOWN_ARROW    80
#define  UP_ARROW      72
#define  PGUP          73
#define  PGDN          81
#define  HOME          71
#define  END           79
#define M_EXITCODE     -1  // used to exit menu
#define M_QUITCODE     -2  // used to quit program

class Menu
{
private:
   int  borderOn;               // border on and off toggle
   int  msgOn;                  // message on and off toggle
   int  msgRow;                 // message display row
   int  msgValid;               // TRUE if message array valid
   int  ulc;                    // upper left column
   int  ulr;                    // upper left row
   int  lrc;                    // lower right column
   int  lrr;                    // lower right row
   int  normalKey;              // keyboard
   int  extendedKey;            // keyboard
   int  saved;                  // screen saved status
   int  row;                    // starting menu row
   int  col;                    // starting menu column
   int  nItems;                 // number of menu items
   char *scrBuffer;             // pointer to where screen is saved
   char **str;                  // array of pointers to menu strings
   char **msgStrings;           // array of pointers to message strings
   int  *pickkeys;              // pointer to array of pick key positions
   int  *pickchars;             // pointer to array of pick characters
   int  *colOffsets;            // pointer to array of columns
   int  *rowOffsets;            // pointer to array of rows
   int  *strLengths;            // pointer to array of string lengths
   int  greatestLength;         // the greatest string length
   int  LastSelection;          // the last active selection
   int  IsColor;                // TRUE if color monitor
   // P R I V A T E   F U N T I O N S
   void getcolOffsets( void );  // loads column offset for horizontal menu
   void readkey( void );        // loads key values
   void drawborder( void );     // self explanatory
   int  MonitorType( void );    // returns TRUE if color capable

public:
   // I N T E R F A C E   V A R I A B L E S
   int  autoSave;            // if set, automatically save underlying screen
   int  autoClear;           // if set, automatically clear when selection made
   int  autoExecute;         // if set, automatically return selected value
   int  singleBorder;        // self explanatory
   int  doubleBorder;        // self explanatory
   int  visible;             // TRUE if menu visible
   int  horizontal;          // if TRUE, will make horizontal menu
   int  horizontalSpacing;   // spacing between items in horizontal menu
   // I N T E R F A C E   C O L O R S
   int  UnselForeColor;      // unselected foreground color
   int  UnselBackColor;      // unselected background color
   int    SelForeColor;      // selected foreground color
   int    SelBackColor;      // selected background color
   int  BorderColor;         // border color
   int  HotKeyColor;         // hot key color
   int  MenuBarColor;        // menu bar color for horizontal menu
   // I N T E R F A C E   F U N C T I O N S
   Menu( int C, int R, char **txt, int *keys );  // contructor function
   ~Menu(); // destructor
   void Activate( void );    // activates the menu
   void SetLastSel( int var ) {LastSelection = var;} // can force last sel
   void SetBorderOn( int );  // 0 border off, 1 border on
   void Save( void );        // save underlying text
   void Rest( void );        // retore underlying text
   int  Select( void );      // pick item from menu
   void LoadMessages( char **txt, int row ); // messages and row for msgs
   void SetMsgOn( int log ); // 0 = messages off, 1 messages on
};

#endif
