/////////////////////////////////////////////////
// File: DEMO.CPP - demo file for text menu class
// Compile:  bcc -mc demo tmenu.obj
/////////////////////////////////////////////////
#include <stdio.h>
#include <conio.h>
#include "menu.hpp"

void stub( void );
void stub2( void );
void submenu1( int, int );
void submenu2( int, int );

// set up some menus, hotkeys, and messages
char *menubar[] = { "File",
                    "Search",
                    "Options",
                    "Fourth",
                    "Help",
                    "Quit",
                     NULL };
int  barkeys[] = { 1, 1, 1, 4, 1, 1, 0 };  // These are the hotkey positions
// for previous menu items.  Note that the number of entries in the array is
// equal to the number of items in the menu.  The menu items must end with a
// NULL and the hot  keys array (barkeys in this case)  must end with a zero
// and both must be the same size. The numbers int the hot keys array define
// the character position of the hot key for each item in the menu.
char *mbmsgs[] = { "Open file.",
                   "Search file for text string.",
                   "Sub-options menu.",
                   "This is the fourth menu selection.",
                   "Put your help function and description here.",
                   "Quit/no quit menu.",
                    NULL };

char *m1[] = { "Open",
               "New",
               "Save",
               "Save As ...",
                NULL };
int m1keys[] = { 1, 1, 1, 6, 0 };
char *m1msgs[] = { "Open a new file.",
                   "Clear current file and create new file.",
                   "Save file using current file name.",
                   "Save file using a different file name.",
                    NULL };

char *m2[] = { "Search",
               "Replace",
               "Next",
                NULL };
int m2keys[] = { 1, 1, 1, 0 };

char *m3[] = { "Display",
               "Sub Options ...",
               "Save",
                NULL };
int m3keys[] = { 1, 5, 1, 0 };

char *m4[] = { "First",
               "Second",
               "Test autoClear Feature",
               "Fourth",
               "Fifth",
               "Return to menu bar",
                NULL };
int  m4keys[] = { 1, 1, 1, 2, 2, 1, 0 };

char *m6[] = { "No", "Yes", NULL };
int  m6keys[] = { 1, 1, 0 };
char *m6msgs[] = { "No, do not quit, return to program.",
                   "Yes, quit program and return to DOS.",
                    NULL };

/////////////////
void main( void )
/////////////////
{
   int resp, subresp;

   window(1,1,80,25);  // This is important! The Menu objects expect the
                       // screen to be full screen. You can resize your
                       // screen after you create instances of the Menu
                       // objects, but don't forget to resize to a full
                       // screen before calling the Activate method or
                       // anytime before accessing a menu object.

   // create the menu objects
   Menu mb( 2, 2, menubar, barkeys );  // create the main menu bar
   mb.horizontal = TRUE;               // menu bar is horizontal
   mb.LoadMessages( mbmsgs, 1 );       // load messages and set for row 1
   mb.SetMsgOn( TRUE );                // turn on messages

   Menu p1( 3, 3, m1, m1keys );        // create pull down menu 1
   p1.singleBorder = TRUE;             // create double lined border
   p1.SetBorderOn( TRUE );             // turn on the border
   p1.LoadMessages( m1msgs, 1 );       // load message array, set for row 1
   p1.SetMsgOn( TRUE );                // turn on messages

   Menu p2( 11, 3, m2, m2keys );       // create pull down menu 2
   p2.singleBorder = TRUE;             // create double lined border
   p2.SetBorderOn( TRUE );             // turn on the border

   Menu p3( 21, 3, m3, m3keys );       // create pull down menu 3
   p3.singleBorder = TRUE;             // create double lined border
   p3.SetBorderOn( TRUE );             // turn on the border

   Menu p4( 32, 3, m4, m4keys );       // create pull down menu 4
   p4.singleBorder = TRUE;             // create double lined border
   p4.SetBorderOn( TRUE );             // turn on the border

   Menu p6( 50, 3, m6, m6keys );       // create pull down menu 6
   p6.singleBorder = TRUE;             // create double lined border
   p6.SetBorderOn( TRUE );             // turn on the border
   p6.LoadMessages( m6msgs, 1 );       // load message array, set for row 1
   p6.SetMsgOn( TRUE );                // turn on messages

   clrscr();                 // clear entire screen
   window(1,3,80,24);        // set up a work area
   textbackground( BLUE );   // clear work area
   clrscr();                 // with blue background
   window(1,1,80,25);        // reset to full screen

   mb.Activate();            // activate menu bar, defined as horizontal above
   resp = 0;                 // set resp variable to zero
   // main menu loop and case statements
   do {
      resp = mb.Select();    // get selection from menu bar
      switch( resp ) {
         case 0: p1.Activate();
                 subresp = p1.Select();
                 switch( subresp ) {
                    case 0: stub(); break;
                    case 1: stub(); break;
                    case 2: stub(); break;
                    case 3: stub(); break;
                 }
                 p1.Rest();
                 break;
         case 1: p2.Activate();
                 subresp = p2.Select();
                 switch( subresp ) {
                    case 0: stub(); break;
                    case 1: stub(); break;
                    case 2: stub(); break;
                 }
                 p2.Rest();
                 break;
         case 2: p3.Activate();
                 subresp = p3.Select();
                 switch( subresp ) {
                    case 0: stub(); break;
                    case 1: submenu1( 32, 6 ); break;
                    case 2: stub(); break;
                 }
                 p3.Rest();
                 break;
         case 3: do {
                    p4.Activate();
                    subresp = p4.Select();
                    switch( subresp ) {
                       case 0: stub(); break;
                       case 1: stub(); break;
                       case 2: submenu2( 50, 8 ); break;
                       case 3: stub(); break;
                       case 4: stub(); break;
                       }
                    } while (subresp != 5 );
                 p4.Rest();
                 break;
         case 4:
                 stub(); break;
         case 5: p6.Activate();
                 subresp = p6.Select();
                 if (subresp == 1)
                    resp = M_QUITCODE;
                 p6.Rest();
                 break;
         default:  break;
      }
   } while ( resp != M_QUITCODE );
   clrscr();
}

/////////////////
void stub( void )  // a stub function for selections
/////////////////
{
   gotoxy( 2, 25 );
   printf("STUB FUNCTION EXECUTED, PRESS ANY KEY.");
   getch();
   gotoxy( 2, 25 );
   clreol();
}

//////////////////
void stub2( void )
//////////////////
{
   gotoxy( 2, 25 );
   printf("Notice how the menu that brought you here is no longer visible!");
   getch();
   gotoxy( 2, 25 );
   clreol();
}

/////////////////////////////////
void submenu1( int col, int row )
/////////////////////////////////
// This menu will stay active until the last item is select.
// This is done by doing the do/while loop until the last menu
// item is selected and then restoring the screen after loop is
// exited.
{
   int subselect = 0;

   char *anyName[] = { "First",
                       "Second",
                       "Third Choice",
                       "Fourth",
                       "Fifth",
                       "Return",
                        NULL };
   int  anyNameKeys[] = { 1, 1, 1, 2, 2, 1, 0 };
   char *anyMessages[] = { "First message.",
                           "Second message.",
                           "Third message.",
                           "Fourth message.",
                           "Fifth msssage.",
      "Did you notice how you have to press the return key to execute.",
                            NULL };

   Menu anyObject(col, row, anyName, anyNameKeys );
   anyObject.UnselForeColor = WHITE;
   anyObject.UnselBackColor = MAGENTA;
   anyObject.SelForeColor   = BLACK;
   anyObject.SelBackColor   = LIGHTGRAY;
   anyObject.HotKeyColor    = BLACK;
   anyObject.BorderColor    = WHITE;
   anyObject.doubleBorder   = TRUE;
   anyObject.autoExecute    = FALSE;
   anyObject.SetBorderOn( TRUE );
   anyObject.LoadMessages( anyMessages, 1 );
   anyObject.SetMsgOn( TRUE );

   anyObject.Activate();
   do {
      subselect = anyObject.Select();
      switch( subselect ) {
         case 0: stub(); break;
         case 1: stub(); break;
         case 2: stub(); break;
         case 3: stub(); break;
         case 4: stub(); break;
         default: break;
      }
   // 5 on next line because that is the fifth and last item
   } while (subselect != 5 );
   anyObject.Rest();          // restore the underlying screen
   return;
}


/////////////////////////////////
void submenu2( int col, int row )
/////////////////////////////////
// This menu will automatically clear when an item
// is selected.
{
   int subselect = 0;

   char *anyName[] = { "First",
                       "Second",
                       "Third Choice",
                       "Return",
                        NULL };
   int  anyNameKeys[] = { 1, 1, 1, 1, 0 };
   char *anyMessages[] = { "First selection.",
                           "Second selection.",
                           "Third selection.",
                           "Return to main menu bar.",
                            NULL };

   Menu anotherObject(col, row, anyName, anyNameKeys );
   anotherObject.UnselForeColor = WHITE;
   anotherObject.UnselBackColor = GREEN;
   anotherObject.SelForeColor   = BLACK;
   anotherObject.SelBackColor   = LIGHTGRAY;
   anotherObject.HotKeyColor    = BLACK;
   anotherObject.BorderColor    = WHITE;
   anotherObject.doubleBorder   = TRUE;
   anotherObject.SetBorderOn( TRUE );
   anotherObject.LoadMessages( anyMessages, 1 );
   anotherObject.SetMsgOn( TRUE );
   anotherObject.autoClear = TRUE;  // this will automatically clear menu when
                                    // item is selected

   anotherObject.Activate();
   do {
      subselect = anotherObject.Select();
      switch( subselect ) {
         case 0: stub2(); break;
         case 1: stub2(); break;
         case 2: stub2(); break;
          default: break;
      }

      if ( anotherObject.autoClear )  // must set the exit code
         subselect = M_EXITCODE;
                  
   // 3 on next line because that is the 3rd and last item
   } while (subselect != 3 && subselect != M_EXITCODE );
   anotherObject.Rest();      // restore the underlying screen
   return;
}
