/*------------------------------------------------------------*/
/*                  TListBoxH member functions                */
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*                                                            */
/*    Turbo Vision -  Version 1.0                             */
/*                                                            */
/*                                                            */
/*    Copyright (c) 1991 by Borland International             */
/*    All Rights Reserved.                                    */
/*                                                            */
/*------------------------------------------------------------*/

/*
  This class creates a single column listbox that can have a horizontal
  scroll bar.  Both the mouse and the arrow keys can be used to scroll it.
  The virtical scroll bar is unchanged.  The last parameter to the
  constructor is the maximum length of the items in the listbox.
*/

#define Uses_TListBox
#define Uses_TEvent
#define Uses_TCollection
#define Uses_TScrollBar
#define Uses_opstream
#define Uses_ipstream
#define Uses_TKeys
#define Uses_TListViewer
#define Uses_TDrawBuffer
#define Uses_TPoint
#define Uses_TEvent
#define Uses_TGroup

#include <tv.h>

#if !defined( __STRING_H )
#include <String.h>
#endif  // __STRING_H

#include "tlbh.h"

TListBoxH::TListBoxH( const TRect& bounds,
                      TScrollBar *vScrollBar, TScrollBar *hScrollBar, ushort maxlen) :
    TListViewer(bounds, 1, hScrollBar, vScrollBar),
    items( 0 )
{
    setRange(0);
    if (hScrollBar != 0)
    {
      hScrollBar->minVal = 0;
      hScrollBar->maxVal = maxlen;
    }
}

TListBoxH::~TListBoxH()
{
}

ushort TListBoxH::dataSize()
{
    return sizeof(TListBoxRec);
}

void TListBoxH::getData( void * rec )
{
    TListBoxRec *p = (TListBoxRec *)rec;
    p->items = items;
    p->selection = focused;
}

void TListBoxH::getText( char *dest, short item, short maxChars )
{
	if (items != 0 )
		{
		strncpy( dest, (const char *)(items->at(item)), maxChars );
		dest[maxChars] = '\0';
		}
    else
        *dest = EOS;
}

void TListBoxH::newList( TCollection *aList )
{
    destroy( items );
    items = aList;
    if( aList != 0 )
        setRange( aList->getCount() );
    else
        setRange(0);
    if( range > 0 )
        focusItem(0);
    drawView();
}

void TListBoxH::setData( void *rec )
{
    TListBoxRec *p = (TListBoxRec *)rec;
    newList(p->items);
    focusItem(p->selection);
    drawView();
}

void TListBoxH::handleEvent( TEvent &event )
{

  if( event.what == evKeyDown )
  {
    switch (ctrlToArrow(event.keyDown.keyCode))
    {
      case kbRight:
           if (hScrollBar != 0)
           {
             hScrollBar->setValue(hScrollBar->value+
                         hScrollBar->scrollStep(sbRightArrow));
             drawView();
           }

           clearEvent(event);
           return;

      case kbLeft:
           if (hScrollBar != 0)
           {
             hScrollBar->setValue(hScrollBar->value+
                         hScrollBar->scrollStep(sbLeftArrow));
             drawView();
           }
           clearEvent(event);
           return;
    }
  }
  TListViewer::handleEvent(event);

}

