/*
*+-------------------------------------------------------------------------
*| File.........: TIMECLS.H
*| Date.........: Wed  12-2-1992
*| Author.......: Anderson P. Bryan
*| Copyright....: None! Use freely.
*| Version......: 1.0    Compile w/ BC++ 3.0
*| Usage........: General purpose time conversion, arithmetic, comparision
*|                and formatting class
*|
*| Acknowledgements:
*|
*|     Inspired by Charles D. Price (CIS 70541,3551) Date class  6/27/92
*|
*+-------------------------------------------------------------------------
*/

#ifndef TIMECLS_H

#ifndef __cplusplus
#error Requires C++ Compiler
#endif

#define TIMECLS_H

#include <dos.h>
#include <iostream.h>

const enum time_format {MILITARY, HMS, ENGLISH};

const unsigned NO_ZERO = 0x02;
const unsigned NO_SECS = 0x04;
const unsigned NO_AMPM = 0x08;

class Time
{
    static int DisplayFormat;
    static unsigned DisplayOptions;

    void ticks_to_hms( void )
    {
        ticks %= 86400L;  // convert to 24 hour clock;
        hour = ticks / 3600;
        minute = (ticks % 3600L) / 60;
        second = (ticks % 60);
    }

    void hms_to_ticks( void )
    {
        ticks = 3600L * hour + 60L * minute + second;
    }

    int isValidHMS( int, int, int ) const;

protected:
    unsigned long ticks;   // time as number of seconds counter
    int hour, minute, second; // time components hour, minute and second

public:
    Time( void );
    Time( const long );
    Time( const int, const int, const int );
    Time( const char * );
    Time( const dostime_t& );
    Time( const Time& );

    Time& operator + ( const long );
    Time& operator + ( const int );

    Time& operator - ( const long );
    Time& operator - ( const int );

    Time& operator += ( const long );
    Time& operator -= ( const long );

    Time& operator ++ ( void ); // Prefix increment
    Time& operator ++ ( int ); // Postfix increment
    Time& operator -- ( void ); // Prefix decrement
    Time& operator -- ( int );  // Postfix decrement

    friend int operator <  ( const Time&, const Time& );
    friend int operator <= ( const Time&, const Time& );
    friend int operator >  ( const Time&, const Time& );
    friend int operator >= ( const Time&, const Time& );
    friend int operator == ( const Time&, const Time& );
    friend int operator != ( const Time&, const Time& );

    friend ostream &operator << ( ostream &os, const Time& );
    friend ostream &operator << ( ostream &os, const dostime_t& );

    char *formatTime( const int = DisplayFormat ) const;
    static void setFormat( const int );
    static void setOptions( const int );

    long tickTime( void ) const; // returns time in ticks of the second hand
    int NHour( void ) const;
    int NMinute( void ) const;
    int NSecond( void ) const;

    int isMidNight( void ) const;   // return 1 if it is midnight hour
    int isNoon( void ) const;       // return 1 if it is the noon hour

    dostime_t getTime( void ) const;

    Time& Set();       // Set to current system time
    Time& Set( long );
    Time& Set( int, int, int );

    Time& AddHours( int = 1 );
    Time& AddMinutes( int = 1 );
};

#endif