/*-----------------------------------------------------------------------*/
/* filename -       tdemo.cpp                                            */
/*                                                                       */
/* function(s)                                                           */
/*                  definitions for the TDemoDialog and TDemoApp         */
/*                  classes                                              */
/*                                                                       */
/*                  Test module for the THandler class                   */
/*                                                                       */
/* author -         Michael "Mick" Newton                                */
/*                                                                       */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/*                                                                       */
/*    TDEMO.CPP                                                          */
/*                                                                       */
/*    THandler version 2.0                                               */
/*    Copyright (C) 1992,1993 Comsoft Software                           */
/*    All Rights Reserved.                                               */
/*                                                                       */
/*-----------------------------------------------------------------------*/

// Define Turbo Vision classes used ***************************************

#define Uses_TApplication
#define Uses_TButton
#define Uses_TCheckBoxes
#define Uses_TCluster
#define Uses_TCommandSet
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TDisplay
#define Uses_TEvent
#define Uses_TFrame
#define Uses_TGroup
#define Uses_TKeys
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TMouse
#define Uses_TObject
#define Uses_TPalette
#define Uses_TPoint
#define Uses_TProgram
#define Uses_TRadioButtons
#define Uses_TRect
#define Uses_TScreen
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TStaticText
#define Uses_TSItem
#define Uses_TSubMenu
#define Uses_TView
#define Uses_TWindow
#define Uses_MsgBox
#define Uses_fpstream
#define Uses_ipstream
#define Uses_opstream

#include <tv.h>





// CRTL header files ******************************************************

#if !defined __STDLIB_H
#include <stdlib.h>
#endif

#if !defined __STDIO_H
#include <stdio.h>
#endif

#if !defined __CONIO_H
#include <conio.h>
#endif

#if !defined __STRING_H
#include <string.h>
#endif

#if !defined __STRSTREAM_H
#include <strstrea.h>
#endif

#if !defined __FSTREAM_H
#include <fstream.h>
#endif

#if !defined __IOMANIP_H
#include <iomanip.h>
#endif

#if !defined __DOS_H
#include <dos.h>
#endif

#if !defined __DIR_H
#include <dir.h>
#endif

#if !defined __ALLOC_H
#include <alloc.h>
#endif

#if !defined __BIOS_H
#include <bios.h>
#endif





// Non-CRTL header files **************************************************

#if !defined __TDEMO_HPP
#include "tdemo.hpp"
#endif

#if !defined __THANDLER_HPP
#include "thandler.hpp"
#endif





// External global variable references ************************************

extern TPoint shadowSize;
extern unsigned _stklen = 8192;        // 8K stack

#if defined __OVERLAY__
extern unsigned _ovrbuffer = 0x2000;
#endif





// TMenuItem **************************************************************

TMenuItem& operator +(TMenuItem& item1, TMenuItem& item2)
{
   // For building the application menubar

   TMenuItem *p = &item1;

   while(p->next != NULL)
      p = p->next;

   p->next = &item2;

   return item1;
}





// TDemoDialog ************************************************************

TDemoDialog::TDemoDialog(const TRect& bounds, const char *aTitle) :
             TDialog(bounds, aTitle),
             TWindowInit(initFrame)
{
}


void TDemoDialog::handleEvent(TEvent& event)
{
   TDialog::handleEvent(event);

   switch(event.what)
      {
      case evCommand:
         switch(event.message.command)
            {
            case cmDriveA:        // Our commands
            case cmDriveB:
            case cmLPT1:
            case cmLPT2:
            case cmLPT3:
            if((state & sfModal) != 0)
               {
               endModal(event.message.command);
               clearEvent(event);
               }
            break;
            }
      break;
      }
}





// TDemoApp ***************************************************************

/* Ŀ */
/*  TDemoApp palette layout                                            */
/* ͵ */
/*                                                                     */
/*  NOTE:                                                              */
/*  This demo program uses a larger than normal application palette    */
/*  to demonstrate THandlerDialog's extended palette.                  */
/*                                                                     */
/* ͵ */
/*  Start  End                                                       */
/*  index  index  Items                                              */
/* Ĵ */
/*         1      Desktop background                                 */
/*      2  7      Menus                                              */
/*      8  15     Windows (Blue)                                     */
/*     16  23     Windows (Cyan)                                     */
/*     24  31     Windows (Gray)                                     */
/*     32  63     Dialogs                                            */
/*     64  71     Help    (Not yet implemented)                      */
/*     72  103    TErrorDialog                                       */
/*  */

// Application color palette
#define cpAppColor                            \
   "\x13\x30\x38\x3F\x0E\x08\x0F\x48\x4E\x4E" \
   "\x09\x1F\x4F\x4D\x4A\x4B\x70\x7F\x7E\x78" \
   "\x71\x40\x00\x70\x7F\x7A\x13\x13\x70\x7F" \
   "\x00\x78\x70\x7E\x0C\x0E\x70\x70\x7F\x7E" \
   "\x17\x1E\x1F\x18\x1B\x78\x70\x7E\x7F\x03" \
   "\x0C\x0A\x7B\x77\x0C\x0E\x03\x4F\x0E\x07" \
   "\x0A\x00\x00\x37\x7F\x0E\x0D\x4F\x5F\x5F" \
   "\x5E\x48\x4C\x4E\x4F\x78\x4F\x50\x03\x0E" \
   "\x70\x74\x7A\x78\x7F\x40\x0C\x0E\x70\x7E" \
   "\x4F\x7F\x0A\x2E\x0C\x7E\x5B\x4F\x58\x7F" \
   "\x57\x47\x00"

// Application black and white palette
#define cpAppBlackWhite                       \
   "\x07\x70\x78\x7F\x0F\x08\x07\x07\x0F\x07" \
   "\x70\x70\x07\x70\x00\x07\x0F\x07\x70\x70" \
   "\x07\x70\x00\x70\x7F\x7F\x70\x07\x70\x07" \
   "\x00\x70\x7F\x7F\x70\x07\x70\x70\x7F\x7F" \
   "\x07\x0F\x0F\x78\x0F\x78\x07\x0F\x0F\x0F" \
   "\x70\x0F\x07\x70\x70\x70\x07\x70\x0F\x07" \
   "\x07\x00\x00\x07\x70\x0F\x70\x0F\x70\x70" \
   "\x7F\x78\x70\x7F\x7F\x08\x7F\x78\x7F\x0F" \
   "\x07\x0F\x0F\x08\x0F\x78\x07\x0F\x07\x0F" \
   "\x70\x07\x0F\x70\x70\x7F\x70\x0F\x78\x78" \
   "\x07\x7F\x00"

// Application monochrome palette
#define cpAppMonochrome                       \
   "\x70\x07\x01\x0F\x70\x70\x01\x07\x0F\x07" \
   "\x70\x70\x07\x70\x00\x07\x0F\x07\x70\x70" \
   "\x07\x70\x00\x70\x70\x70\x07\x07\x70\x07" \
   "\x00\x70\x70\x70\x07\x07\x70\x70\x70\x0F" \
   "\x07\x07\x0F\x70\x0F\x70\x07\x0F\x0F\x07" \
   "\x70\x07\x07\x70\x07\x07\x07\x70\x0F\x07" \
   "\x07\x00\x00\x07\x0F\x07\x70\x70\x07\x0F" \
   "\x70\x70\x70\x70\x07\x07\x70\x70\x70\x0F" \
   "\x07\x07\x0F\x70\x0F\x70\x07\x0F\x0F\x07" \
   "\x70\x07\x07\x70\x07\x07\x07\x70\x0F\x07" \
   "\x07\x0F\x00"


TDemoApp::TDemoApp() :
          TProgInit(initStatusLine, initMenuBar, initDeskTop),
          status(True)
{
   // Create the THandler object
   // Use extended palette, sounds, and DOS handler
   newHandler = new THandler("Error", True, True, True);

   // Check it's status, fail ctor if False
   if(newHandler->status == False)
      {
      status = False;
      return;
      }

   // Initialize options dialog data structure
   // TV handler active, use tones on error, use extended palette
   optrec.use = ofUseSounds | ofExtPal | ofUseDosISR;

   // Get current video mode
   switch(TDisplay::getCrtMode())
      {
      case TDisplay::smCO80:      // 25 lines color
         optrec.video = 0;
         break;
      case TDisplay::smFont8x8:   // 43/50 lines color
         optrec.video = 1;
         break;
      case TDisplay::smBW80:      // Black & white
         optrec.video = 2;
         break;
      default:                    // Monochrome
         optrec.video = 3;
         break;
      }

   // Redraw the application
   setState(sfExposed, True);
   redraw();

   // Display "about" dialog
   TEvent event;
   event.what = evCommand;
   event.message.command = cmAbout;
   putEvent(event);
   clearEvent(event);
}


void TDemoApp::shutDown()
{
   // If Thandler is active, delete it
   if(newHandler != NULL)
      delete((THandler *) newHandler);

   newHandler = NULL;

   TProgram::shutDown();
}


Boolean TDemoApp::valid(ushort command)
{
   // Check status
   if(command == cmValid && status == False)
      return False;

   return TApplication::valid(command);
}


TDeskTop *TDemoApp::initDeskTop(TRect r)
{
   r.a.y++;
   r.b.y--;

   // Stop application from drawing in default colors
   TProgram::application->setState(sfExposed, False);

   return new TDeskTop(r);
}


TPalette& TDemoApp::getPalette() const
{
   static TPalette pal1(cpAppColor, sizeof(cpAppColor) - 1);
   static TPalette pal2(cpAppBlackWhite, sizeof(cpAppBlackWhite) - 1);
   static TPalette pal3(cpAppMonochrome, sizeof(cpAppMonochrome) - 1);
   static TPalette *palettes[] = {&pal1, &pal2, &pal3};
   return *(palettes[appPalette]);
}


TMenuBar *TDemoApp::initMenuBar(TRect r)
{
   r.b.y = r.a.y + 1;

   TMenuItem *sys;
   sys = new TMenuItem("~\360~", kbAltSpace, new TMenu(
      *new TMenuItem("~A~bout", cmAbout, kbAltA, hcNone)));

   TMenuItem *exit;
   exit = new TMenuItem("E~x~it", cmQuit, kbAltX, hcNone, 0);

   TMenuItem *tests;
   tests = new TMenuItem("~T~ests", cmTests, kbAltT, hcNone, 0);

   TMenuItem *opt;
   opt = new TMenuItem("~O~ptions", cmOptions, kbAltO, hcNone, 0);

   TMenu *menu = new TMenu(*sys + *exit + *tests + *opt);

   TMenuBar *menubar = new TMenuBar(r, menu);

   return menubar;
}


TStatusLine *TDemoApp::initStatusLine(TRect r)
{
   r.a.y = r.b.y - 1;

   return new TStatusLine(r,
      *new TStatusDef(0, 0xFFFF) +
      *new TStatusItem("~Alt-X~ Exit", kbAltX, cmQuit) +
      *new TStatusItem("~F10~ Menu", kbF10, cmMenu));
}


void TDemoApp::handleEvent(TEvent& event)
{
   TApplication::handleEvent(event);

   if(event.what == evCommand)
      {
      switch(event.message.command)
         {
         case cmAbout:
            about();
            break;
         case cmTests:
            // Call testDevices() until user selects "Cancel"
            while(testDevices() != cmCancel);
            break;
         case cmOptions:
            options();
            break;
         default:
            return;
         }
      clearEvent(event);
      }
}


void TDemoApp::about()
{
   // Displays a dialog containing information about this program

   TDialog *dialog = new TDialog(TRect(14, 3, 66, 20), "About");

   if(dialog == NULL)
      return;

   dialog->options |= ofCentered;

   TStaticText *t;
   t = new TStaticText(TRect(21, 2, 30, 3), "TDEMO.EXE");
   t->options |= ofCenterX;
   dialog->insert(t);

   t = new TStaticText(TRect(9, 3, 43, 4),
                       "Demonstrates the THandler hardware");
   t->options |= ofCenterX;
   dialog->insert(t);

   t = new TStaticText(TRect(12, 4, 40, 5),
                       "error handler class library.");
   t->options |= ofCenterX;
   dialog->insert(t);

   char ver[32];
   ostrstream os(ver, sizeof ver);

   os << "THandler shareware version "
      << handlerVerStr
      << ends;

   t = new TStaticText(TRect(11, 6, 41, 7), ver);
   t->options |= ofCenterX;
   dialog->insert(t);

   t = new TStaticText(TRect(6, 7, 46, 8),
                       "(C) Copyright 1992,1993 Comsoft Software");
   t->options |= ofCenterX;
   dialog->insert(t);

   t = new TStaticText(TRect(16, 8, 36, 9), "All rights reserved.");
   t->options |= ofCenterX;
   dialog->insert(t);

   t = new TStaticText(TRect(1, 11, 51, 12),
                       "\003Created by Michael Newton for"
                       " Comsoft Software");
   t->options |= ofFramed | ofCenterX;
   dialog->insert(t);

   TButton *b;
   b = new TButton(TRect(11, 14, 41, 16), "~O~k", cmOK, bfDefault);
   b->options |= ofCenterX;
   dialog->insert(b);

   if(validView(dialog))
      {
      deskTop->execView(dialog);
      TObject::destroy((TDialog *) dialog);
      }
}


void TDemoApp::options()
{
   // Executes a dialog which allows user to select program options

   TDialog *dialog;
   dialog = new TDialog(TRect(17, 3, 63, 20), "Options");

   if(dialog == NULL)
      return;

   dialog->options |= ofCentered;

   TStaticText *t;
   t = new TStaticText(TRect(2, 2, 20, 3), "\003THandler options");
   dialog->insert(t);

   t = new TStaticText(TRect(2, 9, 14, 10), "\003Video mode");
   dialog->insert(t);

   TCheckBoxes *cb;
   cb = new TCheckBoxes(TRect(2, 3, 44, 7),
           new TSItem("~U~se sounds on errors",
           new TSItem("Use ~e~xtended palette",
           new TSItem("~S~uspend TV when accessing devices",
           new TSItem("Use ~D~OS ISR when TV suspended", 0)))));
   cb->options |= ofFramed | ofCenterX;
   dialog->insert(cb);

   TRadioButtons *rb;
   rb = new TRadioButtons(TRect(2, 10, 44, 12),
           new TSItem("~2~5 lines color",
           new TSItem("~4~3/50 lines color",
           new TSItem("~B~lack & white",
           new TSItem("~M~onochrome", 0)))));
   rb->options |= ofFramed | ofCenterX;
   dialog->insert(rb);

   TButton *b;
   b = new TButton(TRect(4, 14, 22, 16), "~C~ancel", cmCancel, bfNormal);
   dialog->insert(b);

   b = new TButton(TRect(24, 14, 42, 16), "~O~k", cmOK, bfDefault);
   dialog->insert(b);

   dialog->selectNext(False);

   // Execute the dialog box
   if(validView(dialog))
      {
      ushort oldmode = optrec.video;   // Save current video mode
      dialog->setData(&optrec);        // Set dialog's data
      ushort result = deskTop->execView(dialog);
      if(result != cmCancel)
         {
         dialog->getData(&optrec);     // Get dialog's data
         // Set THandler's sounds flag
         newHandler->setSounds((optrec.use & ofUseSounds) ? True : False);
         // Set THandler's extended palette flag
         newHandler->setExtPalette((optrec.use & ofExtPal) ? True : False);
         // Set THandler's DOS ISR flag
         newHandler->setDOSHandler(
            (optrec.use & ofUseDosISR) ? True : False);
         // Set new video mode if user changed video radio buttons
         if(optrec.video != oldmode)
            {
            ushort vidmode;
            switch(optrec.video)
               {
               case 0:
                  vidmode = TDisplay::smCO80;
                  break;
               case 1:
                  vidmode = TDisplay::smFont8x8;
                  break;
               case 2:
                  vidmode = TDisplay::smBW80;
                  break;
               default:
                  vidmode = TDisplay::smMono;
                  break;
               }
            if((vidmode & TDisplay::smFont8x8) != 0)
               shadowSize.x = 1;
            else
               shadowSize.x = 2;
            // Set the new video mode
            setScreenMode(vidmode);
            // Because of a bug in Turbo Vision's TScreen class we need
            // to reset the mouse ranges if the new mode is 43/50 lines
            // color
            if((vidmode & TDisplay::smFont8x8) != 0)
               TMouse::setRange(TDisplay::getCols() - 1,
                                TDisplay::getRows() - 1);
            // Force the application to redraw
            setState(sfExposed, False);
            setState(sfExposed, True);
            redraw();
            }
         }
      TObject::destroy((TDialog *) dialog);
      }
}


ushort TDemoApp::testDevices()
{
   // Displays a TDemoDialog which allows the user to select a hardware
   // device to access. If "Suspend TV" was checked in the options dialog,
   // THandler's suspend function will be called prior to accessing any
   // device then THandler's resume function will be called

   TDemoDialog *dialog;
   dialog = new TDemoDialog(TRect(13, 3, 67, 19),
                            "Select a device to access");

   if(dialog == NULL)
      return cmCancel;

   dialog->options |= ofCentered;

   // Frames around button groups
   TView *box;
   box = new TView(TRect(1, 1, 53, 6));
   box->options |= ofFramed | ofCenterX;
   dialog->insert(box);

   box = new TView(TRect(1, 7, 53, 12));
   box->options |= ofFramed | ofCenterX;
   dialog->insert(box);

   // Information text
   TStaticText *t;
   t = new TStaticText(TRect(4, 4, 50, 5),
                       "Make sure there is no floppy disk in the drive");
   t->options |= ofCenterX;
   dialog->insert(t);

   t = new TStaticText(TRect(12, 5, 42, 6),
                       "or the disk is write protected");
   t->options |= ofCenterX;
   dialog->insert(t);

   t = new TStaticText(TRect(7, 10, 47, 11),
                       "Make sure the selected printer is either");
   t->options |= ofCenterX;
   dialog->insert(t);

   t = new TStaticText(TRect(12, 11, 41, 12),
                       "turned off or is out of paper");
   t->options |= ofCenterX;
   dialog->insert(t);

   // Floppy drive buttons
   TButton *b;
   b = new TButton(TRect(4, 2, 26, 4), "Drive ~A~:", cmDriveA, bfNormal);
   dialog->insert(b);

   b = new TButton(TRect(28, 2, 50, 4), "Drive ~B~:", cmDriveB, bfNormal);
   dialog->insert(b);

   // Parallel printer buttons
   b = new TButton(TRect(2, 8, 18, 10), "LPT ~1~", cmLPT1, bfNormal);
   dialog->insert(b);

   b = new TButton(TRect(19, 8, 35, 10), "LPT ~2~", cmLPT2, bfNormal);
   dialog->insert(b);

   b = new TButton(TRect(36, 8, 52, 10), "LPT ~3~", cmLPT3, bfNormal);
   dialog->insert(b);

   // Done button
   b = new TButton(TRect(12, 13, 42, 15), "~D~one", cmCancel, bfDefault);
   b->options |= ofCenterX;
   dialog->insert(b);

   // Get the number of parallel printers installed
   int equip = biosequip();
   int prncnt = (equip & 0xC000) >> 14;

   // Disable any printer selection buttons that aren't available
   TCommandSet prncmds;

   if(prncnt < 3)
      prncmds += cmLPT3;

   if(prncnt < 2)
      prncmds += cmLPT2;

   if(prncnt < 1)
      prncmds += cmLPT1;

   disableCommands(prncmds);

   fstream *f;
   ushort result = cmCancel;

   // Execute the dialog
   if(validView(dialog))
      {
      result = deskTop->execView(dialog);
      if(result != cmCancel)
         {
         switch(result)
            {
            case cmDriveA:
               if(optrec.use & ofSuspendTV)     // If ofSuspendTV set...
                  {
                  newHandler->suspend();        // call suspend
                  if(optrec.use & ofUseDosISR)  // If ofUseDosISR set...
                     displayMessage();          // display message
                  }
               // Access floppy drive A:
               f = new fstream("a:\\nosuchf.ile", ios::in);
               if(f != 0)
                  delete((fstream *) f);
               if(optrec.use & ofSuspendTV)     // If TV suspended...
                  newHandler->resume();         // call resume
               break;
            case cmDriveB:
               if(optrec.use & ofSuspendTV)     // If ofSuspendTV set...
                  {
                  newHandler->suspend();        // call suspend
                  if(optrec.use & ofUseDosISR)  // If ofUseDosISR set...
                     displayMessage();          // display message
                  }
               // Access floppy drive B:
               f = new fstream("b:\\nosuchf.ile", ios::in);
               if(f != 0)
                  delete((fstream *) f);
               if(optrec.use & ofSuspendTV)     // If TV suspended...
                  newHandler->resume();         // call resume
               break;
            case cmLPT1:
               if(optrec.use & ofSuspendTV)     // If ofSuspendTV set...
                  {
                  newHandler->suspend();        // call suspend
                  if(optrec.use & ofUseDosISR)  // If ofUseDosISR set...
                     displayMessage();          // display message
                  }
               // Access LPT1
               ofstream lpt1;
               lpt1.open("lpt1");
               lpt1 << "This is a test of lpt1\n";
               lpt1.close();
               if(optrec.use & ofSuspendTV)     // If TV suspended...
                  newHandler->resume();         // call resume
               break;
            case cmLPT2:
               if(optrec.use & ofSuspendTV)     // If ofSuspendTV set...
                  {
                  newHandler->suspend();        // call suspend
                  if(optrec.use & ofUseDosISR)  // If ofUseDosISR set...
                     displayMessage();          // display message
                  }
               // Access LPT2
               ofstream lpt2;
               lpt2.open("lpt2");
               lpt2 << "This is a test of lpt2\n";
               lpt2.close();
               if(optrec.use & ofSuspendTV)     // If TV suspended...
                  newHandler->resume();         // call resume
               break;
            case cmLPT3:
               if(optrec.use & ofSuspendTV)     // If ofSuspendTV set...
                  {
                  newHandler->suspend();        // call suspend
                  if(optrec.use & ofUseDosISR)  // If ofUseDosISR set...
                     displayMessage();          // display message
                  }
               // Access LPT3
               ofstream lpt3;
               lpt3.open("lpt3");
               lpt3 << "This is a test of lpt3\n";
               lpt3.close();
               if(optrec.use & ofSuspendTV)     // If TV suspended...
                  newHandler->resume();         // call resume
               break;
            }
         }
      TObject::destroy((TDemoDialog *) dialog);
      }

   // Re-enable any disabled commands
   enableCommands(prncmds);

   return(result);
}





// Non-member functions ***************************************************

void displayMessage()
{
   char *msg[] =
      {
      "   This is a test of the THandler hardware error handler library. Thandler",
      "is a replacement error handler class for Borland's Turbo Vision library.",
      "When linked with your Turbo Vision applications and a hardware error occurs,",
      "THandler displays a dialog containing information about the error and lets",
      "the user select an appropriate action.",
      "   At the moment Turbo Vision itself is suspended, so if an error were to",
      "occur right now, Thandler would not be able to display it's normal error",
      "dialog. Therefor, THandler actually has two hardware error handlers. One to",
      "be used when Turbo Vision is active, and one for when Turbo Vision has been",
      "suspended.",
      "   I'm about to cause a hardware error while Turbo Vision is inactive. This",
      "should cause THandler to display it's DOS error dialog. THandler's DOS error",
      "dialog is slightly different from it's normal Turbo Vision dialog. It does",
      "not have buttons for the user to select an action, rather it prompts the user",
      "to press a key to select an action.",
      " ",
      "   Press any key now to generate the hardware error..."
      };

   clrscr();

   cout << endl;

   for(short ctr = 0; ctr < 17; ctr++)
      cout << msg[ctr] << endl;

   cout << endl;

   if(kbhit())
      (void) getch();
   (void) getch();
}


void exitfunc(void)
{
   // Prints an exit message

   cout << endl
        << endl
        << "Ŀ" << endl
        << "  Thank you for testing THandler!           " << endl
        << "Ĵ" << endl
        << "  THandler shareware version "
        << handlerVerStr
        << "            " << endl
        << "  Copyright (C) 1992,1993 Comsoft Software  " << endl
        << "  All rights reserved.                      " << endl
        << "" << endl
        << ends;
}



#pragma exit exitfunc 31          // Register exitfunc


int main()
{
   TDemoApp *program = new TDemoApp();

   if(!program->valid(cmValid))
      {
      TObject::destroy((TDemoApp *) program);
      return 2;
      }

   program->run();
   TObject::destroy((TDemoApp *) program);

	return 0;
}


//                                End of TDEMO.CPP

