/*-----------------------------------------------------------------------*/
/* filename -       thandler.hpp                                         */
/*                                                                       */
/* function(s)                                                           */
/*                  declarations for the following classes...            */
/*                                                                       */
/*                     TErrorText                                        */
/*                     TTitleFrame                                       */
/*                     TErrorDialog                                      */
/*                     THandler                                          */
/*                                                                       */
/*                  this shareware version contains a "nag screen"       */
/*                  dialog which is not present in the registered        */
/*                  version                                              */
/*                                                                       */
/* author -         Michael "Mick" Newton                                */
/*                                                                       */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/*                                                                       */
/*    THANDLER.HPP                                                       */
/*                                                                       */
/*    THandler shareware version 2.0                                     */
/*    Copyright (C) 1992,1993 Comsoft Software                           */
/*    All Rights Reserved.                                               */
/*                                                                       */
/*                                                                       */
/*-----------------------------------------------------------------------*/


#if !defined __THANDLER_HPP
#define __THANDLER_HPP


// Forward references to Turbo Vision classes *****************************

class far TDialog;
class far TEvent;
class far TFrame;
class far TPalette;
class far TRect;
class far TStaticText;





// Defined types **********************************************************

typedef void interrupt (far *fptr)(...);





// Defines ****************************************************************

#define handlerVerStr "2.0"       // Thandler version string
#define ERROR_TEXT_SIZE 55        // TErrorText text buffer size
#define DEVNAME_SIZE 9            // Device name string buffer size
#define INT24 0x24                // Interrupt 24H





// Constants **************************************************************

/*
   AX on entry to ISR

  AH Ŀ    AL  Drive number
                                               (if AH bit 7 = 0)
 7  6  5  4  3  2  1  0   7  6  5  4  3  2  1  0
ϻ
                                
ͼ
               
                1 if write error, 0 if read error  = 0x0001
             
            Disk area of error  = 0x0006
          Fail allowed  = 0x0008
        Retry allowed  = 0x0010
      Ignore allowed  = 0x0020
    Undefined  = 0x0040
  0 = Disk I/O error 1 = char device  = 0x0080
*/

// Bitmasks for ah
const ignoreOK   = 0x0020;        // Ignore
const retryOK    = 0x0010;        // Retry
const failOK     = 0x0008;        // Fail
const charDevice = 0x0080;        // Disk/char device

// Error dialog button commands
const cmAbort    = 200,
      cmRetry    = 201,
      cmIgnore   = 202,
      cmFail     = 203;





// Data structures ********************************************************

// For setData/getData in error dialogs
struct TErrDataRec
{
   char deviceMsg[ERROR_TEXT_SIZE];    // Failing device message
   char errorMsg[ERROR_TEXT_SIZE];     // Error message
};





// TErrorText *************************************************************

class TErrorText : public TStaticText
{
   public:
      TErrorText(const TRect& bounds);
      virtual ushort dataSize();
      virtual void setData(void *rec);
      virtual void getData(void *rec);
      virtual void draw();
   protected:
   private:
      static const char * const near buffstr;
};





// TTitleFrame ************************************************************

class TTitleFrame : public TFrame
{
   public:
      TTitleFrame(const TRect& bounds);
      virtual TPalette& getPalette() const;
      virtual void draw();
   protected:
   private:
};





// TErrorDialog ***********************************************************

class TErrorDialog : public TDialog
{
   public:
      TErrorDialog(const char *aTitle);
      virtual void shutDown();
      virtual TPalette& getPalette() const;
      static TFrame *initFrame(TRect r);
      virtual void handleEvent(TEvent& event);
   protected:
   private:
};





// THandler ***************************************************************

class THandler
{
   public:
      THandler(const char *aTitle,
               Boolean aExtPalette = False,
               Boolean aUseSounds = False,
               Boolean aDOSHandler = False);
      ~THandler();
      void suspend();
      void resume();
      void setSounds(Boolean aUseSounds);
      Boolean getSounds();
      void setExtPalette(Boolean aExtPalette);
      Boolean getExtPalette();
      void setDOSHandler(Boolean aDOSHandler);
      Boolean DOSHandlerSet();
      Boolean status;
   private:
      Boolean DOSHandler;
      // Pointer to original ISR
      static void interrupt (far *oldInt24)(...);
      // ISR for Turbo Vision
      static void far newTvHandler(unsigned ax_,
                                   unsigned di_,
                                   unsigned far *bpsi_);
      // ISR for DOS
      static void far newDosHandler(unsigned ax_,
                                    unsigned di_,
                                    unsigned far *bpsi_);
};


#endif

//                                End of THANDLER.HPP


