/*-----------------------------------------------------------------------*/
/* filename -       tdemo.hpp                                            */
/*                                                                       */
/* function(s)                                                           */
/*                  declarations for the TDemoDialog and TDemoApp        */
/*                  classes                                              */
/*                                                                       */
/* author -         Michael "Mick" Newton                                */
/*                                                                       */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/*                                                                       */
/*    TDEMO.HPP                                                          */
/*                                                                       */
/*    THandler shareware version 2.0                                     */
/*    Copyright (C) 1992,1993 Comsoft Software                           */
/*    All Rights Reserved.                                               */
/*                                                                       */
/*-----------------------------------------------------------------------*/


#if !defined __TDEMO_HPP
#define __TDEMO_HPP


// Forward references to Turbo Vision classes *****************************

class far TApplication;
class far TDeskTop;
class far TDialog;
class far TEvent;
class far TMenuBar;
class far TPalette;
class far TRect;
class far TStatusLine;





// Forward references to non-Turbo Vision classes *************************

class far THandler;





// Constants **************************************************************

// Menubar and dialog commands
const cmAbout      = 200,
      cmOptions    = 201,
      cmTests      = 202,
      cmDriveA     = 203,
      cmDriveB     = 204,
      cmLPT1       = 205,
      cmLPT2       = 206,
      cmLPT3       = 207,
      hcNone       = hcNoContext;

// Bit masks for TOptionsDataRec 'use' checkboxes
const ofUseSounds  = 0x0001,
      ofExtPal     = 0x0002,
      ofSuspendTV  = 0x0004,
      ofUseDosISR  = 0x0008;





// Data structures ********************************************************

// For options dialog
struct TOptionsDataRec
{
   ushort use;          // THandler options checkbox
   ushort video;        // Video mode radio button
};





// TDemoDialog ************************************************************

class TDemoDialog : public TDialog
{
   public:
      TDemoDialog(const TRect& bounds, const char *aTitle);
      virtual void handleEvent(TEvent& event);
};





// TDemoApp ***************************************************************

class TDemoApp : public TApplication
{
   public:
      TDemoApp();
      virtual void shutDown();
      virtual Boolean valid(ushort command);
      virtual TPalette& getPalette() const;
      virtual void handleEvent(TEvent& Event);
      static TDeskTop *initDeskTop(TRect r);
      static TMenuBar *initMenuBar(TRect r);
      static TStatusLine *initStatusLine(TRect r);
   protected:
   private:
      Boolean status;             // Object status
      TOptionsDataRec optrec;     // Options dialog data
      THandler *newHandler;       // Pointer to error handler object
      void about();               // About dialog
      void options();             // Options dialog
      ushort testDevices();       // Device test dialog
};





// Non-member function declarations ***************************************

void displayMessage();
void exitfunc();


#endif

//                                End of TDEMO.HPP

