/* ------------------------------------------------------------------------*/
/*                                                                         */
/*   TFIELD.H  -- Version 1.1.0                                            */
/*                                                                         */
/*   Portions Copyright (c) Borland International 1991                     */
/*   All Rights Reserved.                                                  */
/*                                                                         */
/*   defines the classes TField, TUpperField, TDateField, TDate, TIntField */
/*                                                                         */
/* ------------------------------------------------------------------------*/


/* ---------------------------------------------------------------------- */
/*      class TField                                                      */
/*                                                                        */
/*      Palette layout                                                    */
/*        1 = Passive                                                     */
/*        2 = Active                                                      */
/*        3 = Selected                                                    */
/*        4 = Arrows                                                      */
/* ---------------------------------------------------------------------- */

#if !defined( __CTYPE_H )
#include <ctype.h>
#endif  // __CTYPE_H

#if !defined( __STDIO_H )
#include <stdio.h>
#endif

#if !defined( __STRING_H )
#include <string.h>
#endif

#if !defined( __STDLIB_H )
#include <stdlib.h>
#endif

#if !defined( __IOSTREAM_H )
#include <iostream.h>
#endif

#if !defined( __DOS_H )
#include <dos.h>
#endif

#if defined( Uses_TDateField )
#define Uses_TField
#define Uses_TDate
#endif

#if defined( Uses_TIntField )
#define Uses_TField
#endif

#if defined( Uses_TLongField )
#define Uses_TField
#endif

#if defined( Uses_TFloatField )
#define Uses_TField
#endif

#if defined( Uses_TUpperField )
#define Uses_TField
#endif

#if defined( Uses_TDate )
#define Uses_TStringCollection
#endif

#if defined ( Uses_TStringCollection ) && !defined( __TStringCollection )
#include <tv.h>
#endif

#if defined( Uses_TField ) && !defined( __TField )
#define __TField

inline void beep( void )
{
	cout << (char) 7;
}

//************************************************************************
// 2/1/92 -- MBB
// Added the following codes for tfOptions
//************************************************************************
const ushort 	tfRight			= 0x0001,
					tfNoScroll		= 0x0002,
					tfHideSecure	= 0x0004,
					tfValidateMax  = 0x0008,
					tfValidateMin  = 0x0010,
					tfMustFill     = 0x0020,
					tfNotEmpty     = 0x0040,
					tfBeepError    = 0x0080,
					tfEnterTabs    = 0x0100,
					tfStayError    = 0x0200,
					tfPopUp        = 0x0400,
					tfPreValidate	= 0x1000;

//
// Field Type Constants
//
const int TFieldType = 1;
const int TUpperFieldType = 2;
const int TDateFieldType = 3;
const int TIntFieldType = 4;
const int TLongFieldType = 5;
const int TFloatFieldType = 6;



//
// BroadCast Messages for TField
//
const ushort
	cmUpdateSecurity	= 0xCC01, 	// message to fields to reset the current
											// security level
	cmLeaving 			= 0xCC02,	// validate on leaving the current field
	cmArriving			= 0xCC03;	// validate on arriving at the current field


class far TRect;
class far TEvent;

class TField : public TView
{

public:

	TField( const TRect& bounds, int aMaxLen );
	~TField();

	virtual 	void 			convertData( void );
	virtual 	ushort 		dataSize();
	virtual 	void 			draw();
	virtual 	ushort		filterCharCode( ushort charCode);
	virtual 	void 			getData( void *rec );
	virtual 	TPalette& 	getPalette() const;
	virtual 	void 			gotFocus( void );
	virtual 	void 			handleEvent( TEvent& event );
	virtual 	Boolean 		isValid( ushort command );
	virtual 	void 			lostFocus( void );
	virtual	ushort		processKeyCode( ushort keyCode);
				void 			selectAll( Boolean enable );
	virtual 	void 			setCurrentSecurity( ushort newSecurityLevel);
	virtual 	void 			setData( void *rec );
	virtual 	void 			setFieldHint( char *aString );
	virtual 	void 			setFieldName( char *aString );
	virtual 	void 			setHideChar( char aChar );
	virtual 	void 			setTFOptions( ushort anOption, Boolean enable );
	virtual 	Boolean 		valid( ushort command);

	char* data;
	int maxLen;
	int curPos;
	int firstPos;
	int selStart;
	int selEnd;
	ushort tfOptions;
	//
	// tfRight -- right justification on, otherwise will left justify
	// tfNoScroll -- scrolling off, otherwise will scroll
	// tfHideSecure -- if fieldSecurity > currentSecurity then mask the field
	//               with securityChar
	// tfValidateMax -- check the fields value against the specified Max value
	// tfValidateMin -- check the fields value against the specified Min value
	// tfMustFill -- field must contain maxLen characters
	// tfNotEmpty -- field must contain at least 1 character
	// tfBeepError -- beep at invalid keystrokes and error
	// tfEnterTabs -- map the enter key to the tab key
	// tfStayError -- if set, the field can't be left unless it is valid
	// tfPopUp -- enable popup fill-in (eg. calendar for dates &
	//            calculator for numbers)
	// tfPreValidate -- call the isValid function before performing other
	//                  standard validations
	char hideChar; // if hideChar > ' ' then field is masked
	char securityChar; // used with security checking for masking secure fields
	ushort fieldSecurity; // security level for this field
	ushort currentSecurity; // security level from the owner
	char *fieldHint; // used for the hint line
	char *fieldName; // holds a name for the current field
	int fieldType; // for determining type is passed as a generic TField * pointer

private:

	Boolean canScroll( int delta );
	int mouseDelta( TEvent& event );
	int mousePos( TEvent& event );
	void deleteSelect();

	static const char near rightArrow;
	static const char near leftArrow;

	virtual const char *streamableName() const
		{ return name; }

protected:
	Boolean dataChanged; // tracks is data needs convertsion

	TField( StreamableInit );
	virtual void write( opstream& );
	virtual void *read( ipstream& );

public:

	static const char * const near name;
	static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TField& cl )
	{ return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TField*& cl )
	{ return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TField& cl )
	{ return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TField* cl )
	{ return os << (TStreamable *)cl; }

#endif  // Uses_TField


#if defined( Uses_TUpperField ) && !defined( __TUpperField )
#define __TUpperField

class TUpperField: public TField
{
public:
	TUpperField( const TRect& bounds, int aMaxLen );

	virtual	ushort		filterCharCode( ushort charCode );
	virtual	void			setData( void *rec );

	static const char * const near name;
};
#endif // Uses_TUpperField

#if defined( Uses_TIntField ) && !defined( __TIntField )
#define __TIntField

class TIntField: public TField
{
public:
	TIntField( const TRect& bounds, int aMaxLen );

	virtual 	void 			convertData( void );
	virtual 	ushort 		dataSize();
	virtual	ushort		filterCharCode( ushort charCode );
	virtual 	void 			getData( void *rec );
	virtual 	Boolean 		isValid( ushort command );
	virtual	ushort		processKeyCode( ushort keyCode );
	virtual 	void 			setData( void *rec );
	virtual	void			setMax( int newMax );
	virtual	void			setMin( int newMin );

	int	value, // field's current value
			maxValue,
			minValue;

	static const char * const near name;
};

#endif // Uses_TIntField

#if defined( Uses_TLongField ) && !defined( __TLongField )
#define __TLongField

class TLongField: public TField
{
public:
	TLongField( const TRect& bounds, int aMaxLen );

	virtual 	void 			convertData( void );
	virtual 	ushort 		dataSize();
	virtual	ushort		filterCharCode( ushort charCode );
	virtual 	void 			getData( void *rec );
	virtual 	Boolean 		isValid( ushort command );
	virtual	ushort		processKeyCode( ushort keyCode );
	virtual 	void 			setData( void *rec );
	virtual	void			setMax( long newMax );
	virtual	void			setMin( long newMin );

	long	value, // field's current value
			maxValue,
			minValue;

	static const char * const near name;
};

#endif // Uses_TLongField

#if defined( Uses_TFloatField ) && !defined( __TFloatField )
#define __TFloatField

class TFloatField: public TField
{
public:
	TFloatField( const TRect& bounds, int aMaxLen );
	~TFloatField();

	virtual 	void 			convertData( void );
	virtual 	ushort 		dataSize();
	virtual	ushort		filterCharCode( ushort charCode );
	virtual 	void 			getData( void *rec );
	virtual 	Boolean 		isValid( ushort command );
	virtual	ushort		processKeyCode( ushort keyCode );
	virtual 	void 			setData( void *rec );
	virtual 	void			setFormat( char * newFormat );
	virtual	void			setMax( float newMax );
	virtual	void			setMin( float newMin );

	float	value, // field's current value
			maxValue,
			minValue;

	char *formatString;	// field's format string for sprintf function call

	static const char * const near name;
};

#endif // Uses_TFloatField

#if defined( Uses_TDate ) && !defined( __TDate )
#define __TDate

#define ABBR_LENGTH 3

const int maxLine = 81;

const enum format_type {MDY, DAY, MONTH, FULL, EUROPEAN};
const enum {OFF, ON};

const unsigned char NO_CENTURY  = 0x02;
const unsigned char DATE_ABBR   = 0x04;

const long PXOffset = 1721424L;

class TParser : public TStringCollection
{

public:

	TParser( short aLimit, short aDelta ) :
		TStringCollection( aLimit, aDelta) {}
	#pragma argsused
	virtual int compare(void *key1, void *key2)
	{
		// add in order encountered
		return -1;
	};
	void parse( char *line );

};


class TDate
{
	protected:
		unsigned long julian;          // days since 1/1/4713 B.C.
		int tdate_year;
		int tdate_month;
		int tdate_day;
		int day_of_week;  		       // 1 = Sunday, ... 7 = Saturday

	private:
		int displayFormat;
		unsigned char displayOptions;

		void julian_to_mdy (void);         // convert julian day to mdy
		void julian_to_wday (void);        // convert julian day to day_of_week
		void mdy_to_julian (void);         // convert mdy to julian day

		int char_to_month( const char *charMonth);	// convert month name to month value

	public:

		TDate ();
		TDate (const long aJulDate, const long offset = 0);
		TDate (const int m, const int d, const int y);
		TDate (char *dat);
		TDate (const date &ds);
		TDate (const TDate &dt);

		TDate &operator +  (const long i);
		TDate &operator -  (const long i);
		long  operator -  (const TDate &dt);
		TDate &operator += (const long i);
		TDate &operator -= (const long i);
		TDate &operator ++ (void); // pre increment function
		TDate &operator ++ (int); // post increment function
		TDate &operator -- (void); // pre decrement function
		TDate &operator -- (int); // post decrement function

		friend int operator <  (const TDate &dt1, const TDate &dt2);
		friend int operator <= (const TDate &dt1, const TDate &dt2);
		friend int operator >  (const TDate &dt1, const TDate &dt2);
		friend int operator >= (const TDate &dt1, const TDate &dt2);
		friend int operator == (const TDate &dt1, const TDate &dt2);
		friend int operator != (const TDate &dt1, const TDate &dt2);

		friend ostream &operator << (ostream &os, const TDate &dt);
		friend ostream &operator << (ostream &os, const date &dt);

		char *formatDate (int type=-1) const;
		void setFormat (const int format);
		int setOption (const int option, const int action=ON);
		int setDate (const char *charDate); // returns 1 if successful, 0 if not
		int setDate (const long aJulDate, const long offset = 0 ); // returns 1 if successful, 0 if not
		void incrMonth(void);
		void decrMonth(void);
		void incrYear(void);
		void decrYear(void);

		long julDate(void) const;  // returns julian date
		long PXDate(void) const; // returns date in PX format
		int day(void) const;
		int dow(void) const;
		int month(void) const;
		int year(void) const;
		int dayOfYear(void) const;  // returns relative date since Jan. 1
		int isLeapYear(void) const;  // returns 1 if leap year, 0 if not

		// note that the next functions return a date struct as defined in
		// dos.h (distinct from the TDate class) Order is year, day, month.
		date eom(void) const;  // returns last day of month in object
		date getDate(void) const;  // returns a date structure
} ;

#endif // __TDate



#if defined( Uses_TDateField ) && !defined( __TDateField )
#define __TDateField

class TDateField: public TField
{
public:
	TDateField( const TRect& bounds, int aMaxLen );

	virtual 	void 			convertData( void );
	virtual 	ushort 		dataSize();
	virtual	ushort 		filterCharCode( ushort charCode );
	virtual 	void 			getData( void *rec );
	virtual 	Boolean 		isValid( ushort command );
	virtual	ushort		processKeyCode( ushort keyCode );
	virtual 	void 			setData( void *rec );
	virtual	void			setMax( TDate newMax );
	virtual	void			setMin( TDate newMin );

				void			setJulian( long julDate );
				void			setParadox( long pxDate );

	TDate	value, // field's current value
			maxValue,
			minValue;

	static const char * const near name;
};

#endif // Uses_TDateField

