/*------------------------------------------------------------*/
/* filename -       tifield.cpp                               */
/*                                                            */
/* function(s)                                                */
/*                  TIntField member functions                */
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*                                                            */
/*    Turbo Vision Extensions -- Version 1.0.0                */
/*                                                            */
/*                                                            */
/*    Portions Copyright (c) 1991 by Borland International    */
/*    All Rights Reserved.                                    */
/*                                                            */
/*    TV Extensions are Copyright (c) 1992 by Michael Bonner  */
/*    These extensions may be freely used by any programmer   */
/*    including royalty free inclusion in any commercial      */
/*    application, but any commercial rights to the source    */
/*    code or object files of the Extensions are reserved.    */
/*                                                            */
/*------------------------------------------------------------*/

#define Uses_ipstream
#define Uses_MsgBox
#define Uses_opstream
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TDrawBuffer
#define Uses_TEvent
#define Uses_TField
#define Uses_TIntField
#define Uses_TKeys
#define Uses_TRect
#define Uses_TView

#include <tv.h>
#include "tfield.h"

#if !defined( __CTYPE_H )
#include <ctype.h>
#endif  // __CTYPE_H

#if !defined( __STRING_H )
#include <String.h>
#endif  // __STRING_H

#if !defined( __DOS_H )
#include <Dos.h>
#endif  // __DOS_H

#if !defined( __MEM_H )
#include <Mem.h>
#endif  // __MEM_H

#if !defined( __STDLIB_H )
#include <Stdlib.h>
#endif // __STDLIB_H

#if !defined( __STRSTREAM_H )
#include <Strstream.h>
#endif // __STRSTREAM_H

const char * const near TIntField::name = "TIntField";

TIntField::TIntField( const TRect& bounds, int aMaxLen ) :
	TField(bounds, aMaxLen),
	value (0),
	maxValue (0),
	minValue (0)
	{
	fieldType = TIntFieldType;
	}

void TIntField::convertData( void )
{
	value = atoi(data);
	char buffer[18];
	itoa( value, buffer, 10);
	strncpy(data, buffer, maxLen);
	data[maxLen + 1] = EOS;
	drawView();
	dataChanged = False;
}

ushort TIntField::dataSize()
{
	return sizeof(value);
}

ushort TIntField::filterCharCode( ushort charCode) //Virtual
{
	char buffer[40];

	ushort retChar = 0;

	Boolean test = False;

	switch (charCode)
		{
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			retChar = charCode;
			break;

		case '-':
			if (	(selStart == 0) &&
					(selEnd == strlen(data)) )
				{
				if ((tfOptions & tfValidateMin) != 0 )
					if ( value > minValue )
						test = True;
					else
						test = False;
				else
					test = True;

				if (test)
					{
					if (dataChanged)
						convertData();
					value--;
					itoa(value, buffer, 10);
					strnset( data, ' ', maxLen );
					strncpy( data, buffer, maxLen );
					data[maxLen + 1] = EOS;
					drawView();
					}
				else
					if ((tfOptions & tfBeepError) != 0)
						beep();
				retChar = 1;
				}
			else
				if (curPos == 0)
					retChar = charCode;
				else
					if ( (tfOptions & tfBeepError) != 0)
						beep();
			break;

		case '+':
			if (	(selStart == 0) &&
					(selEnd == strlen(data)) )
				{
				if ((tfOptions & tfValidateMax) != 0 )
					if ( value < maxValue )
						test = True;
					else
						test = False;
				else
					test = True;

				if (test)
					{
					if (dataChanged)
						convertData();
					value++;
					itoa(value, buffer, 10);
					strnset( data, ' ', maxLen );
					strncpy( data, buffer, maxLen );
					data[maxLen + 1] = EOS;
					drawView();
					}
				else
					if ((tfOptions & tfBeepError) != 0)
						beep();
				retChar = 1;
				}
			else
				if ( (tfOptions & tfBeepError) != 0)
					beep();
			break;

		case 0:
			break;

		default:
			if ((tfOptions & tfBeepError) != 0)
				beep();

		};


	return retChar;
}

void TIntField::getData( void *rec )
{
	convertData();
	memcpy( rec, &value, sizeof(value) );
}

Boolean TIntField::isValid( ushort command )
{
	Boolean status = True;
	char buf[160];

	switch (command) {
		case cmArriving:
			status = True;
			break;

		case cmLeaving:
			if ( 	((tfOptions & tfNotEmpty) != 0) &&
					( strlen(data) == 0 ) ) {
				status = False;
				if ((tfOptions & tfBeepError) != 0)
					beep();
				messageBox("This field must contain a number!",
					mfWarning | mfOKButton );
			}
			else
				if ( 	((tfOptions & tfValidateMax) != 0 ) &&
						( value > maxValue ) ) {
					status = False;
					if ((tfOptions & tfBeepError) != 0)
						beep();
					ostrstream os( buf, sizeof( buf ) );
					os << "The number in this field must be less than "
						<< maxValue << "!" << ends;
					messageBox(	buf, mfWarning | mfOKButton);
				}
				else
					if ( 	((tfOptions & tfValidateMin) != 0 ) &&
							( value < minValue ) ) {
						status = False;
						if ((tfOptions & tfBeepError) != 0)
							beep();
						ostrstream os( buf, sizeof( buf ) );
						os << "The number in this field must be greater than "
							<< minValue << "!" << ends;
						messageBox(	buf, mfWarning | mfOKButton);
					};
				break;
	};

	return status;
}

ushort TIntField::processKeyCode( ushort keyCode ) //Virtual
	{
	ushort retKeyCode = keyCode; 	// return a 1 to selectAll( true ) the field in the handleEvent routine

	char buffer[40];

	if ( keyCode == kbPgDn )
		if (	(selStart == 0) &&
				(selEnd == strlen(data)) )
			{
			if (dataChanged)
				convertData();
			value += 10;
			if ( 	((tfOptions & tfValidateMax) != 0 ) &&
					( value > maxValue ) )
				{
				value -= 10;
				if ((tfOptions & tfBeepError) != 0)
					beep();
				};
			retKeyCode = 1;
			itoa(value, buffer, 10);
			strnset( data, ' ', maxLen );
			strncpy( data, buffer, maxLen );
			data[maxLen + 1] = EOS;
			drawView();
			};

	if ( keyCode == kbPgUp )
		if (	(selStart == 0) &&
				(selEnd == strlen(data)) )
			{
			if (dataChanged)
				convertData();
			value -= 10;
			if ( 	((tfOptions & tfValidateMin) != 0 ) &&
					( value < minValue ) )
				{
				value += 10;
				if ((tfOptions & tfBeepError) != 0)
					beep();
				};
			retKeyCode = 1;
			itoa(value, buffer, 10);
			strnset( data, ' ', maxLen );
			strncpy( data, buffer, maxLen );
			data[maxLen + 1] = EOS;
			drawView();
			};

	return retKeyCode;
	}

void TIntField::setData( void *rec )
{
	char buffer[18];
	memcpy( &value, rec, sizeof(value) );
	itoa( value, buffer, 10);
	strncpy(data, buffer, maxLen);
	data[maxLen + 1] = EOS;
	selectAll( True );
}

void TIntField::setMax( int newMax )
{
	maxValue = newMax;
	setTFOptions( tfValidateMax, True );

	if (minValue > maxValue)
		minValue = maxValue;
}

void TIntField::setMin( int newMin )
{
	minValue = newMin;
	setTFOptions( tfValidateMin, True );

	if (maxValue < minValue)
		maxValue = minValue;
}
