/*---------------------------------------------------------*/
/*                                                         */
/*   Turbo Vision Extensions 1.1                           */
/*                                                         */
/*   TField Example Program File                           */
/*---------------------------------------------------------*/

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TButton
#define Uses_TCheckBoxes
#define Uses_TDateField
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TEventQueue
#define Uses_TFrame
#define Uses_TIndicator
#define Uses_TKeys
#define Uses_TLabel
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TMessageBox
#define Uses_TProgram
#define Uses_TRect
#define Uses_TSItem
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TStreamable
#define Uses_TStreamableClass
#define Uses_TSubMenu
#define Uses_TView
#define Uses_TWindow

#define Uses_TField
#define Uses_TUpperField
#define Uses_TIntField
#define Uses_TLongField
#define Uses_TFloatField

#include <tv.h>
#include "TField.h"

#if !defined( __STRING_H )
#include <string.h>
#endif  // __STRING_H

#if !defined( __STDLIB_H )
#include <stdlib.h>
#endif  // __STDLIB_H

#if !defined( __STRSTREAM_H )
#include <strstream.h>
#endif  // __STRSTREAM_H


const int cmFieldOptDlg = 101;
const int cmDoFOD = 102;

short gWinNumber = 0; // Window Number

#define cpForm14 "\x20\x21\x22\x23\x24\x25\x26\x27\x28\x29\x2A\x2B\x2C\x2D\x2E\x2F"\
					  "\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F"

struct Form14Record
{
	 long dateValue;
	 int  intValue;
	 char charValue[128];
	 char upperValue[128];
	 long longValue;
	 float floatValue;
};

Form14Record *F14MyData;

void TFieldOptDlg( TField *field, TApplication *application )
	{
	int fieldType = field->fieldType;

	if ( (fieldType < 0) || (fieldType > 6) )
		{
		messageBox("This field does not have TField options!", mfError | mfCancelButton);
		return;
		};

	TDialog *pd = new TDialog( TRect( 15, 2, 65, 21), "Change TField Options" );
	if( pd )
		{
		// add fieldName input
		TView *b = new TField( TRect( 13, 3, 26, 4), 33 );
		pd->insert( b );
		pd->insert( new TLabel( TRect( 2, 3, 12, 4 ),
			"fieldName", b ));

		// add fieldHint input
		b = new TField( TRect( 13, 4, 26, 5), 33 );
		pd->insert( b );
		pd->insert( new TLabel( TRect( 2, 4, 12, 5 ),
			"fieldHint", b ));

		// add hideChar input
		b = new TField( TRect( 19, 6, 20, 7), 2 );
			((TField *)b)->setTFOptions( tfNoScroll, True );
		pd->insert( b );
		pd->insert( new TLabel( TRect( 9, 6, 18, 7 ),
			"h~i~deChar", b ));

		// add securityChar input
		b = new TField( TRect( 19, 7, 20, 8 ), 2 );
			((TField *)b)->setTFOptions( tfNoScroll, True );
		pd->insert( b );
		pd->insert( new TLabel( TRect( 5, 7, 18, 8 ),
			"sec~u~rityChar", b ));

		// add fieldSecurity input
		b = new TIntField( TRect( 19, 9, 26, 10 ), 7 );
			((TField *)b)->setTFOptions( tfNoScroll | tfRight, True );
		pd->insert( b);
		pd->insert( new TLabel( TRect( 4, 9, 18, 10 ),
			"fiel~d~Security", b ));

		// add currentSecurity input
		b = new TIntField( TRect( 19, 10, 26, 11 ), 7 );
			((TField *)b)->setTFOptions( tfNoScroll | tfRight, True );
		pd->insert( b);
		pd->insert( new TLabel( TRect( 2, 10, 18, 11 ),
			"currentSecurit~y~", b ));

		struct DialogData
			{
			char fieldName[33];
			char fieldHint[33];
			char hideChar[2];
			char securityChar[2];
			int fieldSecurity;
			int currentSecurity;
			ushort tfOptions;
			};
		struct DateDialogData
			{
			char fieldName[33];
			char fieldHint[33];
			char hideChar[2];
			char securityChar[2];
			int fieldSecurity;
			int currentSecurity;
			long minValue;
			long maxValue;
			ushort tfOptions;
			};
		struct IntDialogData
			{
			char fieldName[33];
			char fieldHint[33];
			char hideChar[2];
			char securityChar[2];
			int fieldSecurity;
			int currentSecurity;
			int minValue;
			int maxValue;
			ushort tfOptions;
			};
		struct LongDialogData
			{
			char fieldName[33];
			char fieldHint[33];
			char hideChar[2];
			char securityChar[2];
			int fieldSecurity;
			int currentSecurity;
			long minValue;
			long maxValue;
			ushort tfOptions;
			};
		struct FloatDialogData
			{
			char fieldName[33];
			char fieldHint[33];
			char hideChar[2];
			char securityChar[2];
			int fieldSecurity;
			int currentSecurity;
			float	minValue;
			float maxValue;
			char formatString[33];
			ushort tfOptions;
			};
		void *optionsData = NULL;

		switch (fieldType)
			{
			case TDateFieldType:
				// add minValue input
				b = new TDateField( TRect( 13, 13, 26, 14), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 3, 13, 12, 14 ),
					"minValue", b ));

				// add maxValue input
				b = new TDateField( TRect( 13, 14, 26, 15), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 3, 14, 12, 15 ),
					"maxValue", b ));

				optionsData = new DateDialogData;
				break;

			case TIntFieldType:
				// add minValue input
				b = new TIntField( TRect( 13, 13, 26, 14), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 3, 13, 12, 14 ),
					"minValue", b ));

				// add maxValue input
				b = new TIntField( TRect( 13, 14, 26, 15), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 3, 14, 12, 15 ),
					"maxValue", b ));

				optionsData = new IntDialogData;
				break;

			case TLongFieldType:
				// add minValue input
				b = new TLongField( TRect( 13, 13, 26, 14), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 3, 13, 12, 14 ),
					"minValue", b ));

				// add maxValue input
				b = new TLongField( TRect( 13, 14, 26, 15), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 3, 14, 12, 15 ),
					"maxValue", b ));

				optionsData = new LongDialogData;
				break;

			case TFloatFieldType:
				// add minValue input
				b = new TFloatField( TRect( 13, 12, 26, 13), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				if ( ((TFloatField *)field)->formatString != NULL )
					((TFloatField *)b)->setFormat( ((TFloatField *)field)->formatString );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 3, 12, 12, 13 ),
					"minValue", b ));

				// add maxValue input
				b = new TFloatField( TRect( 13, 13, 26, 14), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				if ( ((TFloatField *)field)->formatString != NULL )
					((TFloatField *)b)->setFormat( ((TFloatField *)field)->formatString );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 3, 13, 12, 14 ),
					"maxValue", b ));

				// add formatString input
				b = new TField( TRect( 16, 14, 26, 15), 33 );
				((TField *)b)->setTFOptions( tfNoScroll | tfStayError, True );
				pd->insert( b );
				pd->insert( new TLabel( TRect( 2, 14, 15, 15 ),
					"formatString", b ));

				optionsData = new FloatDialogData;
				break;

			default:
				optionsData = new DialogData;
				break;
			};

		b = new TCheckBoxes( TRect( 28, 3, 47, 15),
			new TSItem( "tf~R~ight",
			new TSItem( "tfNo~S~croll",
			new TSItem( "tf~H~ideSecure",
			new TSItem( "tfValidate~M~ax",
			new TSItem( "tfValidateMi~n~",
			new TSItem( "tfMust~F~ill",
			new TSItem( "tfNot~E~mpty",
			new TSItem( "tf~B~eepError",
			new TSItem( "tfEnter~T~abs",
			new TSItem( "tfSt~a~yError",
			new TSItem( "tfPopUp",
			new TSItem( "tfPreValidate", 0 )))))))))))));
		pd->insert( b );
		pd->insert( new TLabel( TRect( 27, 2, 37, 3), "tfO~p~tions", b ));

		pd->insert( new TButton( TRect( 14, 16, 24, 18 ), "~O~K", cmOK,
			bfDefault ));
		pd->insert( new TButton( TRect( 26, 16, 36, 18 ), "~C~ancel", cmCancel,
			bfNormal ));

		if (optionsData)
			{
			// we save the dialog data:
			if (field->fieldName != NULL)
				strncpy(((DialogData *)optionsData)->fieldName, field->fieldName, 33);
			else
				((DialogData *)optionsData)->fieldName[0] = EOS;
			if (field->fieldHint != NULL)
				strncpy(((DialogData *)optionsData)->fieldHint, field->fieldHint, 33);
			else
				((DialogData *)optionsData)->fieldHint[0] = EOS;
			((DialogData *)optionsData)->hideChar[0] = field->hideChar;
			((DialogData *)optionsData)->hideChar[1] = EOS;
			((DialogData *)optionsData)->securityChar[0] = field->securityChar;
			((DialogData *)optionsData)->securityChar[1] = EOS;
			((DialogData *)optionsData)->fieldSecurity = field->fieldSecurity;
			((DialogData *)optionsData)->currentSecurity = field->currentSecurity;
			switch (fieldType)
				{
				case TDateFieldType:
					((DateDialogData *)optionsData)->minValue = ((TDateField *)field)->minValue.julDate();
					((DateDialogData *)optionsData)->maxValue = ((TDateField *)field)->maxValue.julDate();
					((DateDialogData *)optionsData)->tfOptions = field->tfOptions;
					break;
				case TIntFieldType:
					((IntDialogData *)optionsData)->minValue = ((TIntField *)field)->minValue;
					((IntDialogData *)optionsData)->maxValue = ((TIntField *)field)->maxValue;
					((IntDialogData *)optionsData)->tfOptions = field->tfOptions;
					break;
				case TLongFieldType:
					((LongDialogData *)optionsData)->minValue = ((TLongField *)field)->minValue;
					((LongDialogData *)optionsData)->maxValue = ((TLongField *)field)->maxValue;
					((LongDialogData *)optionsData)->tfOptions = field->tfOptions;
					break;
				case TFloatFieldType:
					((FloatDialogData *)optionsData)->minValue = ((TFloatField *)field)->minValue;
					((FloatDialogData *)optionsData)->maxValue = ((TFloatField *)field)->maxValue;
					((FloatDialogData *)optionsData)->tfOptions = field->tfOptions;
					if ( ((TFloatField *)field)->formatString == NULL )
						((FloatDialogData *)optionsData)->formatString[0] = '\0';
					else
						strcpy( ((FloatDialogData *)optionsData)->formatString, ((TFloatField *)field)->formatString );
					break;
				default:
					((DialogData *)optionsData)->tfOptions = field->tfOptions;
					break;
				};

			pd->setData( optionsData );

			ushort control = application->execView( pd );

			// and read it back when the dialog box is successfully closed
			if( control != cmCancel )
				{
				pd->getData( optionsData );
				if (((DialogData *)optionsData)->fieldName[0] != EOS)
				field->setFieldName( ((DialogData *)optionsData)->fieldName );
				field->setFieldHint( ((DialogData *)optionsData)->fieldHint );
				field->hideChar = ((DialogData *)optionsData)->hideChar[0];
				field->securityChar = ((DialogData *)optionsData)->securityChar[0];
				field->fieldSecurity = ((DialogData *)optionsData)->fieldSecurity;
				field->currentSecurity = ((DialogData *)optionsData)->currentSecurity;
				switch (fieldType)
					{
					case TDateFieldType:
						((TDateField *)field)->minValue = ((DateDialogData *)optionsData)->minValue;
						((TDateField *)field)->maxValue = ((DateDialogData *)optionsData)->maxValue;
						field->tfOptions = ((DateDialogData *)optionsData)->tfOptions;
						break;
					case TIntFieldType:
						((TIntField *)field)->minValue = ((IntDialogData *)optionsData)->minValue;
						((TIntField *)field)->maxValue = ((IntDialogData *)optionsData)->maxValue;
						field->tfOptions = ((IntDialogData *)optionsData)->tfOptions;
						break;
					case TLongFieldType:
						((TLongField *)field)->minValue = ((LongDialogData *)optionsData)->minValue;
						((TLongField *)field)->maxValue = ((LongDialogData *)optionsData)->maxValue;
						field->tfOptions = ((LongDialogData *)optionsData)->tfOptions;
						break;
					case TFloatFieldType:
						((TFloatField *)field)->minValue = ((FloatDialogData *)optionsData)->minValue;
						((TFloatField *)field)->maxValue = ((FloatDialogData *)optionsData)->maxValue;
						if ( ((FloatDialogData *)optionsData)->formatString[0] == '\0' )
							if ( ((TFloatField *)field)->formatString != NULL )
								{
								delete ((TFloatField *)field)->formatString;
								((TFloatField *)field)->formatString = NULL;
								}
							else
								((TFloatField *)field)->formatString = NULL;
						else
							((TFloatField *)field)->setFormat(((FloatDialogData *)optionsData)->formatString);
						field->tfOptions = ((FloatDialogData *)optionsData)->tfOptions;
						break;
					default:
						field->tfOptions = ((DialogData *)optionsData)->tfOptions;
						break;
					};
				field->drawView();
				};

			// free the storage space
			delete optionsData;
			};
		};

	application->destroy( pd );
	}


class TForm14Window : public TWindow // define a new window class for form 14's
{
public:

	TForm14Window( const TRect& r, const char *aTitle, short aNumber); // declare a constructor
	~TForm14Window(); // declare a destructor class
	TPalette& getPalette() const; // override the getPalette function
	virtual void handleEvent( TEvent& event );

};

TForm14Window::TForm14Window( const TRect& r, const char *aTitle, short aNumber):
	TWindow( r, aTitle, aNumber),
	TWindowInit( &TForm14Window::initFrame)
{
	growMode = 0;						// Window is not resizable
	flags &= ~(wfClose | wfGrow | wfZoom);
}

TForm14Window::~TForm14Window()
{
	// Enable the Forms|Form14 menu command
	disableCommand( cmFieldOptDlg );
}

TPalette& TForm14Window::getPalette() const
{
	static TPalette palette( cpForm14, sizeof( cpForm14 )-1 );
	return palette;
}

void TForm14Window::handleEvent( TEvent& event )
{
	TWindow::handleEvent( event );

	 if( event.what == evCommand )
		  {
		  switch( event.message.command )
				{
				case cmFieldOptDlg:
					event.message.command = cmDoFOD;
					event.message.infoPtr = current;
					putEvent( event );
					break;
				default:
					return;
				};
			clearEvent( event );
			};
}


class TBudgetApp : public TApplication
{

public:

	 TBudgetApp();
	 ~TBudgetApp();

	 virtual void handleEvent( TEvent& event );
	 static TMenuBar *initMenuBar( TRect );
	 static TStatusLine *initStatusLine( TRect );

private:

	 void form14();
};


TBudgetApp::TBudgetApp() :
	 TProgInit( &TBudgetApp::initStatusLine,
					&TBudgetApp::initMenuBar,
					&TBudgetApp::initDeskTop
				 )
{
	// Initialize the F14MyData structure
	F14MyData = new Form14Record;
	TDate tempDate = "TODAY";
	F14MyData->dateValue = tempDate.julDate();
	F14MyData->intValue = 0;
	strcpy( F14MyData->charValue, "Testing a TField field!!!");
	strcpy( F14MyData->upperValue, "Testing a TUpperField field!!!");
	F14MyData->longValue = 65536;
	F14MyData->floatValue = 34.95;
	disableCommand( cmFieldOptDlg );
	form14();
}

void TBudgetApp::~TBudgetApp()
{
	// Clear up the dynamic data storage
	delete F14MyData;
}

void TBudgetApp::form14()
{
	TView *control, *histry;
	ushort value;

	// Create the new window //
		TForm14Window *F14win = new TForm14Window(TRect(10, 2, 70, 21), "Test Application", wnNoNumber);

	// If unsuccessful, then return //
		if (!F14win)
			return;

	// Begin Inserting User-Editable Areas //

		// Demo TDateField //
		TField *field = new TDateField(TRect(18,3,55,4), 39);
		field->setTFOptions(tfBeepError | tfEnterTabs | tfStayError, True);
		((TDateField *)field)->setMin( (TDate)"TODAY" - 7 );
		((TDateField *)field)->setMax( (TDate)"TODAY" + 7 );
		F14win->insert(field);
		F14win->insert(new TLabel(TRect(5,3,17,4), "T~D~ateField:", field));

		// Demo TIntField //
		field = new TIntField(TRect(18,5,55,6), 39);
		field->setTFOptions(tfBeepError | tfEnterTabs | tfStayError, True);
		((TIntField *)field)->setMin( -10 );
		((TIntField *)field)->setMax( 10 );
		F14win->insert(field);
		F14win->insert(new TLabel(TRect(5,5,17,6), "T~I~ntField:", field));

		// Demo TField //
		field = new TField(TRect(18,7,55,8), 128);
		field->setTFOptions(tfBeepError | tfEnterTabs | tfStayError, True);
		F14win->insert(field);
		F14win->insert(new TLabel(TRect(5,7,17,8), "~T~Field:", field));

		// Demo TUpperField //
		field = new TUpperField(TRect(18,9,55,10), 128);
		field->setTFOptions(tfBeepError | tfEnterTabs | tfStayError, True);
		F14win->insert(field);
		F14win->insert(new TLabel(TRect(5,9,17,10), "T~U~pperField:", field));

		// Demo TLongField //
		field = new TLongField(TRect(18,11,55,12), 39);
		field->setTFOptions(tfBeepError | tfEnterTabs | tfStayError, True);
		F14win->insert(field);
		F14win->insert(new TLabel(TRect(5,11,17,12), "T~L~ongField:", field));

		// Demo TFloatField //
		field = new TFloatField(TRect(18,13,55,14), 39);
		field->setTFOptions(tfBeepError | tfEnterTabs | tfStayError, True);
		F14win->insert(field);
		F14win->insert(new TLabel(TRect(5,13,17,14), "TFl~o~atField:", field));

		// Select the first field on the form
		F14win->selectNext(False);

		// Insert the form onto the desktop
		deskTop->insert( F14win );

		enableCommand( cmFieldOptDlg );

		// Initialize the form's data
		F14win->setData( F14MyData );

		//Return the window pointer
		return;
}

void TBudgetApp::handleEvent( TEvent& event )
{
	 TApplication::handleEvent( event );
	 if( event.what == evCommand )
		  {
		  switch( event.message.command )
				{
				case cmDoFOD:
					TFieldOptDlg( (TField *)event.message.infoPtr, this );
					break;
				default:
					 return;
				}
		  clearEvent( event ); // Clear the event after handling it
		  }
}

TMenuBar *TBudgetApp::initMenuBar( TRect r )
{

	 r.b.y = r.a.y+1;

	 return new TMenuBar( r,
		*new TSubMenu( "~F~ile", kbAltF ) +
		  *new TMenuItem( "E~x~it", cmQuit, cmQuit, hcNoContext, "Alt-X" )
		  );

}

TStatusLine *TBudgetApp::initStatusLine( TRect r )
{
	 r.a.y = r.b.y-1;
	 return new TStatusLine( r,
		  *new TStatusDef( 0, 0xFFFF ) +
				*new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
				*new TStatusItem( "~F2~ tfOptions", kbF2, cmFieldOptDlg ) +
				*new TStatusItem( 0, kbF10, cmMenu )
				);
}

int main()
{
	 TBudgetApp BudgetApp;
	 BudgetApp.run();
	 return 0;
}
