/*------------------------------------------------------------*/
/* filename -       tdfield.cpp                               */
/*                                                            */
/* function(s)                                                */
/*                  TDateField member functions                */
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*                                                            */
/*    Turbo Vision Extensions -- Version 1.0.0                */
/*                                                            */
/*                                                            */
/*    Portions Copyright (c) 1991 by Borland International    */
/*    All Rights Reserved.                                    */
/*                                                            */
/*    TV Extensions are Copyright (c) 1992 by Michael Bonner  */
/*    These extensions may be freely used by any programmer   */
/*    including royalty free inclusion in any commercial      */
/*    application, but any commercial rights to the source    */
/*    code or object files of the Extensions are reserved.    */
/*                                                            */
/*------------------------------------------------------------*/

#define Uses_ipstream
#define Uses_MsgBox
#define Uses_opstream
#define Uses_TDate
#define Uses_TDateField
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TDrawBuffer
#define Uses_TEvent
#define Uses_TField
#define Uses_TKeys
#define Uses_TRect
#define Uses_TView

#include <tv.h>
#include "tfield.h"

#if !defined( __CTYPE_H )
#include <ctype.h>
#endif  // __CTYPE_H

#if !defined( __STRING_H )
#include <String.h>
#endif  // __STRING_H

#if !defined( __DOS_H )
#include <Dos.h>
#endif  // __DOS_H

#if !defined( __MEM_H )
#include <Mem.h>
#endif  // __MEM_H

#if !defined( __STDLIB_H )
#include <Stdlib.h>
#endif // __STDLIB_H

#if !defined( __STRSTREAM_H )
#include <Strstream.h>
#endif // __STRSTREAM_H

const char * const near TDateField::name = "TDateField";

TDateField::TDateField( const TRect& bounds, int aMaxLen ) :
	TField(bounds, aMaxLen),
	value ((long) 0),
	maxValue ((long) 0),
	minValue ((long) 0)
	{
	fieldType = TDateFieldType;
	}

void TDateField::convertData( void )
{
	char buffer[40];
	strncpy( buffer, data, maxLen < 40 ? maxLen : 40 );
	if ( value.setDate( buffer ) ) {
		strncpy( buffer, value.formatDate(-1), 40 );
		strnset( data, ' ', maxLen );
		strncpy( data, buffer, maxLen );
		data[maxLen + 1] = EOS;
		drawView();
		dataChanged = False;
	};
}

ushort TDateField::dataSize()
{
	return sizeof(long);
}

ushort TDateField::filterCharCode( ushort charCode) //Virtual
{
	char buffer[40];

	ushort retChar;

	Boolean test;

	retChar = charCode;

	if (charCode == '+')
		if (	(selStart == 0) &&
				(selEnd == strlen(data)) )
			{
			if ((tfOptions & tfValidateMax) != 0 )
				if ( value < maxValue )
					test = True;
				else
					test = False;
			else
				test = True;

			if (test)
				{
				if (dataChanged)
					convertData();
				value++;
				strncpy( buffer, value.formatDate(-1), 40 );
				strnset( data, ' ', maxLen );
				strncpy( data, buffer, maxLen );
				data[maxLen + 1] = EOS;
				drawView();
				}
			else
				if ((tfOptions & tfBeepError) != 0)
					beep();
			retChar = 1;
			};

	if (charCode == '-')
		if (	(selStart == 0) &&
				(selEnd == strlen(data)) )
			{
			if ((tfOptions & tfValidateMin) != 0 )
				if ( value > minValue )
					test = True;
				else
					test = False;
			else
				test = True;

			if (test)
				{
				if (dataChanged)
					convertData();
				value--;
				strncpy( buffer, value.formatDate(-1), 40 );
				strnset( data, ' ', maxLen );
				strncpy( data, buffer, maxLen );
				data[maxLen + 1] = EOS;
				drawView();
				}
			else
				if ((tfOptions & tfBeepError) != 0)
					beep();
			retChar = 1;
			};

	return retChar;
}

void TDateField::getData( void *rec )
{
	convertData();
	long tempvalue = value.julDate();
	memcpy( rec, &tempvalue, sizeof(tempvalue) );
}

Boolean TDateField::isValid( ushort command )
{
	Boolean status = True;
	char buf[160];

	switch (command) {
		case cmArriving:
			status = True;
			break;

		case cmLeaving:
			if ( strcmp( value.formatDate(-1), "invalid date") == 0) {
				status = False;
				if ((tfOptions & tfBeepError) != 0)
					beep();
				ostrstream os( buf, sizeof( buf ) );
				os << '"' << data << '"' << " is not a valid date!" << ends;
				messageBox(	buf, mfWarning | mfOKButton);
			}
			else
				if ( 	((tfOptions & tfValidateMax) != 0 ) &&
						( value > maxValue ) ) {
					status = False;
					if ((tfOptions & tfBeepError) != 0)
						beep();
					ostrstream os( buf, sizeof( buf ) );
					os << "The date must be before "
						<< (TDate)(maxValue + 1) << "!" << ends;
					messageBox(	buf, mfWarning | mfOKButton);
				}
				else
					if ( 	((tfOptions & tfValidateMin) != 0 ) &&
							( value < minValue ) ) {
						status = False;
						if ((tfOptions & tfBeepError) != 0)
							beep();
						ostrstream os( buf, sizeof( buf ) );
						os << "The date must be after "
							<< (TDate)(minValue - 1) << "!" << ends;
						messageBox(	buf, mfWarning | mfOKButton);
					};
			break;
	};

	return status;
}

ushort TDateField::processKeyCode( ushort keyCode ) //Virtual
	{
	ushort retKeyCode = keyCode; 	// return a 1 to selectAll( true ) the field in the handleEvent routine

	char buffer[40];

	if ( keyCode == kbPgDn )
		if (	(selStart == 0) &&
				(selEnd == strlen(data)) )
			{
			if (dataChanged)
				convertData();
			value.incrMonth();
			if ( 	((tfOptions & tfValidateMax) != 0 ) &&
					( value > maxValue ) )
				{
				value.decrMonth();
				if ((tfOptions & tfBeepError) != 0)
					beep();
				};
			retKeyCode = 1;
			strncpy( buffer, value.formatDate(-1), 40 );
			strnset( data, ' ', maxLen );
			strncpy( data, buffer, maxLen );
			data[maxLen + 1] = EOS;
			drawView();
			};

	if ( keyCode == kbPgUp )
		if (	(selStart == 0) &&
				(selEnd == strlen(data)) )
			{
			if (dataChanged)
				convertData();
			value.decrMonth();
			if ( 	((tfOptions & tfValidateMin) != 0 ) &&
					( value < minValue ) )
				{
				value.incrMonth();
				if ((tfOptions & tfBeepError) != 0)
					beep();
				};
			retKeyCode = 1;
			strncpy( buffer, value.formatDate(-1), 40 );
			strnset( data, ' ', maxLen );
			strncpy( data, buffer, maxLen );
			data[maxLen + 1] = EOS;
			drawView();
			};

	return retKeyCode;
	}


void TDateField::setData( void *rec )
{
	long tempvalue;
	memcpy( &tempvalue, rec, sizeof(tempvalue) );
	setJulian(tempvalue);
	selectAll( True );
}

void TDateField::setJulian( long julDate )
{
	value = julDate;
	strncpy( data, value.formatDate(-1), maxLen);
	data[maxLen + 1] = EOS;
}

void TDateField::setMax( TDate newMax )
{
	maxValue = newMax;
	setTFOptions( tfValidateMax, True );

	if (minValue > maxValue)
		minValue = maxValue;
}

void TDateField::setMin( TDate newMin )
{
	minValue = newMin;
	setTFOptions( tfValidateMin, True );

	if (maxValue < minValue)
		maxValue = minValue;
}

void TDateField::setParadox( long pxDate )
{
	setJulian( pxDate + 1721424L );
}
