#ifndef __TRANSFER_ARRAYS
#define __TRANSFER_ARRAYS

#include <owl\owlpch.h>
#pragma hdrstop

#include <cstring.h>
#include <classlib\arrays.h>
#include <classlib\assoc.h>
#include <owl\listbox.h>
#include <owl\combobox.h>

class TfElement
{
	UINT			resID;
	string			sText;
	WORD			wState;
	void			*pvTransfer;

	void	GetFromControl (TControl *ctrl);
	void	StoreToControl (TControl *ctrl);

public:
	TfElement (UINT id);

	// custom transfer buffer definition
	void	SetTransferBuffer (void *transferBuffer) { pvTransfer = transferBuffer; }

	// functions for setting values of controls
	LPCSTR	GetText ()					{ return sText.c_str (); }
	void	SetText (LPCSTR lpszText)	{ sText = (lpszText ? lpszText : ""); }

	// functions for getting values of controls
	WORD	GetCheck ()					{ return wState; }
	void	SetCheck (WORD w)			{ wState = w; }

	BOOL	operator== (const TfElement& elem) { return (resID == elem.resID); }

	// functions used to transfer to or from the control
	static void TransferFromDlg (TWindow* win, void* param);
	static void TransferToDlg (TWindow* win, void* param);
};

typedef TIArrayAsVector<TfElement>			TfElementArray;

class TTransferArray
{
	TfElementArray		arrayElems;

	TfElement			*GetElement (UINT resID);

public:
	TTransferArray ();
	virtual ~TTransferArray ();

	void		TransferData (TWindow *win, TTransferDirection direction);

	TfElement&	operator[] (UINT resID)			{ return *GetElement (resID); }

	UINT		GetRadioChecked (UINT resIDfrom, UINT resIDto);
};

#define DECLARE_USETRANSFERARRAY(cls)							\
  private:														\
	TTransferArray		*ptfArray;                              \
  public:														\
	void TransferData (TTransferDirection direction);			\
	void SetTransferArray (TTransferArray *ptfStrm) { ptfArray = ptfStrm; }
	
#define DEFINE_USETRANSFERARRAY(cls)							\
	void cls::TransferData (TTransferDirection direction)		\
	{                                                           \
		if (ptfArray)                                           \
		{                                                       \
			ptfArray->TransferData (this, direction);           \
		}                                                       \
	}

class TTransferDialog : public TDialog
{

public:
	TTransferDialog (TWindow *wnd, TResId resID, TModule *module = NULL);

	DECLARE_USETRANSFERARRAY(TTransferDialog);
};

#endif