//
// Code for Implementing ostreams with OWL II
// by Neal Katz, cserve 70715,236
//


#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\editfile.h>

#include "testrm.h"

TmyStrStreamBuf::TmyStrStreamBuf() : strstreambuf()
{
	doc = 0;
}
TmyStrStreamBuf::TmyStrStreamBuf(TEditThing *d) : strstreambuf()
{
	doc = d;
}

void TmyStrStreamBuf::xinit(TEditThing *d)
{
	doc = d;
}

int TmyStrStreamBuf::sync()
{
	outBuf( EOF );
    return( 0 );
}

int TmyStrStreamBuf::overflow(int ch)
{
int r;
    r = outBuf( ch );
	return( r==EOF ? 0 : ch );	// zapeof(ch); can't return EOF,
}

int TmyStrStreamBuf::outBuf(int ch)
{
long cnt;
char *wbuf;	// the buffer we pass to windows text output function

	if (allocate()==EOF)
		return EOF;

	if ( (gptr()) && (gptr() < egptr()) )	// verify no characters in get area
		return EOF;
		
	setg(0,0,0);	// reset get area
	
	if ( !pptr() )
		setp( base(), base() );	// put area
		
	cnt = pptr() - pbase();	// characters inserted but not yet outputed (consumed)
	if (ch != EOF) {		// ch gets counted too, if not EOF
		*pptr() = ch;
		++cnt;
	}

// output characters, characters have to be cooked \n -> \r\n
		long size = cnt*2 + 1;			// worst case, all \n's
		char *b = new char[(int)size];	// new buf, size for cooking and EOF
		wbuf = b;
		char *bas = base();
		for(int x=0;x!=cnt;++x) {	// copy and cook loop
			if (bas[x]=='\n')
				*b++ = '\r';
			*b++ = bas[x];
		}
		*b = 0;                     // null terminate string
		if (doc)
			doc->Insert( wbuf );    // let the window display it
		delete[] wbuf;
//
	setp( base(), ebuf()-1 );
    return( 1 );	// bogus, just not EOS
}


//////////////////////////////////////////////////////////////////////////////////

Tmybase::Tmybase() : ios()
{
	ios::init( &myStrStreamBuf );
}


//////////////////////////////////////////////////////////////////////////////////

TEOstrStream::TEOstrStream() : Tmybase(), ostream()
{
	;
}

TEOstrStream::TEOstrStream(TEditThing *xdoc) : Tmybase(), ostream()
{
	AttachDoc(xdoc);
}

void TEOstrStream::AttachDoc(TEditThing *xdoc)
{
	myStrStreamBuf.xinit(xdoc);
}
