/*  Project t1
    
    Copyright  1993. All Rights Reserved.

    SUBSYSTEM:    t1.exe Application
    FILE:         t1app.cpp
	AUTHOR:       Neal Katz


    OVERVIEW
    ========
	Example program showing the use of a TEOstrStream
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "t1app.h"

//+
//+ Stuff added to support TEOstrStream in this program
//+

#include "testrm.h"
TEOstrStream	tout;		//+ this is our output stream, like cout

//+
//+ define class TOutWin derived from TEditFile
//+ the derived class has a constructor and destructor which handles
//+ attaching itself to the TEOstrStream. This avoids any problems
//+ with tout ever having a stale ptr to a deleted TeditFile object.
//+
class _OWLCLASS TOutWin : public TEditFile
{
public:
	TOutWin(TEOstrStream	&strm,
			TWindow*        parent = 0,
			int             id = 0,
			const char far* text = 0,
			int x = 0, int y = 0, int w = 0, int h = 0,
			const char far* fileName = 0,
			TModule*        module = 0) : tstrm(strm),TEditFile(parent,id,text,x,y,w,h,fileName,module)
		{ tstrm.AttachDoc(this); }
	~TOutWin()
		{ tstrm.DetachDoc(); }
private:
	TEOstrStream	&tstrm;
};

//+ End Stuff

//{{t1App Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(t1App, TApplication)
//{{t1AppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILENEW, CmFileNew),
    EV_COMMAND(CM_FILEOPEN, CmFileOpen),
	EV_COMMAND(CM_FILECLOSE, CmFileClose),
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{t1AppRSP_TBL_END}}
END_RESPONSE_TABLE;


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
class SDIDecFrame : public TDecoratedFrame {
public:
    SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
            TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
      {  }
    ~SDIDecFrame ()
      {  }
};


//////////////////////////////////////////////////////////
// t1App
// =====
//
t1App::t1App () : TApplication("t1")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.

}


t1App::~t1App ()
{
    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// t1App
// =====
// Application intialization.
//
void t1App::InitMainWindow ()
{
	Client = new TOutWin(tout,0, 0, 0);	//+ use our TOutWin Client is still TEditFile*
	SDIDecFrame *frame = new SDIDecFrame(0, GetName(), Client, FALSE);

    nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

	//
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = SDI_MENU;

  
    MainWindow = frame;

}


//////////////////////////////////////////////////////////
// t1App
// ===========
// Menu File New command
void t1App::CmFileNew ()
{
    Client->NewFile();
}


//////////////////////////////////////////////////////////
// t1App
// ===========
// Menu File Open command
void t1App::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
    //
    *FileData.FileName = 0;
    if (Client->CanClose())
        if (TFileOpenDialog(MainWindow, FileData).Execute() == IDOK)
            OpenFile();
}


void t1App::OpenFile (const char *fileName)
{
    if (fileName)
        lstrcpy(FileData.FileName, fileName);

    Client->ReplaceWith(FileData.FileName);
}


//////////////////////////////////////////////////////////
// t1App
// =====
// Menu File Close command
void t1App::CmFileClose ()
{
	 if (Client->CanClose())
	         Client->DeleteSubText(0, UINT(-1));
}


//////////////////////////////////////////////////////////
// t1App
// ===========
// Menu Help About t1.exe command
void t1App::CmHelpAbout ()
{
//+ and output some text
	tout << "Hello Alpha Centuri\n";
	tout.flush();
}


int OwlMain (int , char* [])
{
    t1App     App;
    int             result;

    result = App.Run();

    return result;
}
