// Copyright (c) 1992
// Dennis M. Carleton
// May be distributed freely but not used for profit
//
// Description: definitions for the SET template
//

//-------------------------------------------------------------------------
//	USAGE EXAMPLE
//	{
//	 set<int>	a, b, c, d;
//
//	 a[3](1, 2, 3);				// init the set
//	 b[3](4, 5, 6);				// init the set
//	 c[3](7, 8, 9);
//
//	 x < 4;					// add to the set
//	 x < c;
//
//	 d = I(a, b)				// intersection = { 4 }
//	 d.dumpSet();
//
//	 d = U(b,c);				// union { 4, 5, 6, 7, 8, 9 }
//	 d.dumpSet();
//      };
//
//-------------------------------------------------------------------------


#ifndef _SET_H_
#define _SET_H_

//
// includes
//

#include <stdarg.h>
#include <iostream.h>
//
#include "boolean.h"
#include "list.h"


//
// class template SET
//

template <class T> class set : public typedList<T>
{
protected:
    int	initNum;
public:
	set();					// constructor
	set(set<T>& x);				// copy constructor
//
set<T>&	operator[](int x);			// how many in the init
set<T>&	operator()(...);			// define the set
set<T>&	operator=(set<T>&);			// assignment operator
//
void	operator<(T x);				// add element to set
void	operator<(set<T>& x);			// add set to set
//
friend  set<T> U(set<T>& x, set<T>& y);		// union
friend  set<T> I(set<T>& x, set<T>& y);		// intersection
//
boolean operator>(T x);				// is a member of
boolean operator>(set<T> x);			// is a subset of
//
//
void dumpSet();					// print the set
};


//
// methods
//

//
// Function:		set
// Abstract:		constructor
// Parameters:		none
// Return Value:	none
//

template <class T> set<T>::set()
			  : typedList<T>(), initNum(0)
{
};


//
// Function:		set
// Abstract:		copy constructor
// Parameters:		set<T>& - set being copied from
// Return Value:	none
//

template <class T> set<T>::set(set<T>& x)
		          : typedList<T>(), initNum(0)
{
 *this = x;
};



//
// Function:		[]
// Abstract:		set index initializer
// Parameters:		int x - the number of elements in the set initializer
// Return Value:	set<T>& - a reference to this set
//

template <class T> set<T>& set<T>::operator[](int x)
{
 initNum = x;
 return *this;
};



//
// Function:		()
// Abstract:		set definer
// Parameters:		members of the set, all of type <T>
// Return Value:	set<T>& - a reference to this set
//

template <class T> set<T>& set<T>::operator()(...)
{
va_list ap;
T	arg;
T	*argPtr;

 va_start(ap, 0);
 for (int i=0; i<initNum; i++)
     {
      arg = va_arg(ap, T);
      argPtr = new T;
      *argPtr = arg;
      append(argPtr);
     };
 va_end(ap);
 //
 initNum = 0;
 return *this;
};


//
// Function:		=
// Abstract:		assignment operator
// Parameters:		set<T>& x - the set to copy from
// Return Value:	none
//

template <class T> set<T>& set<T>::operator=(set<T>& x)
{
 clear();
 *this < x;
 return *this;
};



//
// Function:		<
// Abstract:		"add element to set"  operator
// Parameters:		T x - the element to add to the set
// Return Value:	none
//

template <class T> void set<T>::operator<(T x)
{
T	*elementPtr;
boolean	inSetFlag = FALSE;

 reset();
 while ((elementPtr = ++(*this)) != NULL)
    if (*elementPtr == x)
	inSetFlag = TRUE;

 if (!inSetFlag)
     {
      T	*argPtr;
      argPtr = new T;
      *argPtr = x;
      append(argPtr);
     };
};


//
// Function:		<
// Abstract:		"add set to set" operator
// Parameters:		set<T>& x - the set to add to this set
// Return Value:	none
//

template <class T> void set<T>::operator<(set<T>& x)
{
T	*memberPtr;

 while ((memberPtr = ++x) != NULL)
     (*this) < *memberPtr;
};


//
// Function:		U
// Abstract:		makes the union of two sets
// Parameters:		set<T>& x - the first set
//			set<T>& y - the second set
// Return Value:	set<T> - the set that is the union of the two sets
//

template <class T> set<T> U(set<T>& x, set<T>& y)
{
set<T> z;

 z < x;
 z < y;
 return z;
};


//
// Function:		I
// Abstract:		makes the intersection of two sets
// Parameters:		set<T>& x - the first set
//			set<T>& y - the second set
// Return Value:	set<T> - the set that is the intersection of the 
//			two sets
//

template <class T> set<T> I(set<T>& x, set<T>& y)
{
set<T> 	z;
T	*xMemberPtr,
	*yMemberPtr;

 x.reset();
 while ((xMemberPtr = ++x) != NULL)
    {
     y.reset();
     while ((yMemberPtr = ++y) != NULL)
	if (*xMemberPtr == *yMemberPtr)
	    z < *xMemberPtr;
    };
 return z;
};


//		
// Function:		>
// Abstract:		"is a member of" operator
// Parameters:		T x - a data element of type 'T'
// Return Value:	TRUE is x is a member, FALSE otherwise
//

template <class T> boolean set<T>::operator>(T x)
{
T 	*memberPtr;
boolean	memberFlag = FALSE;

 reset();
 while((memberPtr = ++(*this)) != NULL)  
     if (*memberPtr == x)
         {
          memberFlag = TRUE;
          break;
        };
 return memberFlag;
};


//
// Function:		>
// Abstract:		"is a subset of" operator
// Parameters:		set<T> x - a set of elements of type 'T'
// Return Value:	TRUE is all elements in x are also in this set.
//			FALSE otherwise
//

template <class T> boolean set<T>::operator>(set<T> x)
{
T	*xMemberPtr,
	*memberPtr;
boolean	memberFlag,    
	subsetFlag = TRUE;

 x.reset();
 while ((xMemberPtr = ++x) != NULL)
    {
     reset();
     memberFlag = FALSE;
     while ((memberPtr = ++(*this)) != NULL)
	if (*xMemberPtr == *memberPtr)
	    {
	     memberFlag = TRUE;
	     break;
	    };
     if (!memberFlag)
        {
         subsetFlag = FALSE;
         break;
        };
    };
 return subsetFlag;
};


template <class T> void set<T>::dumpSet()
{
 reset();
 cout << "{ ";
 while(++(*this))
    {
     cout << *getCurrent() << " ";
    };
 cout << "}" << endl;
};

#endif

// end set.h
