/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 9-1

	#define TRUE 1
	#define FALSE 0





listing 9-2

printf("%d %d %d",FALSE, TRUE, TRUE+1);





listing 9-3

#define ONE 	1
#define TWO 	ONE+ONE
#define THREE 	ONE+TWO





listing 9-4

#define E_MS "standard error on input\n"

.
.
.

printf(E_MS);





listing 9-5

printf("standard error on input\n");





listing 9-6

#define XYZ this is a test
.
.
.
printf("XYZ");





listing 9-7

#define LONG_STRING "this is a very long \
string that is used as an example"





listing 9-8

#define MAX_SIZE 100

float balance[MAX_SIZE];





listing 9-9

#define MIN(a,b)  (a<b) ? a : b

main()
{
  int x, y;

  x = 10;
  y = 20;
  printf("the minimum is: %d", MIN(x, y));
}





listing 9-10

printf("the minimum is: %d",(x<y) ? x : y);





listing 9-11

/* This program will give the wrong answer. */

#define EVEN(a) a%2==0 ? 1 : 0

main()
{
  if(EVEN(9+1)) printf("is even");
  else printf("is odd");
}





listing 9-12

9+1%2==0 ? 1 : 0





listing 9-13

#define EVEN(a) (a)%2==0 ? 1 : 0

main()
{
  if(EVEN(9+1)) printf("is even");
  else printf("is odd");
}





listing 9-14

	#include "stdio.h"
        #include <stdio.h>





listing 9-15

The program file:

	main()
	{
	#include "one"
	}



Include file "one":

	printf("This is from the first include file.\n");
	#include "two"



Include file "two":

	printf("This is from the second include file.\n");





listing 9-16

/* simple #if example */

#define MAX 100
main()
{
#if MAX>99
  printf("compiled for array greater than 99\n");
#endif
}





listing 9-17

/* simple #if/#else example */

#define MAX 10
main()
{
#if MAX>99
  printf("compiled for array greater than 99\n");
#else
  printf("compiled for small array\n");
#endif
}





listing 9-18

#define US 0
#define ENGLAND 1
#define FRANCE 2

#define ACTIVE_COUNTRY US

#if ACTIVE_COUNTRY==US
  char currency[] = "dollar";
#elif ACTIVE_COUNTRY==ENGLAND
  char currency[] = "pound";
#else
  char currency[] = "franc";
#endif





listing 9-19

#if MAX>100
   #if SERIAL_VERSION
      int port = 198;
   #elif
      int port = 200;
   #endif
#else
   char out_buffer[100];
#endif





listing 9-20

#if (sizeof(char *) == 2)
  printf("Program compiled for small model.");
#else
  printf("Program compiled for large model.");
#endif





listing 9-21

	#define TED 10

	main()
	{
	#ifdef TED
	  printf("Hi Ted\n");
	#else
	  printf("Hi anyone\n");
	#endif
   	#ifndef RALPH
	  printf("RALPH not defined\n");
	#endif
	}





listing 9-22

#define LEN 100
#define WIDTH 100

char array[LEN][WIDTH];

#undef LEN
#undef WIDTH
/* at this point both LEN and WIDTH are undefined */





listing 9-23

#line 100   /* reset the line counter */
main()      /* line 100 */
{	    /* line 101 */
  printf("%d\n", __LINE__);  /* line 102 */
}





listing 9-24

main()
{
  printf("%s %s %s %s\n", __FILE__, __LINE__, __DATE__,
          __TIME__);

  printf("Program being compiled using the ");
#ifdef __TINY__
  printf("tiny model");
#endif
#ifdef __SMALL__
  printf("small model");
#endif
#ifdef __COMPACT__
  printf("compact model");
#endif
#ifdef __MEDIUM__
  printf("medium model");
#endif
#ifdef __LARGE__
  printf("large model");
#endif
#ifdef __HUGE__
  printf("huge model");
#endif
  printf("\n");

  printf("Using version %X of Turbo C.", __TURBOC__);
}





