/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 4-1

void pr_reverse(s)
char *s;
{
  register int t;

  for(t=strlen(s)-1; t>-1; t--) printf("%c", s[t]);
}





listing 4-2

find_substr(s1, s2)
char *s1, *s2;
{
  register int t;
  char *p, *p2;

  for(t=0; s1[t]; t++) {
    p = &s1[t];
    p2 = s2;
    while(*p2 && *p2==*p) {
      p++; 
      p2++;
    }
    if(!*p2) return t;
  }
  return -1;





listing 4-3

	x=power(y);

	if(max(x,y) > 100) printf("greater");

	for(ch=getchar(); isdigit(ch); ) ... ;





listing 4-4

	swap(x, y) = 100;	/* incorrect statement */





listing 4-5

main()
{
  int x, y, z;

  x = 10;   y = 20;
  z = mul(x, y);	    /* 1 */
  printf("%d", mul(x, y));  /* 2 */
  mul(x, y);		    /* 3 */
}

mul(a, b)
int a, b;
{
  return a*b;
}





listing 4-6

  /* return 1 if c is part of string s; 0 otherwise */
  is_in(s, c)
  char *s;
  char c;
  {
    while(*s)
      if(*s==c) return 1;
      else s++;

    return 0;
  }




listing 4-7

  main()
  {
    int t=10;

    printf("%d %d", sqr(t), t);
  }

  sqr(x)
  int x;
  {
    x = x*x;
    return(x);
  }





listing 4-8

  void swap(x, y)
  int *x, *y;
  {
    int temp;

    temp = *x;  /* save the value at address x */
    *x = *y;    /* put y into x */
    *y = temp;  /* put x into y */
  }





listing 4-9
  void swap();

  main()
  {
    int x, y;

    x = 10;
    y = 20;
    swap(&x, &y);
  }





listing 4-10

void display();
main()  /* print some numbers */
{
  int t[10], i;

  for(i=0; i<10; ++i) t[i]=i;
  display(t);
}

void display(num)
int num[10];
{
  int i;

  for(i=0; i<10; i++) printf("%d ", num[i]);
}





listing 4-11

void display(num)
int num[];
{
  int i;

  for(i=0; i<10; i++) printf("%d ", num[i]);
}





listing 4-12

void display(num)
int *num;
{
  int i;

  for(i=0; i<10; i++) printf("%d ", num[i]);
}





listing 4-13

void display();

main() /* print some numbers */
{
  int t[10], i;

  for(i=0; i<10; ++i) t[i]=i;
  for(i=0; i<10; i++) display(t[i]);
}

void display(num)
int num;
{
  printf("%d ", num);
}





listing 4-14

  void print_upper();

  main()  /* print string as uppercase */
  {
    char s[80];

    gets(s);
    print_upper(s);
  }

  void print_upper(string)
  char *string;
  {
    register int t;

    for(t=0; string[t]; ++t)  {
      string[t] = toupper(string[t]);
      printf("%c", string[t]);
    }
  }






listing 4-15
  void print_upper();

  main()  /* print string as uppercase */
  {
    char s[80];

    gets(s);
    print_upper(s);
  }

  void print_upper(string)
  char *string;
  {
    register int t;

    for(t=0; string[t]; ++t)  
      printf("%c", toupper(string[t]));
  }





listing 4-16
 /* A very simple version of the standard
    gets() library function. */

  void xgets(s) 
  char *s;
  {
    char ch;
    int t;

    for(t=0; t<80; ++t) {
      ch = getche();
      switch(ch) {
          case '\r':
            s[t] = '\0'; /* null terminate the string */
            return;
          case '\b':
            if(t>0) t--;
            break;
          default:
            s[t] = ch;
      }
    }
    s[80] = '\0';
  }





listing 4-17

  main(argc,argv)  /* name program */
  int argc;
  char *argv[];
  {
    if(argc!=2) {
      printf("You forgot to type your name\n");
      exit(0);
    }
    printf("Hello %s", argv[1]);
  }





listing 4-18

    A>name Tom

    Hello Tom

    A>





listing 4-19

  run Spot, run  





listing 4-20

  Herb,Rick,Fred  





listing 4-21

  char *argv[];





listing 4-22

main(argc, argv)  /* countdown */
int argc;
char *argv[];
{
  int disp, count;

  if(argc<2) {
    printf("You must enter the length of the count\n");
    printf("on the command line.  Try again.\n");
    exit(0);
  }

  if(argc==3 && !strcmp(argv[2],"display")) disp = 1;
  else disp = 0;

  for(count=atoi(argv[1]); count; --count)
    if(disp) printf("%d ", count);

  printf("%c", 7);  /* this will ring the bell on most 
                  computers */
}





listing 4-23

  main(argc,argv)
  int argc;
  char *argv[];
  {
    int t, i;

    for(t=0; t<argc; ++t) {
      i = 0;
      while(argv[t][i]) {
        printf("%c", argv[t][i]);
        ++i;
      }
    }
  }





listing 4-24

  float sum();  /* identify the function */

  main()
  {
    float first, second;

    first = 123.23;
    second = 99.09;
    printf("%f", sum(first,second));
  }

  float sum(a, b)
  float a, b;
  {
    return a+b;
  }





listing 4-25

  char *match(c, s);
  char c, *s;
  {
    int count;

    count=0;
    while(c!=s[count] && s[count]!='\0') count++;
    return(&s[count]);
  }





listing 4-26


  char *match();  /* declare match's type */

  main()
  {
    char s[80], *p, ch;

    gets(s);
    ch = getche();
    p = match(ch,s);
    if(p)  /* there is a match */
      printf("%s ", p);
    else 
      printf("no match found");
  }





listing 4-27
/* This program uses function prototypes to
   enforce strong type checking in the calls
   to func().

   The program will not compile because of the
   mismatch between the type of the arguments
   specified in the function's prototype and
   the type of arguments used to call the function.

*/

float func(int, float); /* prototype */

main()
{
  int x, *y;

  x = 10;  y = 10;
  func(x, y);  /* type mismatch */
}

float func(x,  y)
int x;
float y;
{
  printf("%f", y/(float)x);
}





listing 4-28

float func(int x, float y)
{
  printf("%f", y/(float)x);
}





listing 4-29

  /* Compute the factorial of a number. */
  factr(n)  /* recursive */
  int n;
  {
    int answer;

    if(n==1) return(1);
    answer = factr(n-1)*n;
    return(answer);
  }


  /* Compute the factorial of a number. */
  fact(n)    /* non-recursive */
  int n;
  {
    int t, answer;

    answer=1;
    for(t=1; t<=n; t++) 
      answer=answer*(t);
    return(answer);

  }





listing 4-30

main()
{
  int strcmp(); /* declare a function */
  char s1[80], s2[80];
  char *p;

  p=(char *)strcmp;

  gets(s1);
  gets(s2);

  check(s1, s2, p);
}

check(a, b, cmp)
char *a, *b;
int (*cmp) ();
{
  printf("testing for equality\n");
  if(!(*cmp) (a, b)) printf("equal");
  else printf("not equal");
}





listing 4-31

	(*cmp) (a, b)





listing 4-32

	check(s1, s2, strcmp);





listing 4-33
#include "ctype.h"

main()
{
  int strcmp();
  int numcmp();
  char s1[80], s2[80];

  gets(s1);
  gets(s2);

  if(isalpha(*s1))
  	check(s1, s2, strcmp);
  else
  	check(s1, s2, numcmp);

}

check(a, b, cmp)
char *a, *b;
int (*cmp) ();
{
  printf("testing for equality\n");
  if(!(*cmp) (a, b)) printf("equal");
  else printf("not equal");
}

numcmp(a, b)
char *a, *b;
{
  if(atoi(a)==atoi(b)) return 0;
  else return 1;
}






listing 4-34

  in line                     function call

  main()                      main()
  {          	              {
    int x;                      int x;

    for(x=1; x<11; ++x)         for(x=1; x<11; ++x)
    printf("%d", x*x);          printf("%d", sqr(x));
  }                           }

  sqr(a)
  int a;
  {
    return a*a;
  }




