/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 3-1

  main()  /* magic number program */
  {
    int magic = 123;  /* magic number */
    int guess;

    scanf("%d",&guess);
   
    if(guess == magic) printf("** Right **");
  }







listing 3-2

  main()  /* magic number program - improvement 1 */

  {
    int magic = 123;  /* magic number */
    int guess;

    scanf("%d",&guess);

    if(guess == magic) printf("** Right **");
    else printf(".. Wrong ..");

  }





listing 3-3

  if(x) 
    if(y) printf("1");
    else printf("2");





listing 3-4

  if(x) {
    if(y) printf("1");
  }
  else printf("2");





listing 3-5

  
  main()  /* magic number program improvement 2 */
  {

    int magic = 123;  /* magic number */
    int guess;

    scanf("5d", &guess);

    if(guess == magic) {
      printf("** Right ** ");
      printf("%d is the magic number", magic);
    }
    else {
      printf(".. Wrong .. ");
      if(guess > magic) printf("Too high");
      else printf("Too low");
    }
  }





listing 3-6
  
  main()  /* magic number program version 3 */
  {
    int magic = 123;  /* magic number */
    int guess;

    scanf("%d", &guess);

    if(guess == magic) {
      printf("** Right ** ");
      printf("%d is the magic number", magic);
    }
    else if(guess > magic) 
      printf(".. Wrong .. Too High");
    else printf(".. Wrong .. Too low");

  }





listing 2-20

  x = 10;

  y = x>9 ? 100 : 200;





listing 2-21

  x = 10;

  if(x>9) y = 100;
  else y = 200;





listing 3-7

main()
{
  int t;

  printf(": ");
  scanf("%d", &t);

  /* print proper message */
  t ? f1(t)+f2() : printf("zero entered");

}

f1(n)
int n;
{
  printf("%d ",n);
}

f2()
{
  printf("entered");
}





listing 3-8
  
  main()  /* magic number program */
  {
    int magic = 123;  /* magic number */
    int guess;

    scanf("%d", &guess);
    if (guess == magic) {
        printf("** Right ** ");
        printf("%d is the magic number",magic);
    }
    else   
        guess > magic ? printf("High") : printf("Low");
  }





listing 3-9

  menu()
  {
    char ch;

    printf("1. Check Spelling\n");
    printf("2. Correct Spelling errors\n");
    printf("3. Display Spelling Errors\n");
    printf("Strike Any Other Key to Skip\n");
    printf("      Enter your choice: ");

    ch = getche();  /* read the selection from
                      the keyboard */

    switch(ch) {
      case '1':
        check_spelling();
        break;
      case '2':
        correct_errors();
        break;
      case '3':
        display_errors();
        break;
      default :
        printf("No option selected");
    }
  }





listing 3-10

  inp_handler() 
  {
    int ch, flag;

    ch = read_device(); /* read some sort of device */
    flag = -1;

    switch(ch) {
      case 1:  /* these cases have common statement */
      case 2:  /* sequences */
      case 3:
        flag = 0;
        break;
      case 4:
        flag = 1;
      case 5:
        error(flag);
        break;
      default: 
        process(ch);
    }
  }





listing 3-11

    flag = 0;
    break;





listing 3-12

/* this is incorrect */
switch(c) {
  case 1:
    auto int t;
    .
    .
    .





listing 3-13

/* this is correct */
switch(c) {
  auto int t;
  case 1:
    .
    .
    .





listing 3-14

/* this is correct */
switch(c) {
  case 1:
    if(1) { /* always true, used to create block */
      auto int t;
      .
      .
      .
    }
    .
    .
    .





listing 3-15

switch(x) {
  case 1:
    switch(y) {
      case 0: printf("divide by zero error");
              break;
      case 1: process(x,y);
    }
    break;
  case 2:
   .
   .
   .





listing 3-16

main()
{
  int x;

  for(x=1; x<=100; x++) printf("%d ", x);
}





listing 3-17

  for(x=100; x!=65; x-=5) {
    z = sqrt(x); 
    printf("The square root of %d, %f", x, z);
  }





listing 3-18

  x = 10;

  for(y=10; y!=x; ++y) printf("%d", y);

  printf("%d", y);





listing 3-19

  for(x=0, y=0;x+y<10;++x) {
    y = getchar();  
    y = y-'0';      /* subtract the ASCII code for 0
                     from y */
    .
    .
    .
  }





listing 3-20

/* copy s into r backwards */
void reverse(s, r)
char *s, *r;
{
  int i, j;

  for(i=strlen(s)-1,j=0; i>=0; j++,i--) r[i] = s[j];
  r[j] = '\0'; /* append null terminator */
}





listing 3-21

  sign_on()
  {
    char str[20];
    int x;
  
    for(x=0; x<3 && strcmp(str,"password"); ++x) {
      printf("enter password please:");  
      gets(str);
    }
    if(x==3) hang_up();
  }





listing 3-22

main()
{
  int t;

  for(prompt(); t=readnum(); prompt()) 
    sqrnum(t);
}

prompt()
{
  printf(": ");
}

readnum()
{
  int t;
 
  scanf("%d", &t);
  return t;
}

sqrnum(num)
int num;
{
  printf("%d\n", num*num);
}





listing 3-23
  for(x=0; x!=123; ) scanf("%d", &x);






listing 3-24

  gets(s);  /* read a string into s */
  if(*s) x = strlen(s); /* get the string's length */
  
  for( ;x<10; ) {
    printf("%d", x);
    ++x;
  }





listing 3-25

for(;;) printf(" this loop will run forever.\n");





listing 3-26

  ch = '\0';

  for(;;) {
    ch = getchar();  /* get a character */
    if(x=='A') break;  /* exit the loop */
  }

  printf("you typed an A");





listing 3-27

for( ; *str==' '; str++) ;





listing 3-28

for(t=0; t<SOME_VALUE; t++) ;





listing 3-29

  wait_for_char()
  {
    char ch;
  
    ch = '\0';  /* initialize ch */
    while(ch!='A')  ch = getchar();
  }





listing 3-30
  /* add spaces to the end of a string */
  void pad(s, length)
  char *s;
  int length;
  {
    int l;

    l = strlen(s);  /* find out how long it is */

    while(l<length) {
      s[l] = ' ';   /* insert a space */
      l++;
    }

    s[l] = '\0';  /* strings need to be
                   terminated in a null */

  }





listing 3-31

  void func1()
  {
    int working;

    working = 1;   /* i.e., true */

    while(working) {
      working=process1();
      if(working)
        working=process2();
      if(working) 
        working=process3();
    }
  }





listing 3-32

  while((ch=getchar()) != 'A') ;





listing 3-33

  do {
    scanf("%d", &num);
  } while(num>100);





listing 3-34

  menu()
  {

    char ch;

    printf("1. Check Spelling\n");
    printf("2. Correct Spelling Errors\n");
    printf("3. Display Spelling Errors\n");
    printf("      Enter your choice: ");

    do {
        ch=getche();  /* read the selection from
                          the keyboard */
        switch(ch) {
          case '1':
            check_spelling();
            break;
          case '2':
            correct_errors();
            break;
          case '3':
            display_errors();
            break;         
	}
    } while(ch!='1' && ch!='2' && ch!='3');
  }





listing 3-35

  main()
  {
    int t;

    for(t=0; t<100; t++) {
      printf("%d ", t);
      if(t==10) break;
    }
  }





listing 3-36

  look_up(name)
  char *name;
  {
    char tname[40];
    int loc;

    loc=-1;
    do {
      loc = read_next_name(tname);
      if(kbhit()) break;
    } while(!strcmp(tname, name));
    return loc;
  }





listing 3-37

  for(t=0; t<100; +=t) {
    count = 1;
    for(;;) {
      printf("%d ", count);
      count++;
      if(count==10) break;
    }
  }





listing 3-38

  main()  
  {
    if(!color_card()) exit(1);
    play();
  }





listing 3-39

  menu()
  {

    char ch;

    printf("1. Check Spelling\n");
    printf("2. Correct Spelling Errors\n");
    printf("3. Display Spelling Errors\n");
    printf("4. Quit\n");
    printf("      Enter your choice: ");

    do {
        ch = getchar();  /* read the selection from
                          the keyboard */
        switch(ch) {
          case '1':
            check_spelling();
            break;
          case '2':
            correct_errors();
            break;
          case '3':
            display_errors();
            break;         
          case '4':
	    exit(0);  /* return to OS */
	}
    } while(ch!='1' && ch!='2' && ch!='3');
  }





listing 3-40

  do {
    scanf("%d", &num);
    if(x<0) continue;
    printf("%d ", x);
  } while(x!=100);





listing 3-41

  for(t=0; t<100; ++t) {
    scanf("%d", &num);
    if(x<0) continue;
    printf("%d ", x);
  }





listing 3-42

  void code()
  {  
    char done, ch;

    done = 0;
    while(!done) {
      ch = getchar();
      if(ch=='$') {
        done=1;
        continue;
      }
      putchar(ch+1);  /* shift the alphabet one
                         position */
    }
  }





listing 3-43

  x = 1;

  loop1:
    x++;
    if(x<100) goto loop1;





listing 3-44

  for(...) {
    for(...) {
      while(...) {
        if(...) goto stop;
        .
        .
        .
      }
    }
  }

  stop:
    printf("error in program\n");





listing 3-45

  done=0;
  for(...) {
    for(...) {
      while(...) {
        if(...) {
          done=1;
          break;
        }
        .
        .
        .
      }
      if(done) break;
    }
    if(done) break;
  }




