/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 22-1

#include "process.h"

main()
{
  for(;;) 
    if(getch()=='A') abort();
}





listing 22-2

#include "stdlib.h"

/* example using atexit() */
main()
{
  void done();

  if(atexit(done)) printf("error in atexit()");
}

void done()
{
  printf("hello there");
}





listing 22-3
/* first file  - parent */

#include "stdio.h"
#include "process.h"

main()
{
  execl("test.exe", "test.exe", "hello", "10", NULL);
}


/* second file - child */
main(int argc, char *argv[])
{
  printf("this program is executed with these command line ");
  printf("arguments: ");
  printf(argv[1]);
  printf(" %d", atoi(argv[2]));
}





listing 22-4


menu()
{
  char choice;

  do {
    printf("Enter names (E)\n");
    printf("Delete name (D)\n");
    printf("Print (P)\n");
    printf("Quit (Q)\n");
  } while(!strchr("EDPQ",toupper(ch));
  if(ch=='Q') exit(0);
  return ch;
}





listing 22-5
/* parent process */

#include "stdio.h"
#include "process.h"

main()
{
  printf("In parent\n");
  spawnl(P_WAIT, "test.exe", "test.exe", "hello", "10", NULL);
  printf("\nBack in parent");
}


/* first child */
#include "stdio.h"
#include "process.h"

main(int argc, char *argv[])
{
  printf("First child process executing with these command line ");
  printf("arguments: ");
  printf(argv[1]);
  printf(" %d\n", atoi(argv[2]));
  spawnl(P_WAIT, "test2.exe", NULL);
  printf("\nBack in first child process.");
}


/* second child */
main()
{
  printf("In second child process.");
}




