/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 20-1

unsigned i;

i = 0;

if((i=allocmem(100, &i)==-1) printf("allocate successful");
else 
  printf("allocation failed, only %u paragraphs available", i);





listing 20-2

#include "stdlib.h"  


float *get_mem()
{
  float *p;

  p = (float *) calloc(100, sizeof(float));
  if(!p) {
    printf("allocation failure - aborting");
    exit(1);
  }
  return p;
}






listing 20-3

#include "alloc.h"

main()
{

  printf("The size of the heap is %u", coreleft());
}





listing 20-4

#include "alloc.h"

main()
{ 

  printf("far heap free memory: %ld", farcoreleft());
}





listing 20-5

#include "alloc.h"

main()
{
  char far *p;

  p = farmalloc(100);

  /* only free it if there was no allocation error */
  if(p) farfree(p);
}





listing 20-6

#include "stdlib.h"

main()
{
  char *str[100];
  int i;

  for(i=0; i<100; i++) {
    if((str[i]=(char *)malloc(128))==NULL) {
      printf("allocation error - aborting");
      exit(0);
    }
    gets(str[i]);
  }

  /* now free the memory */
  for(i=0; i<100; i++) free(str[i]);
}





listing 20-7

unsigned i;

if(allocmem(some, &i)!=-1)
  printf("allocation error");
else
  freemem(i);





listing 20-8
#include "stdlib.h"

struct addr {
  char name[40];
  char street[40];
  char city[40];
  char state[3];
  char zip[10];
};
.
.
.
struct addr *get_struct()
{
  struct addr *p;

  if(!(p=(struct addr *)malloc(sizeof(addr)))) {
    printf("allocation error - aborting");
    exit(0);
  }
  return p;
}





listing 20-9

#include "stdlib.h"

main()
{
  char *p;

  p = (char *) malloc(17);
  if(!p) {
    printf("allocation error - aborting");
    exit(1);
  }

  strcpy(p, "this is 16 chars");

  p = (char *) realloc(p,18);
  if(!p) {
    printf("allocation error - aborting");
    exit(1);
  }

  strcat(p, ".");

  printf(p);

  free(p);
}






listing 20-10

if(setblock(seg, 100)!=-1) printf("resize error");




