/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 23-1


#include "graphics.h"

main()
{
  int driver, mode;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  setcolor(WHITE);
  arc(100, 100, 0, 90, 20);

  getch(); /* wait until keypress */
  restorecrtmode();
}






listing 23-2

#include "graphics.h"

main()
{
  int driver, mode;
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  /* display a green 2-d bar */
  setfillstyle(SOLID_FILL, GREEN);
  bar(100, 100, 120, 200);

  /* now show a red 3-d bar */
  setfillstyle(SOLID_FILL, RED);
  bar3d(200, 100, 220, 200, 10, 1);

  getch();
  restorecrtmode();
}





listing 23-3

#include "graphics.h"

main()
{
  int driver, mode;
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  circle(200, 200, 20);
  circle(200, 200, 30);
  circle(200, 200, 40);
  circle(200, 200, 50);
  circle(200, 200, 60);

  getch();
  restorecrtmode();
}





listing 23-4


#include "graphics.h"

void box(int, int, int, int, int);

main()
{
  int driver, mode;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  /* frame the screen for perspective */
  box(0, 0, 639, 349, WHITE);

  setviewport(20, 20, 200, 200, 1);
  box(0, 0, 179, 179, RED);

  outtext("this is a test of the view port");

  outtextxy(20, 10, "press a key");
  getch();  
  /* clear the current viewport but not the entire screen */
  clearviewport();


  getch();
  restorecrtmode();
}

/* Draw a box given the coordinates of its two corners. */
void box(int startx, int starty, int endx, int endy,
         int color)
{
  setcolor(color);

  line(startx, starty, startx, endy);
  line(startx, starty, endx, starty);
  line(endx, starty, endx, endy);
  line(endx, endy, startx, endy);
}





listing 23-5

closegraph()
printf("this is not in graphics");





listing 23-6

#include "conio.h"

main()
{
  register int i;

  gotoxy(10, 10);
  printf("This is a test of the clreol() function.");
  getch();
  gotoxy(10, 10);
  clreol();

  for(i=0; i<20; i++) printf("Hello there\n");
  getch();

  /* clear the screen */
  clrscr();
}




listing 23-7


#include "conio.h"

void border(int, int, int, int);

main()
{
  clrscr();
 
  /* create first window */
  window(3, 2, 40, 9);
  border(3, 2, 40, 9);
  gotoxy(1,1);
  cputs("This line will be wrapped at the end of the window.");
  getche();
}

/* Draws a border around a text window. */
void border(startx, starty, endx, endy)
int startx, starty, endx, endy;
{
  register int i;

  gotoxy(1, 1);
  for(i=0; i<=endx-startx; i++)
    putch('-');

  gotoxy(1, endy-starty);
  for(i=0; i<=endx-startx; i++)
    putch('-');

  for(i=2; i<endy-starty; i++) {
    gotoxy(1, i);
    putch('|');
    gotoxy(endx-startx+1, i);
    putch('|');
  }
}





listing 23-8


#include "conio.h"

main()
{
  register int i;

  clrscr();

  for(i=0; i<24; i++) printf("line %d\n", i);
  getch();

  gotoxy(1, 3);
  delline();

  getch();
}





listing 23-9

  int driver, mode;

  detectgraph(&driver, &mode);
  if(driver==-2) {
    printf("no graphics adapter in the system.");
    exit(1);
  }





listing 23-10


#include "graphics.h"

main()
{
  int driver, mode;
  int shape[10] = { /* five points * 2 */
    10, 10,
    100, 80,
    200, 200,
    350, 90,
    0, 0
  };

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  drawpoly(5, shape);  

  getch();
  restorecrtmode();
}





listing 23-11


#include "graphics.h"

main()
{
  int driver, mode;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  ellipse(100, 100, 0, 360, 80, 40);

  getch();
  restorecrtmode();
}





listing 23-12


#include "graphics.h"

main()
{
  int driver, mode;
  int shape[] = {
    100, 100,
    100, 200,
    200, 200, 
    100, 100
  };

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  setfillstyle(INTERLEAVE_FILL, MAGENTA);
  fillpoly(4, shape);

  getch();
  restorecrtmode();
}





listing 23-13


#include "graphics.h"

main()
{
  int driver, mode;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  ellipse(100, 100, 0, 360, 80, 40);

  setfillstyle(XHATCH_FILL, MAGENTA);
  floodfill(100, 100, WHITE);

  getch();
  restorecrtmode();
}





listing 23-14


#include "graphics.h"

main()
{
  int driver, mode;
  struct arccoordstype ac;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  arc(100, 100, 0, 90, 100);

  /* now, draw a line between the endpoints of the arc */
  getarccoords(&ac);  /* get the coordinates */
  line(ac.xstart, ac.ystart, ac.xend, ac.yend);

  getch();
  restorecrtmode();
}





listing 23-15
  int xasp, yasp;

  getaspectratio(&xasp, &yasp);

  printf("X,Y aspect ratios %d %d", xasp, yasp);





listing 23-16

printf("background color is %d", getbkcolor());





listing 23-17

printf("drawing color is %d", getcolor());





listing 23-18


#include "graphics.h"

main()
{
  int driver, mode;
  struct arccoordstype ac;
  char f[8];
  int i;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  getfillpattern(f);

  /* display each byte in fill pattern */
  for(i=0; i<8; i++) printf("%d ", f[i]);

  getch();
  restorecrtmode();
}





listing 23-19

printf("graphics mode is %d", getgraphmode());





listing 23-20


/* This program demonstrates how a graphics image can be
   moved using getimage(), imagesize(), and putimage().
*/
#include "conio.h"
#include "graphics.h"
#include "stdlib.h"

void box(int, int, int, int, int);

main()
{
  int driver, mode;
  unsigned size;
  void *buf;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  box(20, 20, 200, 200, 15);
  
  setcolor(RED);
  line(20, 20, 200, 200);
  setcolor(GREEN);
  line(20, 200, 200, 20);
  getch();

  /* move the image */

  /* first, get the image's size */  
  size = imagesize(20, 20, 200, 200);
  if(size !=-1) { /* alloc memory for the image */
    buf = malloc(size);  
    if(buf) {
      getimage(20, 20, 200, 200, buf);
      putimage(100, 100, buf, COPY_PUT);
      putimage(300, 50, buf, COPY_PUT);
    }
  }
  outtext("press a key");
  getch();
  restorecrtmode();
}

/* Draw a box given the coordinates of its two corners. */
void box(int startx, int starty, int endx, int endy,
         int color)
{
  setcolor(color);

  line(startx, starty, startx, endy);
  line(startx, starty, endx, starty);
  line(endx, starty, endx, endy);
  line(endx, endy, startx, endy);
}





listing 23-21

struct linesettingstype info;

getlinesettings(&info);





listing 23-22

#include "graphics.h"

main()
{
  int driver, mode;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  printf("largest color: %d", getmaxcolor());
  getch();
  restorecrtmode();
}





listing 23-23

#include "graphics.h"

main()
{
  int driver, mode;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  printf("max X,Y: %d,%d", getmaxx(), getmaxy());
  getch();
  restorecrtmode();
}





listing 23-24

#include "graphics.h"

main()
{
  int driver, mode;
  int high, low;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  getmoderange(driver, &low, &high);
  printf("mode range: %d - %d", low, high);
  getch();
  restorecrtmode();
}





listing 23-25



#include "graphics.h"

main()
{
  int driver, mode;
  struct palettetype p;
  
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  getpalette(&p);
  printf("number of colors in palette: %d", p.size);
  getch();
  restorecrtmode();
}





listing 23-26

color = getpixel(10, 20);




listing 23-27

buf = (char *) malloc(10 * 10 *2);

gettext(10, 10, 20, 20, buf);





listing 23-28

struct textsettingstype t;

gettextsettings(&t);





listing 23-29

struct viewporttype info;

getviewsettings(&info);

printf("view port is %dx%x by %dx%d", info.left, info.right,
	info.top, info.bottom);





listing 23-30

printf("CP's loc: %d, %d", getx(), gety());





listing 23-31


#include "conio.h"

main()
{
  register int i, j;

  clrscr();

  /* print diagonal Xs */
  for(i=1, j=1; j<24; i+=3, j++) {
    gotoxy(i, j);
    printf("X");
  }
  getche();
  clrscr();
}





listing 23-32

graphdefaults();





listing 23-33

  printf("%s", grapherrormsg(graphresult()));





listing 23-34

  printf("%s", grapherrormsg(graphresult()));





listing 23-35

highvideo();





listing 23-36

unsigned size;

size = imagesize(10, 10, 100, 100);





listing 23-37
  int driver, mode;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");




listing 23-38


#include "conio.h"

main()
{
  register int i;

  clrscr();

  /* print diagonal X's */
  for(i=1; i<24; i++) {
    gotoxy(1, i);
    printf("this is line %d\n", i);
  }
  getche();
  gotoxy(1, 10);
  insline();
  getch();
}





listing 23-39
#include "graphics.h"

main()
{
  int driver, mode;
  struct palettetype p;
  
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  line(100, 100, 200, 200);

  lineto(100, 50);

  linerel(30, 40);

  getch();
  restorecrtmode();
}




listing 23-40

lowvideo();





listing 23-41

moverel(10, 20);





listing 23-42

movetext(1, 1, 8, 8, 10, 10);




listing 23-43


moveto(100, 100);





listing 23-44

normvideo();





listing 23-45

#include "graphics.h"

main()
{
  int driver, mode;
  struct palettetype p;
  int i;
  
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  /* write two lines at CP */
  outtext("this is an example ");
  outtext("another line");

  /* use "cursor" positioning */
  for(i=100; i<200; i+=8) outtextxy(200, i, "hello");

  getch();
  restorecrtmode();
}




listing 23-46

#include "graphics.h"

main()
{
  int driver, mode;
  struct palettetype p;
  int i, start, end;
    
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  /* demonstrate pieslice()) */

  start = 0; end = 45;
  for(i=0; i<8; i++) {
    setfillstyle(SOLID_FILL, i);
    pieslice(300, 200, start, end, 100);
    start += 45;
    end += 45;
  }

  getch();
  restorecrtmode();
}





listing 23-47


/* This program demonstrates how a graphics image can be
   moved using getimage(), imagesize(), and putimage().
*/
#include "conio.h"
#include "graphics.h"
#include "stdlib.h"

void box(int, int, int, int, int);

main()
{
  int driver, mode;
  unsigned size;
  void *buf;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  box(20, 20, 200, 200, 15);
  
  setcolor(RED);
  line(20, 20, 200, 200);
  setcolor(GREEN);
  line(20, 200, 200, 20);
  getch();

  /* move the image */

  /* first, get the image's size */  
  size = imagesize(20, 20, 200, 200);
  if(size !=-1) { /* alloc memory for the image */
    buf = malloc(size);  
    if(buf) {
      getimage(20, 20, 200, 200, buf);
      putimage(100, 100, buf, COPY_PUT);
      putimage(300, 50, buf, COPY_PUT);
    }
  }
  outtext("press a key");
  getch();
  restorecrtmode();
}

/* Draw a box given the coordinates of its two corners. */
void box(int startx, int starty, int endx, int endy,
         int color)
{
  setcolor(color);

  rectangle(startx, starty, endx, endy);
}





listing 23-48

putpixel(10, 20, GREEN);





listing 23-49

buf = (char *) malloc(10 * 10 *2);

gettext(10, 10, 20, 20, buf);

puttext(0, 0, 30, 30, buf);





listing 23-50
#include "graphics.h"

main()
{
  int driver, mode;
  
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  rectangle(100, 100, 300, 300);
  rectangle(150, 90, 34, 300);
  rectangle(0, 0, 2, 2);

  getch();
  restorecrtmode();
}





listing 23-51

restorecrtmode();





listing 23-52

setactivepage(1);





listing 23-53

struct palettetype p;
int i;

for(i=0; i<16; i++) p.colors[i] = i;
p.size = 16;

setallpalette(&p);





listing 23-54

#include "graphics.h"

main()
{
  int driver, mode;
  
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  setbkcolor(LIGHTGRAY);

  rectangle(100, 100, 300, 300);
  rectangle(150, 90, 34, 300);
  rectangle(0, 0, 2, 2);

  getch();
  restorecrtmode();
}





listing 23-55

#include "graphics.h"

main()
{
  int driver, mode;
  int i;
  
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  moveto(0, 200);

  for(i=0; i<16; i++) {
    setcolor(i);
    linerel(20, 0);
  }

  getch();
  restorecrtmode();
}





listing 23-56
#include "graphics.h"

main()
{
  int driver, mode;
  /* define a fill pattern */
  char p[8] = {10, 20, 30, 40, 50, 60, 70, 80};
  
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  setcolor(GREEN);
  rectangle(100, 200, 200, 300);

  setfillpattern(p, RED);
  floodfill(150, 250, GREEN);

  getch();
  restorecrtmode();
}





listing 23-57

#include "graphics.h"

main()
{
  int driver, mode;
  /* define a fill pattern */
  char p[8] = {10, 20, 30, 40, 50, 60, 70, 80};
  
  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  rectangle(100, 200, 200, 300);

  setcolor(GREEN);
  setfillstyle(LINE_FILL, RED);
  floodfill(150, 250, GREEN);

  getch();
  restorecrtmode();
}





listing 23-58

/* after graphics system has been intialized */

setgraphmode(CGAHI);





listing 23-59

#include "graphics.h"

main()
{
  int driver, mode;
  int i;


  driver = 0; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  for(i=0; i<4; i++) {
    setlinestyle(i, 0, 1);
    line(i*50, 100, i*50+50, 100);
  }
  getch();
  restorecrtmode();
}





listing 23-60

setpalette(0, GREEN);





listing 23-61

setpalette(5, EGA_CYAN);





listing 23-62

setpalette(0, GREEN);





listing 23-63

settextjustify(RIGHT_TEXT, TOP_TEXT);





listing 23-64

/* Demonstrate some different text fonts and sizes. */

#include "graphics.h"
#include "conio.h"

main()
{
  int driver, mode;
  register int i;

  driver = DETECT; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");

  outtext("Normal ");

  /* Gothic font, twice normal size */
  settextstyle(GOTHIC_FONT, HORIZ_DIR, 2); 
  outtext("Gothic ");

  /* Triplex font, twice normal size */
  settextstyle(TRIPLEX_FONT, HORIZ_DIR, 2); 
  outtext("Triplex ");

  /* Sans serrif font 7, times normal size*/
  settextstyle(TRIPLEX_FONT, HORIZ_DIR, 7); 
  outtext("Sans serif");
  
  getch();
  restorecrtmode();
}




listing 23-65

#include "graphics.h"

main()
{
  int driver, mode;

  driver = 0; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");
  
  outtext("normal ");
  settextstyle(TRIPLEX_FONT, HORIZ_DIR, USER_CHAR_SIZE);

  /* make very big letters */
  setusercharsize(5, 1, 5, 1);
  outtext("big");

  getch();
  restorecrtmode();
}





listing 23-66

setviewport(10, 10, 40, 40, 1);





listing 23-67

setvisualpage(1);





listing 23-68

textattr(RED | BLINK | BLUE*16);





listing 23-69

textbackground(CYAN);





listing 23-70

textcolor(BLINK);





listing 23-71

#include "graphics.h"

main()
{
  int driver, mode;

  driver = 0; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");
  
  printf("heigth: %d", textheight("hello"));

  getch();
  restorecrtmode();
}





listing 23-72

textmode(C80);





listing 23-73

#include "graphics.h"

main()
{
  int driver, mode;

  driver = 0; /* autodetect */
  mode = 0;
  initgraph(&driver, &mode, "");
  
  printf("width: %d", textwidth("hello"));

  getch();
  restorecrtmode();
}





listing 23-74

int xpos, ypos;

xpos = wherex();
ypos = wherey();





listing 23-75

window(10, 10, 60, 15);
gotoxy(2, 3);
cprintf("at location 2, 3");




