/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 10-1

char far *f_pointer;





listing 10-2

int _es *ptr;





listing 10-3

/* Displays 256 bytes of memory starting at specified
   address.
*/
void display_mem()
{
  register int i;
  unsigned char ch;
  unsigned char far *p;
  char s[80];

  /* get a 20 bit address */
  printf("beginning address (in hex): ");
  scanf("%p%*c", &p);

  printf("%p: ", p); /* print address */
  for(i=1; i<=256; i++) {
    ch =  *p;
    printf("%02x ", ch); /* display in hex */
    p++;
    if(!(i%16)) { /* every 16 bytes use new line */
      printf("\n");
      if(i!=256) printf("%p: ", p); /* print address */
    }
  }
}





listing 10-4

/*  Change the contents of a byte of memory. */
void change_mem()
{
  unsigned char far *p;
  char s[80];
  char value;

  /* get a 20-bit address */
  printf("Enter address to change (in hex): ");
  scanf("%p%*c", &p);
  printf("Enter new value (in hex): ");
  scanf("%x", &value);

  /* change the value */
  *p = (unsigned char) value;
}





listing 10-5

/* Display and/or change memory program. */

#include "stdlib.h"

void display_mem(), change_mem();

main()
{
  char ch;

  for(;;) {
    printf("|< "); /* display the prompt symbol */
    ch = getche(); /* read command */
    printf("\n");
    switch(tolower(ch)) {
      case 'd': display_mem();
	break;
      case 'c': change_mem();
	break;
      case 'q': exit(0);
    }
  }
}

/* Displays 256 bytes of memory starting at specified
   address.
*/
void display_mem()
{
  register int i;
  unsigned char ch;
  unsigned char far *p;
  char s[80];

  /* get a 20 bit address */
  printf("beginning address (in hex): ");
  scanf("%p%*c", &p);

  printf("%p: ", p); /* print address */
  for(i=1; i<=256; i++) {
    ch =  *p;
    printf("%02x ", ch); /* display in hex */
    p++;
    if(!(i%16)) { /* every 16 bytes use new line */
      printf("\n");
      if(i!=256) printf("%p: ", p); /* print address */
    }
  }
}

/*  Change the contents of a byte of memory. */
void change_mem()
{
  unsigned char far *p;
  char s[80];
  char value;

  /* get a 20-bit address */
  printf("Enter address to change (in hex): ");
  scanf("%p%*c", &p);
  printf("Enter new value (in hex): ");
  scanf("%x", &value);

  /* change the value */
  *p = (unsigned char) value;
}





listing 10-6

|< d
beginning address (in hex): e001a 
000E:001A: 70 02 45 14 70 02 59 ec 00 f0 3d 04 00 e0 0d 21
000E:002A: 00 f0 66 52 00 e0 0d 21 00 f0 0d 21 00 f0 5d 02
000E:003A: 00 e0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:004A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:005A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:006A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:007A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:008A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:009A: 00 f0 0d 21 00 f0 00 00 00 00 00 00 00 00 00 00
000E:00AA: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
000E:00BA: 00 00 00 00 00 00 0d 21 00 f0 0d 21 00 f0 0d 21
000E:00CA: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:00DA: 00 f0 0d 21 00 f0 a3 01 7a 0e 5c 21 00 f0 0d 21
000E:00EA: 00 f0 0d 21 00 f0 d1 05 7a 0e 65 21 00 f0 59 06
000E:00FA: 7a 0e 0d 21 00 f0 00 00 00 00 00 00 00 00 00 00
000E:010A: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
|< c
Enter address to change (in hex): e001b 
Enter new value (in hex): 00
|< d
beginning address (in hex): e001a 
000E:001A: 70 00 45 14 70 02 59 ec 00 f0 3d 04 00 e0 0d 21
000E:002A: 00 f0 66 52 00 e0 0d 21 00 f0 0d 21 00 f0 5d 02
000E:003A: 00 e0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:004A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:005A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:006A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:007A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:008A: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:009A: 00 f0 0d 21 00 f0 00 00 00 00 00 00 00 00 00 00
000E:00AA: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
000E:00BA: 00 00 00 00 00 00 0d 21 00 f0 0d 21 00 f0 0d 21
000E:00CA: 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21 00 f0 0d 21
000E:00DA: 00 f0 0d 21 00 f0 a3 01 7a 0e 5c 21 00 f0 0d 21
000E:00EA: 00 f0 0d 21 00 f0 d1 05 7a 0e 65 21 00 f0 59 06
000E:00FA: 7a 0e 0d 21 00 f0 00 00 00 00 00 00 00 00 00 00
000E:010A: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00





