/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 8-1
  #include "stdio.h"  
  #include "ctype.h"

  main()  /* case switcher */
  {
    char ch;

    do {
      ch = getche();
      if(islower(ch)) putchar(toupper(ch));
      else putchar(tolower(ch));
    } while (ch!='.'); /* use a period to stop*/
  }






listing 8-2
/* This program appears to act as a DOS gone wild.  It 
   displays the DOS prompt and but displays every character
   the user types as the next letter in the alphabet.
*/

#include "stdio.h"

main()
{
  char ch;

  do {
    printf("C>");
    for(;;) {
      ch = getch(); /* read chars without echo */
      if(ch=='\r' || ch==1) {
        printf("\n");
        break;
      }
      putchar(ch+1);
    }
  } while(ch!=1) ; /* exit on control-A */
}





listing 8-3

main()
{
  char str[80];

  gets(str);
  printf("length is %d", strlen(str));
}




listing 8-4

puts("hello");





listing 8-5

  printf("Hi %c %d %s", 'c', 10, "there!");





listing 8-6

  scanf("%d", &count);





listing 8-7

  scanf("%s", address);





listing 8-8

scanf("%d%d", &r, &c);'





listing 8-9

scanf("%d%*c%d", &x, &y);





listing 8-10

  scanf("%20s", str);





listing 8-11

  scanf("%s", str);





listing 8-12

  scanf("%c%c%c", &a, &b, &c);





listing 8-13

  scanf("%st%s", &x, &y);





listing 8-14

  scanf("%s ", name);





listing 8-15

  fp = fopen("test", "w");





listing 8-16


  if ((fp = fopen("test", "w"))==NULL) {
    puts("cannot open file\n");
    exit(1);
  }





listing 8-17

  ch = getc(fp);

  while(ch!=EOF) { 
    ch = getc(fp);
  }





listing 8-18

while(!feof(fp)) ch = getc(fp);





listing 8-19

#include "stdio.h"

main(argc, argv)  /* ktod - key to disk */
int argc;
char *argv[];
{
  FILE *fp;
  char ch;

  if(argc!=2) {
    printf("You forgot to enter the filename\n");
    exit(1);
  }

  if((fp=fopen(argv[1],"w")) == NULL) {
    printf("cannot open file\n");
    exit(1);
  }

  do {
    ch = getchar();
    putc(ch, fp);
  } while (ch!='$');

  fclose(fp);

}





listing 8-20

#include "stdio.h"

main(argc, argv)    /* dtos - disk to screen */
int argc;
char *argv[];
{
  FILE *fp;
  char ch;

  if(argc!=2) {
    printf("You forgot to enter the filename\n");
    exit(1);
  }

  if((fp=fopen(argv[1], "r")) == NULL) {
    printf("cannot open file\n");
    exit(1);
  }

  ch=getc(fp);   /* read one character */

  while (ch!=EOF) {
    putchar(ch);  /* print on screen */
    ch = getc(fp);
  } 

  fclose(fp);
}





listing 8-21
/* This program will copy a file to another. */
#include "stdio.h"

main(argc, argv) 
int argc;
char *argv[];
{
  FILE *in, *out;
  char ch;

  if(argc!=3) {
    printf("You forgot to enter a filename\n");
    exit(1);
  }

  if((in=fopen(argv[1], "rb")) == NULL) {
    printf("cannot open source file\n");
    exit(1);
  }
  if((out=fopen(argv[2], "wb")) == NULL) {
    printf("cannot open destination file\n");
    exit(1);
  }

  /* this code acutally copies the file */
  while(!feof(in)) {
     ch = getc(in);
     if(!feof(in)) putc(ch, out);
  }

  fclose(in);
  fclose(out);
}





listing 8-22

putw(100, fp);





listing 8-23
/* write a floating point number to a disk file */
#include "stdio.h"

main()
{
  FILE *fp;
  float f=12.23;

  if((fp=fopen("test","wb"))==NULL) {
    printf("cannot open file\n");
    return;
  }

  fwrite(&f, sizeof(float), 1, fp);

  fclose(fp);
}





listing 8-24

#include "stdio.h"

main()
{
  FILE *fp;
  float balance[100];

  if((fp=fopen("balance","w+"))==NULL) {
    printf("cannot open file\n");
    return;
  }
  .
  .
  .
  /* this saves the entire balance array in one step */
  fwrite(balance, sizeof(balance), 1, fp);
  .
  .
  .
  fclose(fp);
}






listing 8-25

  func1()
  {
    FILE *fp;

    if((fp=fopen("test", "rb")) == NULL) {
      printf("cannot open file\n");
      exit(1);
    }

    fseek(fp, 234L, 0);
    return getc(fp);   /* read one character */
                       /* at 234th position */

  }





listing 8-26

/* DUMP: A simple disk look utility using fseek. */
#include "stdio.h"
#include "ctype.h"

#define SIZE 128

char buf[SIZE];
void display();

main(argc, argv)
int argc;
char *argv[];
{
  FILE *fp;
  int sector, numread;

  if(argc!=2) {
    printf("usage: dump filename\n");
    exit(1);
  }

  if((fp=fopen(argv[1], "rb"))==NULL) {
    printf("cannot open file\n");
    exit(1);
  }

  do {
    printf("enter sector: ");
    scanf("%ld", &sector);
    if(sector>=0) {
      if(fseek(fp, sector*SIZE, SEEK_SET)) {
        printf("seek error\n");
      }
      if((numread=fread(buf, 1, SIZE, fp)) != SIZE) {
        printf("EOF reached\n");
      }
      display(numread);
    }
  } while(sector>=0);
}

/* Display the contents of a file. */
void display(numread)
int numread;
{
  int i, j;

  for(i=0; i<numread/16; i++) {
    for(j=0; j<16; j++) printf("%3X", buf[i*16+j]);
    printf("  ");
    for(j=0; j<16; j++) {
      if(isprint(buf[i*16+j])) printf("%c", buf[i*16+j]);
      else printf(".");
    }
    printf("\n");
  }
}





listing 8-27

  putchar(c)
  char c;
  {
    putc(c, stdout);
  }






listing 8-28
/* A simple telephone directory */

#include "stdio.h"

void add_num(), lookup();

main()  /* fscanf - fprintf example */
{
 char choice;
   
  
  do {
    choice = menu(); 
    switch(choice) {
      case 'a': add_num();
        break;
      case 'l': lookup();
 	break;
    }
  } while (choice!='q');

}

/* display menu and get request */
menu()
{
  char ch;

  do {
    printf("(A)dd, (L)ookup, or (Q)uit: ");
    ch = tolower(getche());
    printf("\n");
  } while(ch != 'q' && ch != 'a' && ch != 'l');

  return ch;
}

/* add a name and number to the directory */
void add_num()
{
  FILE *fp;
  char name[80];
  int a_code, exchg, num;

  /* open it for append */
  if((fp=fopen("phone","a")) == NULL) {
    printf("cannot open directory file\n");
    exit(1);
  }

  printf("enter name and number: ");
    fscanf(stdin, "%s%d%d%d", name, &a_code, &exchg, &num); 
  fscanf(stdin, "%*c"); /* remove CR from input stream */

  /* write to file */
  fprintf(fp,"%s %d %d %d\n", name, a_code, exchg, num);

  fclose(fp);
}

/* find a number given a name */
void lookup()
{
  FILE *fp;
  char name[80], name2[80];
  int a_code, exchg, num;

  /* open it for read */
  if((fp=fopen("phone","r")) == NULL) {
    printf("cannot open directory file\n");
    exit(1);
  }

  printf("name? ");
  gets(name);

  /* look for number */
  while(!feof(fp)) {
    fscanf(fp,"%s%d%d%d", name2, &a_code, &exchg, &num); 
    if(!strcmp(name, name2)) {
      printf("%s: (%d) %d-%d\n",name, a_code, exchg, num);
      break;
    }  
  }
  fclose(fp);
}
 





listing 8-29


  if((fd=open(filename, mode, 0)) == -1)  {
    printf("cannot open file\n");
    exit(1);
  }





listing 8-30

#include "fcntl.h"
#include "io.h"

#define BUF_SIZE  128

main()  /* read and write using unbuffered I/O */
{
  char buf[BUF_SIZE];
  int fd1, fd2, t;

  /* open for write */
  if((fd1=open("oscar", O_WRONLY | O_CREAT))==-1) {
    printf("cannot open file\n");
    exit(1);
  }

  input(buf, fd1);

  /* now close file and read back */
  close(fd1);
  
  if((fd2=open("oscar", O_RDONLY))==-1) { /* open for write */
    printf("cannot open file\n");
    exit(1);
  }
  
  display(buf,fd2);
  close(fd2);
}

input(char *buf, int fd1)
{
  register int t;

  do {
    for(t=0; t<BUF_SIZE; t++) buf[t]='\0'; 
    gets(buf); /* input chars from keyboard */
    if(write(fd1, buf, BUF_SIZE)!=BUF_SIZE) {
      printf("error on write\n");
      exit(1);
    }
  } while (strcmp(buf, "quit"));
}


display(buf, fd2)
char *buf;
int fd2;
{
  for(;;) {
    if(read(fd2, buf, BUF_SIZE)==0) return;
    printf("%s\n",buf);
  }
}






listing 8-31

#include "io.h"
#include "ctype.h"
#include "stdio.h"
#include "fcntl.h"

#define SIZE  128

char buf[SIZE];
void display();

main(argc, argv)  /* read buffers using lseek() */
int argc; char *argv[];
{
  char s[10];
  int fd, sector, numread;
  long pos;

  if(argc!=2) {
    printf("You forgot to enter the file name.");
    exit(1);
  }

  if((fd=open(argv[1], O_RDONLY, 0))==-1) { /* open for read */
    printf("cannot open file\n");
    exit(1);
  }
  do {
    printf("\n\nbuffer: ");
    gets(s);

    sector = atoi(s); /* get the sector to read */

    pos = (long) (sector*SIZE);
    if(lseek(fd, pos, SEEK_SET)!=pos)
      printf("seek error\n");
    
    if((numread=read(fd, buf, SIZE))!=SIZE) 
      printf("EOF reached\n");
    display(numread);
  } while(sector>=0);
  close(fd);
}

void display(numread)
int numread;
{
  int i, j;

  for(i=0; i<numread/16; i++) {
    for(j=0; j<16; j++) printf("%3X", buf[i*16+j]);
    printf("  ");
    for(j=0; j<16; j++) {
      if(isprint(buf[i*16+j])) printf("%c", buf[i*16+j]);
      else printf(".");
    }
    printf("\n");
  }
}





