/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 7-1

  struct addr {
    char name[30];
    char street[40];
    char city[20];
    char state[2];
    unsigned long int zip;
  };





listing 7-2

  struct addr addr_info;





listing 7-3

  struct addr {
    char name[30];
    char street[40];
    char city[20];
    char state[2];
    unsigned long int zip;
  } addr_info, binfo, cinfo;





listing 7-4

  struct  {
    char name[30];
    char street[40];
    char city[20];
    char state[2];
    unsigned long int zip;
  } addr_info;





listing 7-5

  addr_info.zip = 12345;





listing 7-6

  printf("%d",addr_info.zip);





listing 7-7

  gets(addr_info.name);





listing 7-8

  register int t;

  for(t=0; addr_info.name[t]; ++t) putche(addr_info.name[t]);





listing 7-9

  struct addr addr_info[100];





listing 7-10

  printf("%d",addr_info[2].zip);





listing 7-11
#define MAX 100

struct inv {
  char item[30];
  float cost;
  int on_hand;
} inv_info[MAX];





listing 7-12

main()  
{
  char choice;

  init_list(); /* initialize the structure array*/
  for(;;) {
    choice = menu_select();
    switch(choice) {
      case 1: enter();
        break;
      case 2: delete();
        break;
      case 3: list();
        break;
      case 4: exit(0);
    }
  } 
}





listing 7-13


/* Initialize the structure array. */
void init_list()
{
  register int t;

  for(t=0; t<MAX; ++t) inv_info[t].item[0] = '\0';
}





listing 7-14


/* Input the user's selection. */
menu_select()
{
  char s[80];
  int c;

  printf("\n");
  printf("1. Enter a item\n");
  printf("2. Delete a item\n");
  printf("3. List the inventory\n");
  printf("4. Quit\n");
  do {
    printf("\nEnter your choice: ");
    gets(s);
    c = atoi(s);
  } while(c<0 || c>4);
  return c;
}





listing 7-15


/* Input the inventory information. */
void enter()
{
  int slot;
  slot = find_free();
  if(slot==-1) {
    printf("\nlist full");
    return;
  }

  printf("enter item: ");
  gets(inv_info[slot].item);

  printf("enter cost: ");
  scanf("%f", &inv_info[slot].cost);

  printf("enter number on hand: ");
  scanf("%d%*c",&inv_info[slot].on_hand);
}

/* Return the index of the first unused array
   location or -1 if the no free locations exist. 
*/
find_free()
{
  register int t;

  for(t=0;inv_info[t].item[0] && t<MAX;++t) ;
  if(t==MAX) return -1; /* no slots free */
  return t;
}





listing 7-16

/* Delete an item from the list. */
void delete()
{
  register int slot;
  char s[80];
  printf("enter record #: ");
  gets(s);
  slot=atoi(s);
  if(slot>=0 && slot < MAX) inv_info[slot].item[0]='\0';
}





listing 7-17

/* Display the list on the screen. */
void list()
{
  register int t;

  for(t=0;t<MAX;++t) {
    if(inv_info[t].item[0]) {
      printf("item: %s\n",inv_info[t].item);
      printf("cost: %f\n",inv_info[t].cost);
      printf("on hand: %d\n\n",inv_info[t].on_hand);
    }
  }
  printf("\n\n");
}





listing for the inventory
program is shown here.  If you have any doubts about your
understanding of structures, you should enter this program into
your computer and  study its execution making changes and
watching their affect.





listing 7-18
/* A simple inventory program using an array of structures */

#define MAX 100

struct inv {
  char item[30];
  float cost;
  int on_hand;
} inv_info[MAX];

void init_list(), list(), delete(), enter();

main()  
{
  char choice;

  init_list(); /* initialize the structure array*/
  for(;;) {
    choice = menu_select();
    switch(choice) {
      case 1: enter();
        break;
      case 2: delete();
        break;
      case 3: list();
        break;
      case 4: exit(0);
    }
  } 
}

/* Initialize the structure array. */
void init_list()
{
  register int t;

  for(t=0; t<MAX; ++t) inv_info[t].item[0] = '\0';
}

/* Input the user's selection. */
menu_select()
{
  char s[80];
  int c;

  printf("\n");
  printf("1. Enter a item\n");
  printf("2. Delete a item\n");
  printf("3. List the inventory\n");
  printf("4. Quit\n");
  do {
    printf("\nEnter your choice: ");
    gets(s);
    c = atoi(s);
  } while(c<0 || c>4);
  return c;
}

/* Input the inventory information. */
void enter()
{
  int slot;
  slot = find_free();
  if(slot==-1) {
    printf("\nlist full");
    return;
  }

  printf("enter item: ");
  gets(inv_info[slot].item);

  printf("enter cost: ");
  scanf("%f", &inv_info[slot].cost);

  printf("enter number on hand: ");
  scanf("%d%*c",&inv_info[slot].on_hand);
}

/* Return the index of the first unused array
   location or -1 if the no free locations exist. 
*/
find_free()
{
  register int t;

  for(t=0;inv_info[t].item[0] && t<MAX;++t) ;
  if(t==MAX) return -1; /* no slots free */
  return t;
}

/* Delete an item from the list. */
void delete()
{
  register int slot;
  char s[80];
  printf("enter record #: ");
  gets(s);
  slot=atoi(s);
  if(slot>=0 && slot < MAX) inv_info[slot].item[0]='\0';
}

/* Display the list on the screen. */
void list()
{
  register int t;

  for(t=0;t<MAX;++t) {
    if(inv_info[t].item[0]) {
      printf("item: %s\n",inv_info[t].item);
      printf("cost: %f\n",inv_info[t].cost);
      printf("on hand: %d\n\n",inv_info[t].on_hand);
    }
  }
  printf("\n\n");
}





listing 7-19

  struct fred {
    char x;
    int y;
    float z;
    char s[10];
  } mike;





listing 7-20

  func(mike.x);  /* passes character value of x */

  func2(mike.y); /* passes integer value of y */

  func3(mike.z); /* passes float value of z */

  func4(mike.s); /* passes address of string s */

  func(mike.s[2]); /* passes character value of s[2] */





listing 7-21

  func(&mike.x);  /* passes address of character x */

  func2(&mike.y); /* passes address of integer y */

  func3(&mike.z); /* passes address of float z*/

  func4(mike.s); /* passes address of string s */

  func(&mike.s[2]); /* passes address of character s[2] */





listing 7-22

main()
{
  struct {
    int a,b;
    char ch;
  } arg;

  arg.a=1000;

  f1(arg);
}

f1(parm)
struct {
  int x,y;
  char ch;
} parm;
{
  printf("%d",parm.x);
}





listing 7-23


/* define a structure type */
struct struct_type {
  int a,b;
  char ch;
} ;


main()
{
  struct struct_type arg;  /* declare arg */

  arg.a=1000;

  f1(arg);
}

f1(parm)
struct struct_type parm;
{
  printf("%d",parm.a);
}






listing 7-24

struct addr *addr_pointer;





listing 7-25

  struct bal {
    float balance;
    char name[80];
  } person;

  struct bal *p;  /* declare a structure pointer */





listing 7-26
  
  p = &person;





listing 7-27

  (*p).balance





listing 7-28   
/* display a software timer */

struct tm {
  int hours;
  int minutes;
  int seconds;
} ;
main()  /* version 1 - explicit pointer references */
{
  struct tm time;

  time.hours = 0;
  time.minutes = 0;  
  time.seconds = 0;

  for(;;) {
    update(&time);
    display(&time);
  }   
}

update(t)
struct tm *t;
{
  (*t).seconds++;
  if((*t).seconds==60) {
    (*t).seconds=0;
    (*t).minutes++;
  }
  if((*t).minutes==60) {
    (*t).minutes=0;
    (*t).hours++;
  }
  if((*t).hours==24) (*t).hours = 0;
  delay();
}
display(t)
struct tm *t;
{
  printf("%d:",(*t).hours);
  printf("%d:",(*t).minutes);
  printf("%d\n",(*t).seconds);
}

delay()
{
  long int t;
  for(t=1;t<128000;++t) ;
}





listing 7-29

  if((*t).hours==24) (*t).hours = 0;





listing 7-30

  (*t).hours  





listing 7-31

  t->hours





listing 7-32

update(t)
struct tm *t;
{
  t->seconds++;

  if(t->seconds==60) {
    t->seconds=0;
    t->minutes++;
  }

  if(t->minutes==60) {
    t->minutes=0;
    t->hours++;
  }

  if(t->hours==24) t->hours = 0;

  delay();

}





listing 7-33

/* A generalized input example using structure pointers. */

struct xyinput {
  int x, y; /* screen location for prompt */
  char message[80]; /* prompting message */
  int i; /* input value */
} ;

void input_xy();

main()
{
  struct xyinput mess;

  mess.x = 10; mess.y = 10;
  strcpy(mess.message, "enter an integer: ");

  clrscr();
   
  input_xy(&mess);

  printf("your number squared is: %d", mess.i*mess.i);
}

/* Display a prompting message at the specified location
   and input an integer value.
*/
void input_xy(info)
struct xyinput *info;
{
  gotoxy(info->x, info->y);

  printf(info->message);
  scanf("%d", &info->i);
}




listing 7-34

  struct x {
    int a[10][10]; /* 10 x 10 array of ints */
    float b;
  } y;





listing 7-35

  y.a[3][7]





listing 7-36

struct emp {
  struct addr address;
  float wage;
} worker;





listing 7-37

  struct device {
    unsigned active : 1;
    unsigned ready : 1;
    unsigned xmt_error : 1;
  } dev_code;





listing 7-38

  wr_tape(c)
  char c;
  {
    while(!dev_code.ready) rd(&dev_code); /* wait */

    wr_to_tape(c); /* write out byte */

    while(dev_code.active) rd(&dev_code); /* wait till
          info is written */

    if(dev_code.xmt_error) printf("write error");
  }





listing 7-39

  struct device {
    unsigned active : 1;
    unsigned ready : 1;
    unsigned xmt_error : 1;
    unsigned : 2;
    unsigned EOT : 1;
  } dev_code;





listing 7-40

struct emp {
  struct addr address;
  float pay;
  unsigned lay_off:1;  /* lay off or active */
  unsigned hourly:1:   /* hourly pay or wage */
  unsigned deductions:3: /* IRS deductions */
};





listing 7-41

  union union_type {
    int i;
    char ch;
  } ;





listing 7-42

  union u cnvt;





listing 7-43

  cnvt.i = 10;





listing 7-44

  union pw {
    int i;
    char ch[2];
  };





listing 7-45

  putw(word, fp)  /* putw with union */
  union pw word;
  FILE *fp;
  {
    putc(word->ch[0]); /* write first half */
    putc(word->ch[1]); /* write second half */
  }





listing 7-46

enum coin { penny, nickel, dime, quarter, 
            half_dollar, dollar};

enum coin money;





listing 7-47

money = dime;

if(money==quarter) printf("is a quarter\n");





listing 7-48

printf("the number of nickles in a quarter is %d ", quarter/5);





listing 7-49

printf("%d %d",penny, dime);





listing 7-50

enum coin { penny, nickel, dime, quarter=100, 
            half_dollar, dollar};





listing 7-51

/* this will not work */

money = dollar;

printf("%s", money);





listing 7-52

/* this code will not work */

moeny = "penny";





listing 7-53

switch(money) {
  case penny: printf("penny");
	break;
  case nickel: printf("nickel");
	break;
  case dime: printf("dime");
	break;
  case quarter: printf("quarter");
	break;
  case half_dollar: printf("half_dollar");
	break;
  case dollar: printf("dollar");
}





listing 7-54

char name[]={
  "penny",
  "nickel",
  "dime",
  "quarter",
  "half_dollar",
  "dollar"
};
.
.
.
printf("%s", name[(int)money]);





listing 7-55

  char ch;
  int i;
  float f;

  printf("%d",sizeof(ch));

  printf("%d",sizeof(i));

  printf("%d",sizeof(f));





listing 7-56

  union x {
    char ch;
    int i;
    float f;
  } tom;





listing 7-57

  typedef float balance;





listing 7-58

  balance over_due;





listing 7-59

  typedef struct client {
    float due;
    int over_due;
    char name[40];
  };

  client clist[NUM_CLIENTS]; /* define array of
                   structures of type client */




