/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 5-1

  char p[10];





listing 5-2

main()
{
  int x[10];  /* this reserves 10 integer elements */
  int t;

  for(t=0; t<10; ++t) x[t]=t;
}






listing 5-3

char a[7];





listing 5-4
main()
{
  int i[10];

  func1(i);
  .
  .
  .
}





listing 5-5

  func1(str)
  int *str;  /* pointer */
  {
    .
    .
    .
  }





listing 5-6

  func1(str)
  char str[10]; /* sized array */
  {
    .
    .
    .
  }




listing 5-7

  func1(str)
  char str[]; /* unsized array */
  {
    .
    .
    .
  }




listing 5-8

  func1(str)
  int str[32];
  {
    .
    .
    .





listing 5-9

  char s[11];





listing 5-10
#include "string.h"

main()
{
  char s1[80], s2[80];

  gets(s1); gets(s2);

  printf("lengths: %d %d\n", strlen(s1), strlen(s2));

  if(!strcmp(s1, s2)) printf("The strings are equal\n");
  
  strcat(s1, s2);
  printf("%s\n", s1);
}





listing 5-11

lengths: 6 6
The strings are equal
hellohello





listing 5-12

  int d[10][20];





listing 5-13

  d[3][5]





listing 5-14   

  main()
  {
    int t,i, num[3][4];

    for(t=0;t<3;++t) 
      for(i=0;i<4;++i)
        num[t][i]=(t*4)+i+1;
  }





listing 5-15

  func1(x)
  int x[][10];
  {
    .
    .
    .
  }




listing 5-16

  x[2][4]





listing 5-17   
#define CLASSES  3
#define GRADES  30
int grade[CLASSES][GRADES];

main()  /* class grades program */
{
  char ch;

  for(;;) {
    do {
      printf("(E)nter grades\n");
      printf("(R)eport grades\n");
      printf("(Q)uit\n");
      ch = toupper(getche());
    } while(ch!='E' && ch!='R' && ch!='Q');

    switch(ch) {
      case 'E':
        enter_grades();
        break;
      case 'R':
        disp_grades(grade);
        break;
      case 'Q':
        exit(0);
    }
  } 

}

/* Enter each student's grade. */
enter_grades()
{
  int t, i;

  for(t=0; t<CLASSES; t++) {
    printf("Class # %d:\n", t+1);
    for(i=0; i<GRADES; ++i) 
      grade[t][i] = get_grade(i);
  }
}

/* Actually input the grade. */
get_grade(num)
int num;
{
  char s[80];

  printf("enter grade for student # %d:\n", num+1);
  gets(s);
  return(atoi(s));
}

/* Display the class grades. */
disp_grades(g)
int g[][CLASSES];
{
  int t, i;

  for(t=0; t<CLASSES; ++t) {
    printf("Class # %d:\n", t+1);
    for(i=0; i<GRADES; ++i) 
      printf("grade for student #%d is %d\n",i+1, g[t][i]);
  }
}






listing 5-18

char str_array[30][80];





listing 5-19

gets(str_array[2]);





listing 5-20

gets(&str_array[2][0]);





listing 5-21

#include "stdio.h"

#define MAX 100
#define LEN 80

char text[MAX][LEN];

/* A very simple text editor. */
main()
{
  register int t, i, j;

  for(t=0; t<MAX; t++) {
    printf("%d: ", t);
    gets(text[t]);
    if(!*text[t]) break; /* quit on blank line */
  }
  
  for(i=0; i<t; i++) {
    for(j=0; text[i][j]; j++) printf("%c", text[i][j]);
    printf("%c", '\n');
  }
}





listing 5-22

  int m[4][3][6][5];





listing 5-23

  func1(d)

  int d[][3][6][5];

  {

  .

  .

  .





listing 5-24

  char p[10];





listing 5-25
  p

  &p[0]





listing 5-26

  p==&p[0]





listing 5-27

  a

  &a[0][0]





listing 5-28

  int num[10][10];
  .
  .
  .
  pr_row(j)
  int j;
  {
    int *p, t;

    p = &num[j][0]; /* get address of first
                       element in row j */
    for(t=0; t<10; ++t) printf("%d ", *(p+t));
  }





listing 5-29

  pr_row(j, row_dimension, p) /* general */
  int j, row_dimension;
  int *p;
  {
    int t;

    p = p + (j * row_dimension);
    for(t=0; t<row_dimension; ++t) 
      printf("%d ", *(p+t));
  }





listing 5-30
void *p;
 
p = malloc(num_bytes);

free(p);





listing 5-31

  char *p;

  p = (char *) malloc(1000); /* get 1000 bytes */





listing 5-32

#include "stdlib.h"

/* Print a string backwards using dynamic allocation. */
main()
{
  char *s;
  register int t;

  s = (char *) malloc(80);

  if(!s) {
    printf("memory request failed\n");
    exit(1);
  }

  gets(s);
  for(t=strlen(s)-1; t>=0; t--) printf("%c", s[t]);
  free(s);
}






listing 5-33

#include "stdlib.h"

/* This program displays varisou numbers raised to intger
   powers. */
main()
{
  int *p;

  p = (int *) malloc(40*sizeof(int));

  if(!p) {
    printf("memory request failed\n");
    exit(1);
  }

  /* here, p is simply a pointer */
  table(p);
  show(p);
}

/* Build a table of numbers. */
table(p)
int p[4][10]; /* now the compiler thinks that p
                 p is an array */
{
  register int i, j;

  for(j=1; j<11; j++) 
    for(i=1; i<5; i++) p[i][j] = pwr(j, i);
}

/* Display the table. */
show(p)
int p[4][10];
{
  register int i, j;

  printf("%10s %10s %10s %10s\n","N","N^2","N^3","N^4");
  for(j=1; j<11; j++) {
    for(i=1; i<5; i++) printf("%10d ", p[i][j]);
    printf("\n");
  }
}

/* Raise a to the b power. */
pwr(a, b)
int a, b;
{
  register int t=1;

  for(; b; b--) t = t*a;
  return t;
}





listing 5-34

         N        N^2        N^3        N^4
         1          1          1          1 
         2          4          8         16 
         3          9         27         81 
         4         16         64        256 
         5         25        125        625 
         6         36        216       1296 
         7         49        343       2401 
         8         64        512       4096 
         9         81        729       6561 
        10        100       1000      10000 





listing 5-35

int i[10] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};





listing 5-36
 
char str[6] = "hello";





listing 5-37

char str[6] = {'h', 'e', 'l', 'l', 'o', '\0'};





listing 5-38

int sqrs[10][2] = {
  1,1,
  2,4,
  3,9,
  4,16,
  5,25,
  6,36,
  7,49,
  8,64,
  9,81,
  10,100
};





listing 5-39
char e1[12] = "read error\n";
char e2[13] = "write error\n";
char e3[18] = "cannot open file\n";





listing 5-40

char e1[] = "read error\n";
char e2[] = "write error\n";
char e3[] = "cannot open file\n";





listing 5-41

  printf("%s has length %d\n", e2, sizeof e2);





listing 5-42

write error
has length 13





listing 5-43

int sqrs[][2] = {
  1,1,
  2,4,
  3,9,
  4,16,
  5,25,
  6,36,
  7,49,
  8,64,
  9,81,
  10,100
};





listing 5-44

/* A simple game of Tic Tac Toe. */

#define SPACE  ' '

char matrix[3][3] = {  /* the tic tac toe matrix */
  SPACE,SPACE,SPACE,
  SPACE,SPACE,SPACE,
  SPACE,SPACE,SPACE
};

void get_computer_move(), get_player_move(), disp_matrix();

main()
{
  char done;

  printf("This is the game of Tic Tac Toe.\n");
  printf("You will be playing against the computer.\n");

  done = SPACE;
  do {
    disp_matrix();        /* display the game board */
    get_player_move();    /* get your move */
    done = check();       /* see if winner */
    if(done!=SPACE) break;/* winner!*/
    get_computer_move();  /* get computer's move */
    done = check();       /* see if winner */
  } while(done==SPACE);
  if(done=='X') printf("You won!\n");
  else printf("I won!!!!\n");
  disp_matrix(); /* show final positions */
}

/* Input the player's move. */
void get_player_move()
{
  int x, y;

  printf("Enter coordinates for your X: ");
  scanf("%d%d",&x, &y);
  x--; y--; 
  if(matrix[x][y]!=SPACE) {
    printf("Invalid move, try again.\n");
    get_player_move();
  }
  else matrix[x][y] = 'X';
}

/* Computer the computer's move */
void get_computer_move()
{
  register int t;
  char *p;

  p = (char *) matrix;
  for(t=0; *p!=SPACE && t<9; ++t) p++;
  if(t==9)  {
    printf("draw\n");
    exit(0); /* game over */
  }
  else *p = 'O';
}

/* Display the game board. */
void disp_matrix()
{
  int t, i;

  for(t=0; t<3; t++) {
    printf(" %c | %c | %c ", matrix[t][0],
      matrix[t][1], matrix [t][2]);
    if(t!=2) printf("\n---|---|---\n");
  }
  printf("\n");
}





listing 5-45

/* A simple game of Tic Tac Toe. */

#define SPACE  ' '

char matrix[3][3] = {  /* the tic tac toe matrix */
  SPACE,SPACE,SPACE,
  SPACE,SPACE,SPACE,
  SPACE,SPACE,SPACE
};

void get_computer_move(), get_player_move(), disp_matrix();

main()
{
  char done;
 
  printf("This is the game of Tic Tac Toe.\n");
  printf("You will be playing against the computer.\n");

  done=SPACE;
  do {
    disp_matrix();         /* display the game board */
    get_player_move();     /* get your move */
    done=check();          /* see if winner */
    if(done!=SPACE) break; /* winner!*/
    get_computer_move();   /* get computer's move */
    done=check();          /* see if winner */
  } while(done==SPACE);
  if(done=='X') printf("You won!\n");
  else printf("I won!!!!\n");
  disp_matrix(); /* show final positions */
}

/* Input the player's move. */
void get_player_move()
{
  int x, y;

  printf("Enter coordinates for your X: ");
  scanf("%d%d",&x, &y);
  x--; y--; 
  if(matrix[x][y]!=SPACE) {
    printf("Invalid move, try again.\n");
    get_player_move();
  }
  else matrix[x][y]='X';
}

/* Get the computer's move */
void get_computer_move()
{
  register int t;
  char *p;

  p = (char *) matrix;
  for(t=0; *p!=SPACE && t<9; ++t) p++;
  if(t==9)  {
    printf("draw\n");
    exit(0); /* game over */
  }
  else *p = 'O';
}

/* Display the game board. */
void disp_matrix()
{
  int t, i;

  for(t=0; t<3; t++) {
    printf(" %c | %c | %c ", matrix[t][0],
      matrix[t][1], matrix [t][2]);
    if(t!=2) printf("\n---|---|---\n");
  }
  printf("\n");
}

/* See if there is a winner. */
check()
{
  int t;
  char *p;

  for(t=0; t<3; t++) { /* check rows */
    p = &matrix[t][0];
    if(*p==*(p+1) && *(p+1)==*(p+2)) return *p;
  }

  for(t=0; t<3; t++) { /* check columns */
    p = &matrix[0][t];
    if(*p==*(p+3) && *(p+3)==*(p+6)) return *p;
  }

  /* test diagonals */
  if(matrix[0][0]==matrix[1][1] && matrix[1][1]==matrix[2][2])
    return matrix[0][0];

  if(matrix[0][2]==matrix[1][1] && matrix[1][1]==matrix[2][0])
    return matrix[0][2];

  return SPACE;
}




