/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 29-1

FILE *fp;

if((fp=fopen("mlist","r+"))==NULL) {
  printf("cannot open MLIST file\n");
  exit(1);
}





listing 29-2

struct addr {
  char name[30];
  char street[40];
  char city[20];
  char state[3];
  char zip[10]; /* hold US and Canadian zips */
  struct addr *left;  /* pointer to left subtree */
  struct addr *right;  /* pointer to right subtree */
};





listing 29-3

float func(int, int);

main()
{
  int x;

  x=10; 
  func(x);  /* number of arguments mismatch */
}

float func(int x, int y)
{
  printf("%f", y*x);
}





listing 29-4

TEST1.C
TEST2.C





listing 29-5

/* file TEST1.C */

main()
{
  printf("This is file 1.\n");

  count(); /* this is in TEST2.C */
}





listing 29-6

/* file TEST2.C */

count()
{
  int i;
  
  for(i=0; i<10; i++)
    printf("%d ", i);
}





listing 29-7

TEST1
TEST2 (MYPROG.H)





listing 29-8

/* file TEST1.C */
int max;

main()
{
  printf("This is file 1.\n");

  max = 100;
  count(); /* this is in TEST2.C */
}



/* file TEST2.C */

#include "myprog.h"  /* read in the header file */

count()
{
  int i;
  
  for(i=0; i<max; i++)
    printf("%d ", i);
}





listing 29-9

/* header file MYPROG.H */

extern int max;





listing 29-10

tcc test.exe: test.h # recreate if header file changed
	tcc -c test2
	tcc -c test3
        tcc test test2.obj test3.obj

test.obj: test.c # test.c changed
	tcc test test2.obj test3.obj

test2.obj: test2.c # test2.c changed
	tcc -etest test2 test.obj test3.obj

test3.obj: test3.c # test3.c changed
	tcc -etest test3 test.obj test2.obj





listing 29-11

# this is an incorrect make file

test.obj: test.c # test.c changed
	tcc test test2.obj test3.obj

test2.obj: test2.c # test2.c changed
	tcc -etest test2 test.obj test3.obj

test3.obj: test3.c # test3.c changed
	tcc -etest test3 test.obj test2.obj

tcc test.exe: test.h # recreate if header file changed
	tcc -c test2
	tcc -c test3
        tcc test test2.obj, test3.obj





listing 29-12

/* A very trivial library of functions. */

func1()
{
  printf("this is function 1\n");

}

func2()
{
  printf("this is function 2\n");
}

func3()
{
  printf("this is function 3\n");
}

func4()
{
  printf("this is function 4\n");
}




listing 29-13

main()
{
   func1();
   func2();
   func3();
}





listing 29-14

Publics by module

TEST    	size = 116
	_func1                            _func2
	_func3                            _func4




