/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 25-1

/* Store an appointment. */
void qstore(char *q)
{
  if(spos==MAX) {
    printf("list full\n");
    return;
  }
  p[spos]=q;
  spos++;
}

/* Retrieve an appointment. */
char *qretrieve()
{
  if(rpos==spos) {
    printf("No (more) appointments.\n");
    return NULL;
  }
  rpos++;
  return p[rpos-1];
}






listing 25-2

#include "stdlib.h"
#include "stdio.h"
#define MAX 100

char *p[MAX], *qretrieve();
int spos;
int rpos;
void enter(void), qstore(char *), review(void), delete(void);

main()  /* Mini Appointment-Scheduler */
{
  char s[80];
  register int t;

  for(t=0; t<MAX; ++t) p[t]=NULL; /* init array to nulls */
  spos=0; rpos=0;

  for(;;) {
    printf("Enter, List, Remove, Quit: ");
    gets(s);
    *s = toupper(*s);

    switch(*s) {
      case 'E':
        enter();
        break;
      case 'L':
        review();
        break;
      case 'R':
        delete();
        break;
      case 'Q':
        exit(0);
    }
  } 
}

/* Enter appointments in queue. */
void enter()
{
  char s[256], *p;

  do {
    printf("enter appointment %d: ", spos+1);
    gets(s);
    if(*s==0) break;  /* no entry */
    p=malloc(strlen(s));
    if(!p) {
      printf("out of memory.\n");
      return;
    }
    strcpy(p, s);  
    if(*s) qstore(p);
  }while(*s);
}  

/* See what's in the queue. */
void review()
{
  register int t;

  for(t=rpos; t<spos; ++t) 
    printf("%d. %s\n", t+1, p[t]);
}

/* Delete an appointment from the queue. */
void delete()
{
  char *p;

  if(!(p=qretrieve())) return;
  printf("%s\n", p);
}

/* Store an appointment. */
void qstore(char *q)
{
  if(spos==MAX) {
    printf("list full\n");
    return;
  }
  p[spos]=q;
  spos++;
}

/* Retrieve an appointment. */
char *qretrieve()
{
  if(rpos==spos) {
    printf("No (more) appointments.\n");
    return NULL;
  }
  rpos++;
  return p[rpos-1];
}






listing 25-2a

Enter, List, Remove, Quit: E
enter appointment 1: Jon at 9 about the phone system
enter appointment 2: Ted at 10:30 - wants tjat raise...humm.
enter appointment 3: lunch with Mary and Tom at Harry's
enter appointment 4: <cr>
Enter, List, Remove, Quit: L
1. Jon at 9 about the phone system
2. Ted at 10:30 - wants tjat raise...humm.
3. lunch with Mary and Tom at Harry's
Enter, List, Remove, Quit: R
Jon at 9 about the phone system
Enter, List, Remove, Quit: L
2. Ted at 10:30 - wants tjat raise...humm.
3. lunch with Mary and Tom at Harry's
Enter, List, Remove, Quit: 





listing 25-3

void qstore(char *q)
{
  /* The queue is full if either spos is one less than rpos
     or if spos is at the end of the queue array and rpos
     is at the beginning.
  */
  if(spos+1==rpos || (spos+1==MAX && !rpos)) {
    printf("list full\n");
    return;
  }
  p[spos] = q;
  spos++;
  if(spos==MAX) spos=0; /* loop back */
}

char *qretrieve()
{
  if(rpos==MAX) rpos=0; /* loop back */
  if(rpos==spos) {
    printf("No events to perform.\n");
    return NULL;
  }
  rpos++;
  return p[rpos-1];
}






listing 25-4

/* A circular queue example using a keyboard buffer. */
#include "stdio.h"

#define MAX 80

char buf[MAX+1];
int spos=0;
int rpos=MAX;

void qstore(char);
char qretrieve();

main() 
{
  register char ch;
  int t;

  buf[80]=NULL;

  for(ch=' ',t=0; t<32000 && ch!=';'; ++t) {
    printf("%d", kbhit());
    if(kbhit()) {
      ch = getch();
      qstore(ch);
    }
    printf("%d ", t);
  } 

  while((ch=qretrieve())!=NULL) putchar(ch); /* display buf */
}

/* Store characters in the queue. */
void qstore(char q)
{
  if(spos+1==rpos || (spos+1==MAX && !rpos)) {
    printf("list full\n");
    return;
  }
  buf[spos] = q;
  spos++;
  if(spos==MAX) spos = 0; /* loop back */
}

/* Retrieve a character. */
char qretrieve()
{
  if(rpos==MAX) rpos=0; /* loop back */
  if(rpos==spos) {
    return NULL;
  }
  rpos++;
  return buf[rpos-1];
}






listing 25-5

int stack[MAX];
int tos=0;   /* top of stack */

/* Put an element on the stack. */
void push(int i)  
{

  if(tos>=MAX) {
    printf("stack full\n");
    return;
  }
  stack[tos] = i;
  tos++;
}

/* Retrieve the top element from the stack. */	
int pop()  
{
  tos--;
  if(tos<0) {
    printf("stack underflow\n");
    return HUGH_VAL;
  }
  return stack[tos];
}





listing 25-6

int *p;   /* will point to a region of free memory */
int *tos; /* points to top of stack */
int *bos; /* points to bottom of stack */

/* Store an element on the stack. */
void push(int i)  
{
  if(p>bos) {
    printf("stack full\n");
    return;
  }
  *p = i;
  p++;
}

/* Retrieve the top element from the stack. */
pop()   
{
  p--;
  if(p<tos) {
    printf("stack underflow\n");
    return 0;
  }
  return *p;
}





listing 25-7
/* A simple four-function calculator. */

#include "stdlib.h"
#define MAX 100

int *p;    /* will point to a region of free memory */
int *tos; /* points to top of stack */
int *bos; /* points to bottom of stack */
void push(int);

main() 
{
  int a,b;
  char s[80];

  p = (int *) malloc(MAX*sizeof(int));  /* get stack memory */
  if(!p) {
    printf("allocation failure\n");
    exit(1);
  }
  tos = p; 
  bos = p+MAX-1;

  printf("Four Function Calculator\n");

  do {
    printf(": ");
    gets(s);
    switch(*s) {
      case '+':
        a = pop();
        b = pop();
        printf("%d\n", a+b);
        push(a+b);
        break;
      case '-':
        a = pop();
        b = pop();
        printf("%d\n", b-a);
        push(b-a);
        break;
      case '*':
        a = pop();
        b = pop();
        printf("%d\n", b*a);
        push(b*a);
        break;
      case '/':
        a = pop();
        b = pop();
        if(a==0) {
          printf("divide by 0\n");
          break;
        }
        printf("%d\n", b/a);
        push(b/a);
        break;
      case '.': /* show  contents of top of stack */
        a = pop();
        push(a);
        printf("Current value on top of stack: %d\n", a);
        break;
      default:
        push(atoi(s));
    }
  } while(*s!='q');        
}

/* Put an element on the stack. */
void push(int i)  
{
  if(p>bos) {
    printf("stack full\n");
    return;
  }
  *p = i;
  p++;
}

/* Retrieve the top element from the stack. */
pop()   
{
  p--;
  if(p<tos) {
    printf("stack underflow\n");
    return 0;
  }
  return *p;
}






listing 25-8

Four Function Calculator
: 10<cr>
: 10<cr>
: +<cr>
20
: 5<cr>
: /<cr>
4
: .<cr>
Current value on top of stack: 4
: q<cr>





listing 25-9

struct address {
  char name[40];
  char street[40];
  char city[20];
  char state[3];
  char zip[10];
  struct address *next;
} info;





listing 25-10

void slstore(struct address *i)
struct address *i;
{
  static struct address *last=NULL; /* start with null link */

  if(!last) last = i; /* first item in list */
  else last->next = i;
  i->next = NULL;
  last = i;
}





listing 25-11

/* store in sorted order */
struct address *sls_store(struct address *i, /* new element to store */
			  struct address *top) /* start of list */
{
  static struct address *last=0; /* start with null link */
  struct address *old,*start;

  start=top;

  if(!last) {  /* first element in list */
    i->next = NULL;
    last = i;
    return i;
  }

  old = NULL;
  while(top) {
    if(strcmp(top->name,i->name)<0) {
      old = top;
      top = top->next;
    }
    else {
      if(old) {  /* goes in middle */
	old->next = i;
	i->next = top;	
	return start;
      }
      i->next = top; /* new first element */
      return 	i;
    }
  }
  last->next = i; /* put on end */
  i->next = NULL;
  last = i;
  return start;
}






listing 25-12

void display(struct address *top)
{
  while(top) {
    printf(top->name);
    top=top->next;
  }
}





listing 25-13

struct address *search(struct address *top, char *n)
{
  while(top) {
    if(!strcmp(n,top->name)) return top;
    top = top->next;
  }
  return NULL;  /* no match */
}
	




listing 25-14

struct address *sldelete(
  struct address *p, /* previous item */
  struct address *i, /* item to delete */
  struct address *top)  /* start of list */
{
  if(p) p->next = i->next;
  else  top = i->next;
		
  return top;
}





listing 25-15

struct address {
  char name[40];
  char street[40];
  char city[20];
  char state[3];
  char zip[10];
  struct address *next;
  struct address *prior;
} info;





listing 25-16

void dlstore(struct address *i)
{
  static struct address *last=NULL; /* start with null link */

  if(last==NULL) last = i; /* first item in list */
  else last->next = i;
  i->next = NULL;
  i->prior = last;
  last = i;
}





listing 25-17
/* Create a doubly linked list in sorted order.
   A pointer to the first element is returned because
   it is possible that a new element will be inserted
   at the start of the list.
*/
struct address *dls_store(struct address *i, /* new element */
                struct address *top) /* first element in list */
{
  struct address *old,*p;

  if(last==NULL) {  /* first element in list */
    i->next = NULL;
    i->prior = NULL;
    last = i;
    return i;
  }

  p = top; /* start at top of list */
  
  old = NULL;
  while(p) {
    if(strcmp(p->name, i->name)<0){
      old = p;
      p = p->next;
    }
    else {
      if(p->prior) {
        p->prior->next = i;
        i->next = p;
        i->prior = p->prior;
        p->prior = i;  
        return top;
      }
      i->next = p; /* new first element */
      i->prior = NULL;
      p->prior = i;
      return   i;
    }
  }
  old->next = i; /* put on end */
  i->next = NULL;
  i->prior = old;
  last = i;
  return start;
}





listing 25-18

struct address *dldelete(
  struct address *i, /* item to delete */
  struct address *top)  /* first item in list */
{
  if(i->prior) i->prior->next = i->next;
  else { /* new first item */
    top = i->next;
    /* if deleting only element in list skip */
      if(top) top->prior=0;
  }

  if(i->next) i->next->prior = i->prior;
  return top;
}





listing 25-19

#include "stdio.h"
#include "stdlib.h"

struct address {
  char name[30];
  char street[40];
  char city[20];
  char state[3];  
  char zip[10]; /* hold US and Canadian zips */
  struct address *next;  /* pointer to next entry */
  struct address *prior;  /* pointer to previous record */
} list_entry;

struct address *start;  /* pointer to first entry in list */
struct address *last;  /* pointer to last entry */

void enter(), display(), search(), save(), load(), list();
struct address *dls_store(struct address *, struct address *);

main()
{

  start=last=NULL;  /* zero length list */
  for(;;) {
    switch(menu_select()) {
      case 1: enter();
        break;
      case 2: delete();
        break;
      case 3: list();
        break;
      case 4: search(); /* find a street */
        break;
      case 5: save();  /* save list to disk */
        break;
      case 6: load();  /* read from disk */
        break;
      case 7: exit(0);
    }
  }
}

/* select an operation */
menu_select()
{
  char s[80];
  int c;

  printf("1. Enter a name\n");
  printf("2. Delete a name\n");
  printf("3. List the file\n");
  printf("4. Search\n");
  printf("5. Save the file\n");
  printf("6. Load the file\n");
  printf("7. Quit\n");
  do {
    printf("\nEnter your choice: ");
    gets(s);
    c = atoi(s);
  } while(c<0 || c>7);
  return c;
}

/* Enter names and addresses. */
void enter()
{
  struct address *info;

  for(;;) {
    info = (struct address *)malloc(sizeof(list_entry));
    if(!info) {
      printf("\nout of memory");
      return;
    }
  
    inputs("enter name: ", info->name,30);
    if(!info->name[0]) break;  /* stop entering */
    inputs("enter street: ", info->street,40);
    inputs("enter city: ", info->city,20);
    inputs("enter state: ", info->state,3);
    inputs("enter zip: ", info->zip,10);

    start = dls_store(info, start);
  } /* entry loop */
}

/* This function will input a string up to
   the length in count and will prevent
   the string from being overrun.  It will also
   display a prompting message. */
inputs(char *prompt, char *s, int count)
{
  char p[255];

  do {  
    printf(prompt);
    gets(p);
    if(strlen(p)>count) printf("\ntoo long\n");
  } while(strlen(p)>count);
  strcpy(s,p);
}

/* Create a doubly linked list in sorted order.
   A pointer to the first element is returned because
   it is possible that a new element will be inserted
   at the start of the list.
*/
struct address *dls_store(
  struct address *i,   /* new element */
  struct address *top  /* first element in list */
)
{
  struct address *old,*p;

  if(last==NULL) {  /* first element in list */
    i->next = NULL;
    i->prior = NULL;
    last = i;
    return i;
  }

  p = top; /* start at top of list */
  
  old = NULL;
  while(p) {
    if(strcmp(p->name, i->name)<0){
      old = p;
      p = p->next;
    }
    else {
      if(p->prior) {
        p->prior->next = i;
        i->next = p;
        i->prior = p->prior;
        p->prior = i;  
        return top;
      }
      i->next = p; /* new first element */
      i->prior = NULL;
      p->prior = i;
      return i;
    }
  }
  old->next = i; /* put on end */
  i->next = NULL;
  i->prior = old;
  last = i;
  return start;
}

/* Remove an element from the list. */
delete()
{
  struct address *info, *find();
  char s[80];

  printf("enter name: ");
  gets(s);
  info=find(s);
  if(info) { 
    if(start==info) {
      start=info->next;
      if(start) start->prior = NULL;
      else last = NULL;
    }
    else {
      info->prior->next = info->next;
      if(info!=last)
          info->next->prior = info->prior;
      else
        last = info->prior;
    }  
    free(info);  /* return memory to system */
  }
}

/* Find an address. */
struct address *find( char *name)
{
  struct address *info;

  info = start;
  while(info) {
    if(!strcmp(name, info->name)) return info;
    info = info->next;  /* get next address */
  }
  printf("name not found\n");
  return NULL;  /* not found */
}

/* Display the entire list. */
void list()
{
  struct address *info;

  info = start;
  while(info) {
    display(info);
    info = info->next;  /* get next address */
  }
  printf("\n\n");
}

/* This function actually prints the fields in each address. */
void display(struct address *info)
{
    printf("%s\n", info->name);
    printf("%s\n", info->street);
    printf("%s\n", info->city);
    printf("%s\n", info->state);
    printf("%s\n", info->zip);
    printf("\n\n");
}

/* Look for a name in the list. */
void search()
{
  char name[40];
  struct address *info, *find();

  printf("enter name to find: ");
  gets(name);
  if(!(info=find(name))) printf("not found\n");
  else display(info);
}

/* Save the file to disk. */
void save()
{
  struct address *info;
  
  FILE *fp;
  if((fp=fopen("mlist","wb"))==NULL) {
    printf("cannot open file\n");
    exit(1);
  }
  printf("\nsaving file\n");

  info = start;  
  while(info) {
    fwrite(info, sizeof(struct address),1,fp);
    info = info->next;  /* get next address */
  }
  fclose(fp);
}

/* Load the address file. */
void load()
{
  struct address *info, *temp=NULL;
  FILE *fp;

  if((fp=fopen("mlist","rb"))==NULL) {
    printf("cannot open file\n");
    exit(1);
  }

  while(start) {
    info = start->next;
    free(info);
    start = info;
  }

  printf("\nloading file\n");

  start = (struct address *) malloc(sizeof(struct address));
  if(!start) { 
    printf("out of memory\n");
    return;
  }
  info = start;
  while(!feof(fp)) {
    if(1!=fread(info,sizeof(struct address),1,fp)) break;
    /* get memory for next */
    info->next = (struct address *) malloc(sizeof(struct address));
    if(!info->next) { 
      printf("out of memory\n");
      return;
    }
    info->prior = temp;
    temp = info;
    info = info->next;
  }
  temp->next = NULL;  /* last entry */
  last = temp;
  
  start->prior = NULL;
  fclose(fp);
}






listing 25-20

struct tree *stree(
  struct tree *root,
  struct tree *r,
  char info)
{
  if(!r) {  
    r = (struct tree *) malloc(sizeof(struct tree));
    if(!r) {
      printf("out of memory\n");
      exit(0);
    }
    r->left = NULL;
    r->right = NULL;
    r->info = info; 
    if(!root) return r; /* first entry */
    if(info<root->info) root->left = r;
    else root->right = r;
    return r;
  }

  if(info<r->info) stree(r,r->left,info);
  else  
  if(info>r->info) stree(r,r->right,info);
}






listing 25-21

	/* call stree()  */
	if(!rt) rt=stree(rt,rt,info);
	else stree(rt,rt,info);





listing 25-22

void inorder(struct tree *root)
{
  if(!root) return;

  inorder(root->left);
  printf("%c ",root->info);
  inorder(root->right);
}





listing 25-23

void preorder(struct tree *root)
{
  if(!root) return;

  printf("%c ", root->info);
  preorder(root->left);
  preorder(root->right);
}

void postorder(struct tree *root)
{
  if(!root) return;

  postorder(root->left);
  postorder(root->right);
  printf("%c ", root->info);
}





listing 25-24

void print_tree(struct tree *r, int l)
{
  int i;

  if(r==NULL) return;

  print_tree(r->left, l+1);
  for(i=0; i<l; ++i) printf("   ");
  printf("%c\n", r->info);
  print_tree(r->right, l+1);
}





listing 25-25
#include "stdlib.h"
#include "stdio.h"

struct tree {
  char info;
  struct tree *left;
  struct tree *right;
};

struct tree *root;  /* first node in tree */
struct tree *stree(struct tree *,
                   struct tree *, char);
void print_tree(struct tree *, int);

main()  /* printtree program */
{
  char s[80];

  root = NULL;  /* initialize the root */

  do {
    printf("enter a letter: ");
    gets(s);
    if(!root) root = stree(root, root, *s);
    else stree(root, root, *s);
  } while(*s);

  print_tree(root, NULL);

}

struct tree *stree(
  struct tree *root,
  struct tree *r,
  char info)
{

  if(!r) {  
    r = (struct tree *) malloc(sizeof(struct tree));
    if(!r) {
      printf("out of memory\n");
      exit(0);
    }
    r->left = NULL;
    r->right = NULL;
    r->info = info; 
    if(!root) return r; /* first entry */
    if(info<root->info) root->left = r;
    else root->right = r;
    return r;
  }

  if(info<r->info) stree(r, r->left, info);
  else  
  if(info>r->info) stree(r, r->right, info);
}

void print_tree(struct tree *r, int l)
{
  int i;

  if(!r) return;

  print_tree(r->left, l+1);
  for(i=0; i<l; ++i) printf("   ");
  printf("%c\n", r->info);
  print_tree(r->right, l+1);
}





listing 25-26

struct tree *search_tree(struct tree *root, char key)
{
  if(!root) return root;  /* empty tree */
  while(root->info!=key) {
    if(key<root->info) root = root->left;
    else root = root->right;
    if(root==NULL) break;
  }
  return root;
}





listing 25-27

struct tree *dtree(struct tree *root, char key)
{
  struct tree *p,*p2;

  if(root->info==key) { /* delete root */
    /* this means an empty tree */
    if(root->left==root->right){
      free(root);
      return NULL;
    }
    /* or if one subtree is null */
    else if(root->left==NULL) {
      p = root->right;
      free(root);
      return p;
    }
    else if(root->right==NULL) {
      p = root->left;
      free(root);
      return p;
    }
    /* or both tree present */
    else {
      p2 = root->right;
      p = root->right;
      while(p->left) p = p->left;
      p->left = root->left;
      free(root); 
      return p2;
    }
  }
  if(root->info<key) root->right = dtree(root->right, key);
  else root->left = dtree(root->left, key);
  return root;
}




