/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 19-1

struct tm {
  int tm_sec;  /* seconds, 0-59 */
  int tm_min;  /* minutes, 0-59 */
  int tm_hour; /* hours, 0-23 */
  int tm_mday; /* day of the month, 1-31 */
  int tm_mon;  /* months since Jan, 0-11 */
  int tm_year; /* years from 1900 */
  int tm_wday; /* days since Sunday, 0-6 */
  int tm_yday; /* days since Jan 1, 0-365 */
  int tm_isdst /* Daylight Savings Time indicator */
}





listing 19-2

struct date {
  int da_year; /* year */
  char da_day; /* day of month */
  char da_mon; /* month, Jan=1 */
}

struct time {
  unsigned char ti_min;  /* minutes */
  unsigned char ti_hour; /* hours */
  unsigned char ti_hund; /* hundredths of seconds */
  unsigned char ti_sec;  /* seconds */
}





listing 19-3


/*
	Copyright (c) Borland International Inc. 1987
	All Rights Reserved.
*/


struct WORDREGS
	{
	unsigned int	ax, bx, cx, dx, si, di, cflag;
	};

struct BYTEREGS
	{
	unsigned char	al, ah, bl, bh, cl, ch, dl, dh;
	};

union	REGS	{
	struct	WORDREGS x;
	struct	BYTEREGS h;
	};






listing 19-4

struct	SREGS	{
  unsigned int	es;
  unsigned int	cs;
  unsigned int	ss;
  unsigned int	ds;
};




listing 19-5

#include "dos.h"

main()
{
  char buf[512];
  int sector, i, j;

  for(;;) {
    printf("Enter sector: ");
    scanf("%d", &sector);
    if(sector==-1) exit(0);
    absread(3, 1, sector, buf); /* read drive C */
    for(i=0, j=0; i<512; i++) {
      printf("%x ", buf[i]);
      if(!(i%16)) {
	for( ; j<i; j++) printf("%c", buf[j]);
        printf("\n");
      }
    }
  }
}





listing 19-6

#include "time.h"
#include "stddef.h"

main()
{
  struct tm *ptr;
  time_t lt;
  
  lt=time(NULL);
  ptr=localtime(&lt);
  printf(asctime(ptr));
}





listing 19-7

/* do raw keyboard reads */
#include "dos.h"

main()
{
  char ch;

  while((ch=bdos(1, 0, 0))!='q') ;
  /* ... */
}





listing 19-8

bioscom(0, 251, 0);





listing 19-9

#include "bios.h"

main()
{
  unsigned eq;

  eq = biosequip();
 
  eq >>= 6; /* shit bits 6 and 7 into lowest position */

  printf("number of disk drives: %d", (eq & 3) + 1);
}




listing 19-10

while(!bioscom(1)) rand();





listing 19-11

char p[]="hello";

while(*p) biosprint(0, *p++, 0);





listing 19-12

#include "bios.h"

main()
{
  printf("the current timer value is %ld", biostime(0,0));
}




listing 19-13
#include "dos.h"

main()
{
  struct country c;

  country(0, &c);

  printf(c.co_curr);
}





listing 19-14

asctime(localtime(time))





listing 19-15

#include "time.h"
#include "stddef.h"

main()
{
  time_t lt;
  
  lt = time(NULL);
  printf(ctime(&lt));
}





listing 19-16

#include "dos.h"

int break_handler();

main()
{
  register int i;

  ctrlbrk(break_handler);

  for(i=0; i<32000; i++)  printf("%d ", i);
}

break_handler()
{
  printf("this is the new break hander");
  return 0;
}
  




listing 19-17
#include "time.h"
#include "stddef.h"

main()
{
  time_t start,end;
  long unsigned int t;
  
  start = time(NULL);
  for(t=0; t<500000; t++) ;
  end = time(NULL);
  printf("loop required %f seconds\n", difftime(end, start));
}





listing 19-18

#include "dos.h"
#include "stdlib.h"

main()
{
  char far *ptr;

  ptr = (char far *) malloc(100);

  printf("segment:offset of ptr: %u %u", FP_SEG(ptr),
	  FP_OFF(ptr));
}





listing 19-19

#include "dos.h"

main()
{
  geninterrupt(5); /* print screen function */
}





listing 19-20

printf("The current cbrk setting is %d", getcbrk());





listing 19-21

#include "time.h"
#include "stddef.h"
#include "dos.h"

main()
{
  time_t t;
  struct time dos_time;
  struct date dos_date;
  struct tm *local;

  getdate(&dos_date);
  gettime(&dos_time);

  t = dostounix(&dos_date, &dos_time);
  local = localtime(&t);
  printf("time and date: %s\n", asctime(local));
}





listing 19-22

#include "dos.h"

main()
{
  struct dfree p;

  getdfree(3, &p); /* drive C */

  printf("Number of free sectors is %d.", p.df_avail);
}




listing 19-23

#include "dos.h"

main()
{
  long total;
  struct fatinfo p;

  getfat(0, &p);

  total = (long) p.fi_sclus * (long) p.fi_nclus * (long) p.fi_bysec;

  printf("total storage capacity: %ld.", total);
}





listing 19-24

#include "io.h"
#include "dos.h"
#include "fcntl.h"

main()
{
  struct ftime p;
  int fd;

  if((fd=open("TEST.TST", O_RDONLY))==-1) {
    printf("cannot open file");
   exit(1);
  }

  getftime(fd, &p);

  printf("%d", p.ft_year + 1980);
  
}





listing 19-25

void interrupt (*p)(void);

p = getvect(5);





listing 19-26

#include "dos.h"

main()
{
  printf("The verify flag is set to %d.", getverify());
}





listing 19-27
#include "time.h"
#include "stddef.h"

/* print local and GM time */
main()
{
  struct tm *local, *gm;
  time_t t;
  
  t = time(NULL);
  local = localtime(&t);
  printf("Local time and date: %s", asctime(local));
  gm = gmtime(&t);
  printf("Greenwich mean time and date: %s", asctime(gm));
}





listing 19-28

unsigned int i;

i = inport(1);





listing 19-29
#include "dos.h"

/* Set the video mode */
set_mode(mode)
char mode;
{
  union REGS in, out;

  in.h.al = mode;
  in.h.ah = 0;  /* set mode function number */

  int86(0x10, &in, &out);
}




listing 19-30

#include "dos.h"

main()
{
  union REGS in, out;

  in.h.ah=0x2c;  /* get time function number */
  intdos(&in, &out);
  printf("time is %.2d:%.2d:%.2d", out.h.ch, out.h.cl, out.h.dh);
}






listing 19-31

#include "dos.h"

main()
{
  struct REGPACK r;

  intr(5, &r);
}




listing 19-32
#include "time.h"
#include "stddef.h"

/* print local and Greenwich mean time */
main()
{
  struct tm *local, *gm;
  time_t t;
  
  t = time(NULL);
  local = localtime(&t);
  printf("Local time and date: %s", asctime(local));
  gm = gmtime(&t);
  printf("Greenwich mean time and date: %s", asctime(gm));
}





listing 19-33

void far *p;

p = MK_FP(16, 101);





listing 19-34

outport(0x10,  0xFF);





listing 19-35

#include "dos.h"

main()
{
  printf("%d", peekb(0, 0x0100));
}





listing 19-36

struct time t;

t.ti_hour = 10;
t.ti_min  = 10;
t.ti_sec  = 10;
t.ti_hund = 0;

settime(&t);





listing 19-37

char far *p;

p = MK_FP(0xA000, 0)
 
setdta(p);





listing 19-38

#include "dos.h"

main()
{
  printf("Turning the verify flag on.", setverify(1));
}





listing 19-39

#include "dos.h"

main()
{
  printf("hello");

  sleep(10);

  printf(" there");
}




listing 19-40

#include "time.h"
#include "stddef.h"

main()
{
  struct tm *ptr;
  time_t lt;
  
  lt = time(NULL);
  ptr = localtime(&lt);
  printf(asctime(ptr));
}





listing 19-41

struct time t;
struct date d;

unixtodos(timeandday, &d, &t)




