/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 16-1

#include "io.h"
main()
{
  if(!access("TEST.TST", 00)) 
    printf("file present");
  else printf("file not found");
}




listing 16-2

if(_chmod("TEST.TST", 1, FA_RDONLY)==FA_RDONLY)
  printf("file set to read-only mode");





listing 16-3

if(!chmod("TEST.TST", S_IREAD | S_IWRITE))
  printf("file set to read/write access");





listing 16-4
#include "stdio.h"

main(argc,argv)  /* copy one file to another */
int argc;
char *argv[];
{
  FILE *in, *out;
  char ch;

  if(argc!=3) {
    printf("You forgot to enter a filename\n");
    exit(0);
  }

  if((in=fopen(argv[1],"rb")) == NULL) {
    printf("cannot open file\n");
    exit(0);
  }
  if((out=fopen(argv[2],"wb")) == NULL) {
    printf("cannot open file\n");
    exit(0);
  }

  while(!feof(in)) {
    ch = getc(in);
    if(ferror(in)) {
      printf("read error");
      clearerr(in);
    } else {
      putc(ch, out);
      if(ferror(out)) {
        printf("write error");
        clearerr(out);
      }
    }
  }
  fclose(in);
  fclose(out);

}





listing 16-5

#include "fcntl.h"
#include "sys\stat.h"

#include "io.h"

main(argc,argv)
int argc;
char *argv[];
{
  int fd;

  if((fd=open(argv[1],O_RDONLY))==-1) {
    printf("cannot open file");
    exit(1);
  }

  printf("file is existent\n");

  if(close(fd)) printf("error in closing file\n");
}





listing 16-6

#include "io.h"

main()
{
  int fd;

  if((fd=creat("test",S_WRITE))==-1) {
    printf("cannot open file\n");
    exit(1);
  }
.
.
.





listing 16-7

 FILE *fp, *fp2;
 .
 .
 .
 fp2 = dup(fp);





listing 16-8

#include "io.h"
#include "fcntl.h"

main(argc,argv)
int argc;
char *argv[];
{
  int fd;
  char ch;

  if((fd=open(argv[1],O_RDWR))==-1) {
    printf("cannot open file\n");
    exit(1);
  }

  while(!eof(fd)) {
    read(fd, &ch, 1);  /* read one char at a time */
    printf("%c", ch);
  }
  
  close(fd);
}





listing 16-9

#include "stdio.h"
    
main()
{
  FILE *fp;

  if((fp=fopen("test","rb"))==NULL) {
    printf("cannot open file\n");
    exit(1);
  }
.
.
.
  if(fclose(fp)) printf("file close error\n");
}





listing 16-10

/* 
   Assume that fp has been opened as a binary file
   for read operations.
*/

while(!feof(fp)) getc(fp);





listing 16-11

/*
  Assume that fp points to a stream opened for write
  operations.
*/

while(!done) {
  putc(info,fp);
  if(ferror(fp)) {
    printf("file error\n");
    exit(1);
  }
.
.
.
}




listing 16-12

/*
  Assume that fp is associated with an output file.
*/

 .
 .
 .
fwrite(buf,sizeof(data_type),1,fp);
fflush(fp);
 .
 .
 .





listing 16-13

#include "stdio.h"

main(argc,argv)
int argc;
char *argv[];
{
  FILE *fp;
  char ch;

  if((fp=fopen(argv[1],"r"))==NULL) {
    printf("cannot open file\n");
    exit(1);
  }

  while((ch=fgetc(fp))!=EOF) {
    printf("%c",ch);
  }
  
  fclose(fp);
}





listing 16-14

#include "stdio.h"

main(argc,argv)
int argc;
char *argv[];
{
  FILE *fp;
  char str[128];

  if((fp=fopen(argv[1],"r"))==NULL) {
    printf("cannot open file\n");
    exit(1);
  }

  while(!feof(fp)) {
    if(fgets(str,126,fp)) printf("%s",str);
  }
  
  fclose(fp);
}





listing 16-15

printf("The file is %ld bytes long.", filelength(fd));





listing 16-16

FILE *stream;
int fd;

if(!(stream=fopen("TEST", "r"))) {
  printf("cannot open TEST file");
  exit(1);
}

fd = fileno(stream);





listing 16-17

  FILE *fp;

  if (!(fp = fopen("test","w"))) {
    printf("cannot open file\n");
    exit(1);
  }





listing 16-18

FILE *fp;

if(!(fp=fopen("test","r+"))) {
  printf("cannot open file\n");
  exit(1);
}





listing 16-19

#include "stdio.h"
    
main()
{
  FILE *fp;

  if(!(fp=fopen("test","wb"))) {
    printf("cannot open file\n");
    exit(1);
  }

  fprintf(fp, "this is a test %d %f", 10, 20.01);

  fclose(fp);
}





listing 16-20

write_string(char *str, FILE *fp)
{
  while(*str) if(!ferror(fp)) fputc(*str++, fp);
}





listing 16-21

write_string(char *str)
{
  while(*str) if(!ferror(fp)) fputchar(*str++);
}





listing 16-22

fputs("this is a test",fp);





listing 16-23
#include "stdio.h"

main()
{
  FILE *fp;
  float bal[10];

  if(!(fp=fopen("test","rb"))) {
    printf("cannot open file\n");
    exit(1);
  }

  if(fread(bal, sizeof(float), 10, fp)!=10) {
     if(feof(fp)) printf("premature end of file");
     else printf("file read error");
  }

  fclose(fp);
}





listing 16-24

#include "stdio.h"

main()
{
  FILE *fp;
  char str[128];

  printf("This will display on the screen\n");

  if(!(fp=freopen("OUT","w",stdout))) {
    printf("cannot open file\n");
    exit(1);
  }

  printf("this will be written to the file OUT");
  
  fclose(fp);
}





listing 16-25

char str[80];
float f;

fscanf(fp, "%s%f", str, &f);





listing 8-22
  struct addr {
    char name[40];
    char street[40];
    char city[40];
    char state[3];
    char zip[10];
  } info;

  find(long client_num)
  {
    FILE *fp;

    if(!(fp=fopen("mail","rb"))) {
      printf("cannot open file\n");
      exit(1);
    }

    /* find the proper structure */
    fseek(fp, client_num*sizeof(struct addr), 0);

    /* read the data into memory */
    fread(&info, sizeof(struct addr), 1, fp);
   
    fclose(fp);
  }





listing 16-26

long i;

if((i=ftell(fp))==-1L) printf("A file error has occurred\n");





listing 16-27

#include "stdio.h"

main()
{
  FILE *fp;
  float f=12.23;

  if(!(fp=fopen("test","wb"))) {
    printf("cannot open file\n");
    exit(1);
  }

  fwrite(&f, sizeof(float), 1, fp);

  fclose(fp);
}





listing 16-28

#include "stdio.h"

main(int argc, char *argv[])
{
  FILE *fp;
  char ch;

  if(!(fp=fopen(argv[1],"r"))) {
    printf("cannot open file\n");
    exit(1);
  }

  while((ch=getc(fp))!=EOF) {
    printf("%c", ch);
  }
  
  fclose(fp);
}





listing 16-29

do {
  printf("1: check spelling\n");
  printf("2: correct spelling\n");
  printf("3: lookup a word in the dictionary\n");
  printf("4: quit\n");
 
  printf("\nEnter your selection: ");
  choice = getch();
} while(!strchr("1234", choice);





listing 16-30

#include "stdio.h"

main()
{
  char s[256], *p;

  p=s;

  while((*p++=getchar())!='\n') ;
  *p = '\0';  /* add null terminator */
  printf(s);
}





listing 16-31

#include "stdio.h"

main()
{
  FILE *fp;
  char fname[128];

  printf("Enter filename: ");
  gets(fname);

  if(!(fp=fopen(fname,"r"))) {
    printf("cannot open file\n");
    exit(1);
  }

.
.
.
  
  fclose(fp);
}





listing 16-32

#include "stdio.h"

main()
{
  FILE *fp;
  int sum = 0;

  if(!(fp=fopen("inttest","rb")) {
    printf("cannot open file\n");
    exit(1);
  }

  while(!feof(fp)) 
    sum = getw(fp)+sum;

  printf("the sum is %d",sum);
  
  fclose(fp);
}





listing 16-33

if(isatty(fd)) printf("is a character device");
else printf("is not a character device");





listing 16-34

lock(fd, 0, 128);





listing 16-35

#include "stdio.h"
#include "fcntl.h"
#include "sys\stat.h"

#define BUF_SIZE  128

long int lseek();

/* read buffers using lseek() */
main(int argc, char *argv[])  
{
  char buf[BUF_SIZE+1], s[10];
  int fd, sector;

  buf[BUF_SIZE+1]='\0'; /* null terminate buffer for printf */
  if((fd=open(argv[1], O_RDONLY))==-1) { /* open for write */
    printf("cannot open file\n");
    exit(0);
  }
  do {
    printf("buffer: ");
    gets(s);

    sector = atoi(s); /* get the sector to read */

    if(lseek(fd, (long)sector*BUF_SIZE,0)==-1L)
      printf("seek error\n");

    if(read(fd, buf, BUF_SIZE)==0) {
      printf("sector out of range\n");
    }
    else
      printf(buf);
  } while(sector>0);
  close(fd);
}





listing 16-36


  if((fd=open(filename, mode)) == -1)  {
    printf("cannot open file\n");
    exit(1);
  }





listing 16-37
#include "stdio.h"
#include "math.h"

extern int errno;

main()
{
   /* this will generate a domain error */
   asin(10.0);
   if(errno==EDOM) perror("Program Error Test");
}





listing 16-38

  printf("Hi %c %d %s",'c',10,"there!");





listing 16-39

int i;

printf("this is a test%n",&i);
printf("%d",i);





listing 16-40

#include "stdio.h"

main()
{
  /* This prints "this is a test" left justified 
     in 20 character field.
  */
  printf("%-20s", "this is a test");

  /* This prints a float with 3 decimal places in a 10
     character field.  The output will be "    12.234".
  */
  printf("%10.3f", 12.234657);
}
	




listing 16-41

for(; *str; str++) putc(*str, fp);





listing 16-42

for(; *str; str++) putchar(*str);





listing 16-43
#include "stdio.h"

main()
{
   char str[80];

   strcpy(str, "this is an example");

   puts(str);
}





listing 16-44

putw(100, fp);





listing 16-45

#include "stdio.h"
#include "io.h"
#include "fcntl.h"

main()
{
  int fd;
  char buffer[100];

  if((fd=open("TEST.TST", O_RDONLY))==-1) {
    printf("cannot open file\n");
    exit(1);
  }

  if(read(fd, buffer, 100)!=100) 
    printf("Possible read error.");

}





listing 16-46

#include "stdio.h"

main(int argc, char *argv[])
{
  if(remove(argv[1])==-1) printf("remove error");
}





listing 16-47

#include "stdio.h"

main(int argc, char *argv[])
{
  if(rename(argv[1], argv[2])!=0) printf("rename error");
}





listing 16-48

re_read(FILE *fp)
{
   /* read once */
   while(!feof(fp)) putchar(getc(fp));

   rewind(fp);

   /* read twice */
   while(!feof(fp)) putchar(getc(fp));
}





listing 16-49

  scanf("%d",&count);





listing 16-50

  scanf("%s",address);





listing 16-51

scanf("%d%d",&r,&c);'





listing 16-52

scanf("%d%*c%d",&x,&y);





listing 16-53

  scanf("%20s",address);





listing 16-54

  scanf("%s", str);





listing 16-55

  scanf("%c%c%c", &a, &b, &c);





listing 16-56

  scanf("%st%s", &x, &y);





listing 16-57

  scanf("%s ", name);





listing 16-58

char str[80];
int i;

/* read a string and an integer */
scanf("%s%d", str, &i);

/* read up to 79 chars into str */
scanf("%79s", str);

/* skip the integer between the two strings */
scanf("%s%*d%s", str, &i, str);





listing 16-59

setmode(fd, O_TEXT)





listing 16-60

char str[80];

sprintf(str,"%s %d %c","one",2,'3');





listing 16-61
#include "stdio.h"

main()
{
  char str[80];
  int i;

  sscanf("hello 1 2 3 4 5","%s%d",str,&i);
  printf("%s %d",str,i);
}





listing 16-62

int pos;

 .
 .
 .
pos = tell(fd);
printf("Position indicator is %d bytes from the start", pos);





listing 16-63

#include "stdio.h"

main()
{
  char name[40];
  int i;
 
  for(i=0; i<3; i++) {
    tmpnam(name);
    printf("%s ", name);
  }
}





listing 16-64

FILE *temp;

if(!(temp=tmpfile())) {
  printf("cannot open temporary work file\n");
  exit(1);
}
.




listing 16-65
read_word(FILE *fp, char *token)
{

  while(isalpha(*token=getc(fp))) token++;

  ungetc(fp, *token);
}





listing 16-66

#include "dos.h"

main(int argc, char *argv[])
{
  if(unlink(argv[1])==-1) printf("cannot remove file");
}






listing 16-67

#include "stdio.h"
#include "stdarg.h"


main()
{
  print_message("cannot open file %s","test");
}

print_message( char *format, ...)
{
  va_list ptr; /* get an arg ptr */

  /* initialize ptr to point to the first argument after the
     format string  
  */
  va_start(ptr, format);

  /* print out message */
  vprintf(format, ptr);
  va_end(ptr);
}






listing 16-68

#include "stdio.h"
#include "io.h"
#nclude "fcntl.h"

main()
{
  int fd;
  char buffer[100];

  if((fd=open("test", O_WRONLY))==-1) {
    printf("cannot open file\n");
    exit(1);
  }

  gets(buffer);

  if(write(fd, buffer, 100)!=100) printf("write error");
  fclose(fp);

}




