/*
The programs contained herein are adapted from 

	Turbo C: The Complete Reference

by Herbert Schildt published by Osborne/McGraw-Hil, Copyright
1988, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/

listing 11-1

window(10, 10, 60, 15);
gotoxy(2, 3);
cprintf("at location 2, 3");





listing 11-2

/* A text window demonstration program */
#include "conio.h"

void border(int, int, int, int);

main()
{
  clrscr();
 
  /* draw a border around the screen for perspective */
  border(1, 1, 79, 25);

  /* create first window */
  window(3, 2, 40, 9);
  border(3, 2, 40, 9);
  gotoxy(3, 2);
  cprintf("first window");

  /* create a second window */
  window(30, 10, 60, 18);
  border(30, 10, 60, 18);
  gotoxy(3, 2);
  cprintf("second window");
  gotoxy(5, 4);
  cprintf("hello");

  getche();
}

/* Draws a border around a text window. */
void border(int startx, int starty, int endx, int endy)
{
  register int i;

  gotoxy(1, 1);
  for(i=0; i<=endx-startx; i++)
    putch('-');

  gotoxy(1, endy-starty);
  for(i=0; i<=endx-startx; i++)
    putch('-');

  for(i=2; i<endy-starty; i++) {
    gotoxy(1, i);
    putch('|');
    gotoxy(endx-startx+1, i);
    putch('|');
  }
}




listing 11-3

textcolor(GREEN | BLINK)





listing 11-4

textattr(RED | BLINK | BLUE*16);





listing 11-5

struct text_info screen_status;

gettextinfo(&screen_status);





listing 11-6

#include "conio.h"

main()
{
  register int i, j;

  textmode(C80); /* 80 column text mode */

  clrscr();

  /* demonstrate the gotoxy() function */
  for(i=1, j=1; j<24; i++, j++) {
    gotoxy(i, j);
    cprintf("X");
  }
  for(; j>0; i++, j--) {
    gotoxy(i, j);
    cprintf("X");
  }

  /* examples of different foreground and background colors */
  textbackground(LIGHTBLUE);
  textcolor(RED);
  gotoxy(40, 12);
  cprintf("This is red with a light blue background.");

  gotoxy(45, 15);
  textcolor(GREEN | BLINK);
  textbackground(BLACK);
  cprintf("This is blinking green on black.");

  getch();

  /* an example of movetext() */
  /* this moves the "inverted peak" of the X's to the 
     top of the screen
  */
  movetext(20, 20, 28, 24, 20, 1);
  getch();
  textmode(LAST);
}





listing 11-7
#include "graphics.h"
 .
 .  
 .
int driver, mode;

driver = CGA;
mode = CGAC0;

initgraph(&driver, &mode, "");





listing 11-8

setpalette(0, GREEN);





listing 11-9

setpalette(5, EGA_CYAN);





listing 11-10

/* Points, lines, circles, and fills demostration program. */
#include "graphics.h"
#include "conio.h"

void border(void), box(int, int, int, int, int);

main()
{
  int driver, mode;

  register int i;

  driver = VGA; /* autodetect */
  mode = VGAMED;
  initgraph(&driver, &mode, "");

  border();

  setcolor(1);
  line(0, 0, 639, 349);

  box(100, 100, 300, 200, 1);

  setcolor(2);
  floodfill(110, 110, 1); /* fill part of a box */

  setcolor(1);
  line(50, 200, 400, 125);

  /* some points */
  for(i=0; i<640; i+=10) putpixel(i, 175, 5);

  /* line some circles */
  circle(50, 50, 35);
  circle(320, 175, 100);
  circle(500, 250, 90);
  circle(100, 100, 200);

  setfillstyle(SOLID_FILL, GREEN);
  floodfill(500, 250, 1); /* fill part of a circle */

  getch(); /* wait until keypress */
  restorecrtmode();
}

/* Draw a border around the screen for perspective. */
void border()
{
  line(0, 0, 639, 0);
  line(0, 0, 0, 349);
  line(0, 349, 639, 349);
  line(639, 0, 639, 349);
}

/* Draw a box given the coordinates of its two corners. */
void box(int startx, int starty, int endx, int endy,
         int color)
{
  setcolor(color);

  line(startx, starty, startx, endy);
  line(startx, starty, endx, starty);
  line(endx, starty, endx, endy);
  line(endx, endy, startx, endy);
}






listing 11-11

/* Demonstrate some different text fonts and sizes. */

#include "graphics.h"
#include "conio.h"

main()
{
  int driver, mode;
  register int i;

  driver = VGA; /* autodetect */
  mode = VGAMED;
  initgraph(&driver, &mode, "");

  outtext("Normal ");

  /* Gothic font, twice normal size */
  settextstyle(GOTHIC_FONT, HORIZ_DIR, 2); 
  outtext("Gothic ");

  /* Triplex font, twice normal size */
  settextstyle(TRIPLEX_FONT, HORIZ_DIR, 2); 
  outtext("Triplex ");

  /* Sans serrif font 7, times normal size*/
  settextstyle(TRIPLEX_FONT, HORIZ_DIR, 7); 
  outtext("Sans serif");
  
  getch();
  restorecrtmode();
}




listing 11-12


/* This program demonstrates how a graphics image can be
   moved using getimage(), imagesize(), and putimage().
*/
#include "conio.h"
#include "graphics.h"
#include "stdlib.h"

void box(int, int, int, int, int);

main()
{
  int driver, mode;
  unsigned size;
  void *buf;

  driver = VGA; /* autodetect */
  mode = VGAMED;
  initgraph(&driver, &mode, "");

  box(20, 20, 200, 200, 15);
  
  setcolor(RED);
  line(20, 20, 200, 200);
  setcolor(GREEN);
  line(20, 200, 200, 20);
  getch();

  /* move the image */

  /* first, get the image's size */  
  size = imagesize(20, 20, 200, 200);
  if(size !=-1) { /* alloc memory for the image */
    buf = malloc(size);  
    if(buf) {
      getimage(20, 20, 200, 200, buf);
      putimage(100, 100, buf, COPY_PUT);
      putimage(300, 50, buf, COPY_PUT);
    }
  }
  outtext("press a key");
  getch();
  restorecrtmode();
}

/* Draw a box given the coordinates of its two corners. */
void box(int startx, int starty, int endx, int endy,
         int color)
{
  setcolor(color);

  line(startx, starty, startx, endy);
  line(startx, starty, endx, starty);
  line(endx, starty, endx, endy);
  line(endx, endy, startx, endy);
}





listing 11-13

/* This program illustrates the use of setviewport(). */

#include "conio.h"
#include "graphics.h"

void box(int, int, int, int, int);

main()
{
  int driver, mode;

  driver = VGA; /* autodetect */
  mode = VGAMED;
  initgraph(&driver, &mode, "");

  /* frame the screen for perspective */
  box(0, 0, 639, 349, WHITE);

  setviewport(20, 20, 200, 200, 1);
  box(0, 0, 179, 179, RED);

  /* Attempt to line a line past the edge of the
     viewport. 
  */
  
  setcolor(WHITE);
  line(0, 100, 400, 100);

  outtextxy(20, 10, "press a key");
  getch();
  restorecrtmode();
}

/* Draw a box given the coordinates of its two corners. */
void box(int startx, int starty, int endx, int endy,
         int color)
{
  setcolor(color);

  line(startx, starty, startx, endy);
  line(startx, starty, endx, starty);
  line(endx, starty, endx, endy);
  line(endx, endy, startx, endy);
}




