/* TC-08.C */
/* Demonstrates surface mapping of a 3d cylider.  A two color design
	is mapped onto a can */

/* ----------------------------------------------------------------------- */
/* INCLUDE FILES */
#include <process.h>
#include <bios.h>
#include <stdio.h>
#include <graphics.h>
#include <math.h>

/* DECLARATIONS */

float		x=0.0,y=0.0,z=0.0;  											/* world coordinates */
float		x1=0.0,x2=0.0,x3=0.0;										/* polygon vertices */
float		y01=0.0,y2=0.0,y3=0.0;										/* polygon vertices */
float		z1=0.0,z2=0.0,z3=0.0;										/* polygon vertices */
float		sx1=0.0,sx2=0.0,sx3=0.0,sx4=0.0,sx5=0.0;				/* display coordinaes */
float		sy1=0.0,sy2=0.0,sy3=0.0,sy4=0.0,sy5=0.0;				/* display coordinates */
float		sx=0.0,sy=0.0;													/* output of 3d perspective formulas */
float		xa=0.0,ya=0.0,za=0.0;										/* temporary values in 3d formulas */
float		d=1200.0;														/* angular perspective value */
double	r1=5.89778;														/* yaw angle in radians */
double	r2=6.28319;														/* roll angle in radians */
double	r3=.58539;														/* pitch angle in radians */
double	sr1=0.0,sr2=0.0,sr3=0.0;									/* sine rotation factors */
double	cr1=0.0,cr2=0.0,cr3=0.0;									/* cosine rotation factors */
float		mx=0.0,my=0.0,mz=-350.0;									/* viewpoint position */
int		maxx=639,minx=0,maxy=199,miny=0;							/* scaling viewport */
float		screen_x=639,screen_y=199;									/* dimensions of screen mode */
int		C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,		/* color varariables */
			C9=9,C10=10,C11=11,C12=12,C13=13,C14=14,C15=15,
			mode_flag=0;
float		rx=0.0,ry=0.0;													/* scaling values used in mapping routine */
int		t=0,t1=0,t2=0;													/* loop counters */
int		p1=0;																/* array indexer */
int		key_matte_clr=6;												/* exclusive key matte color */
int		edge_clr=7;														/* used to draw edges on models */
int		solid_clr=0;													/* used to fill surfaces on solid models */
int		design_clr=1;													/* used to draw the design on the model */
float		x_res,y_res;													/* used for 2d mappinf from 640*480 template */
float		sp=0.0;															/* visibility factor in hidden surface routine */
float		sp1=0.0,sp2=0.0,sp3=0.0;									/* temporary values of sp */

int		q=0,q1=0,q2=0;													/* cylinder surface and vertex counters */
double	r4=6.28319,r5=6.28319;										/* spherical coordinate angles */
int		polary[4][2];  /* used in my 3d solid polygon draw routine */
float		B11[36][3];														/* 36 sets of xyz view coordinates, near end */
float		B12[36][3];														/* 36 sets of xyz view coordinates, far end */
float		B21[36][2];														/* 36 sets of sx,sy display coordinates, near end */
float		B22[36][2];														/* 36 sets of sx,sy display coordinates, far end */
double	sr4=0.0,cr4=0.0,sr5=0.0,cr5=0.0;							/* rotation factor */

/* declare global subroutines */
void keyboard(void);void quit_pgm(void);void calc_3d(void);
void rotation(void);void window(void);void graphics_setup(void);
void coords(void);void draw_poly(void);void notice (int x,int y);
void visibility_test(void);
void cyl_coords(void);void draw_surface(void);

/* ----------------------------------------------------------------------- */
main(){
graphics_setup();
setviewport(0,0,maxx,maxy,1);
key_matte_clr=C6;
edge_clr=C7;solid_clr=C5;												/* define modeling colors */
rotation();

/* calculate coordinates for near end of cylinder */
r4=0;r5=0;
for (t=0;t<=35;t++){
	x=30;cyl_coords();z=z+60;calc_3d();window();
	B11[t][0]=x;B11[t][1]=y;B11[t][2]=z;
	B21[t][0]=sx;B21[t][1]=sy;
	keyboard();
	r5=r5+.17453;}

/* calculate coordinates for far end of cylinder */
r4=0;r5=0;
for (t=0;t<=35;t++){
	x=30;cyl_coords();z=z-60;calc_3d();window();
	B12[t][0]=x;B12[t][1]=y;B12[t][2]=z;
	B22[t][0]=sx;B22[t][1]=sy;
	keyboard();
	r5=r5+.17453;}

/* draw surfaces of 3d cylinder */
solid_clr=C5;
for (q1=0;q1<=35;q1++){
	q2=q1+1;if (q2>35) q2=0;
	draw_surface();keyboard();}

/* draw near end of 3d cylinder */
x1=B11[0][0];y01=B11[0][1];z1=B11[0][2];
x2=B11[25][0];y2=B11[25][1];z2=B11[25][2];
x3=B11[11][0];y3=B11[11][1];z3=B11[11][2];
visibility_test();if (sp>0) goto draw_the_design;
setcolor (key_matte_clr);setfillstyle(SOLID_FILL,key_matte_clr);
setlinestyle(USERBIT_LINE,0xffff,NORM_WIDTH);
for (q1=0;q1<=35;q1++){
	q2=q1+1;if (q2>35) q2=0;
	sx1=B21[q1][0];sy1=B21[q1][1];
	sx2=B21[q2][0];sy2=B21[q2][1];
	moveto(sx1,sy1);lineto(sx2,sy2);}
solid_clr=C13;
x=0.0;y=0.0;z=60.0;calc_3d();window();floodfill(sx,sy,key_matte_clr);
keyboard();
edge_clr=C13;
setcolor(edge_clr);
solid_clr=C13;
for (q1=0;q1<=35;q1++){
	q2=q1+1;if (q2>35) q2=0;
	sx1=B21[q1][0];sy1=B21[q1][1];
	sx2=B21[q2][0];sy2=B21[q2][1];
	moveto(sx1,sy1);lineto(sx2,sy2);}
x=0.0;y=0.0;z=60.0;calc_3d();window();
setfillstyle(SOLID_FILL,solid_clr);floodfill(sx,sy,edge_clr);

/* draw design on cylinder */
draw_the_design:
r4=0;r5=1.5;
design_clr=C1;																/* prepare to draw lower graphic */
setcolor(design_clr);
x=30;cyl_coords();z=z+20;calc_3d();window();moveto(sx,sy);
r5=r5+.08727;
for (t=0;t<=21;t++){
	x=30;cyl_coords();z=z+20;calc_3d();window();
	lineto(sx,sy);
	keyboard();
	r5=r5+.08727;}

r5=r5-.08727;																/* negate the final loop increment */
x=30;cyl_coords();z=z-40;calc_3d();window();lineto(sx,sy);
r5=r5-.08727;
for (t=0;t<=21;t++){
	x=30;cyl_coords();z=z-40;calc_3d();window();
	lineto(sx,sy);
	keyboard();
	r5=r5-.08727;}

r5=r5+.08727;																/* negate the final loop decrement */
x=30;cyl_coords();z=z+20;calc_3d();window();lineto(sx,sy);
r5=r5+(10*.08727);
x=30;cyl_coords();z=z-10;calc_3d();window();
setfillstyle(SOLID_FILL,design_clr);
floodfill(sx,sy,design_clr);

r4=0;r5=1.5;
design_clr=C4;																/* prepare to draw lower graphic */
setcolor(design_clr);
x=30;cyl_coords();z=z+30;calc_3d();window();moveto(sx,sy);
r5=r5+.08727;
for (t=0;t<=21;t++){
	x=30;cyl_coords();z=z+30;calc_3d();window();
	lineto(sx,sy);
	keyboard();
	r5=r5+.08727;}

r5=r5-.08727;																/* negate the final loop increment */
x=30;cyl_coords();z=z+50;calc_3d();window();lineto(sx,sy);
r5=r5-.08727;
for (t=0;t<=21;t++){
	x=30;cyl_coords();z=z+50;calc_3d();window();
	lineto(sx,sy);
	keyboard();
	r5=r5-.08727;}

r5=r5+.08727;																/* negate the final loop decrement */
x=30;cyl_coords();z=z+30;calc_3d();window();lineto(sx,sy);
r5=r5+(10*.08727);
x=30;cyl_coords();z=z+40;calc_3d();window();
setfillstyle(SOLID_FILL,design_clr);
floodfill(sx,sy,design_clr);

setcolor(C7);notice(0,0);
for (t1=1;t1!=2;) keyboard();
quit_pgm();}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CALCULATE WORLD COORDINATES FOR cylinder */

void cyl_coords(void){
sr4=sin(r4);cr4=cos(r4);sr5=sin(r5);
cr5=cos(r5);x1=sr5*x;y=cr5*x;x=cr4*x1;z=sr4*x1;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: DRAW 4 SIDED POLYGON SURFACE ON SPHERE */

void draw_surface(void){
x1=B11[q1][0];y01=B11[q1][1];z1=B11[q1][2];
x2=B11[q2][0];y2=B11[q2][1];z2=B11[q2][2];
x3=B12[q2][0];y3=B12[q2][1];z3=B12[q2][2];
visibility_test();if (sp>0) return;
sx1=B21[q1][0];sy1=B21[q1][1];
sx2=B21[q2][0];sy2=B21[q2][1];
sx3=B22[q2][0];sy3=B22[q2][1];
sx4=B22[q1][0];sy4=B22[q1][1];
x=x1+.5*(x3-x1);y=y01+.5*(y3-y01);z=z1+.5*(z3-z1);
sx=d*x/z;sy=d*y/z;window();sx5=sx=sy5=sy;
draw_poly();
return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CALCULATE SIN,COS FACTORS */

void rotation(void){
sr1=sin(r1);sr2=sin(r2);sr3=sin(r3);cr1=cos(r1);cr2=cos(r2);
cr3=cos(r3);return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: STANDARD 3D FORMULAS */
/* Pass: x,y,z cartesian world coordinates.
   Returns: sx,sy cartesian display coordinates.
		  x,y,z catesian view coordinates */

void calc_3d(void){
x=(-1)*x;xa=cr1*x-sr1*z;za=sr1*x+cr1*z;x=cr2*xa+sr2*y;
ya=cr2*y-sr2*xa;z=cr3*za-sr3*ya;y=sr3*za+cr3*ya;x=x+mx;y=y+my;
z=z+mz;sx=d*x/z;sy=d*y/z;return;}

/* ----------------------------------------------------------------------- */
/* HIDDEN SURFACE VISIBILTY TEST */
void visibility_test(void){
sp1=x1*(y2*z3-y3*z2);sp1=(-1)*sp1;sp2=x2*(y3*z1-y01*z3);
sp3=x3*(y01*z2-y2*z1);sp=sp1-sp2-sp3;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: DRAW 4-SIDED SOLID POLYGON IN 3D SPACE */

void draw_poly(void){
setlinestyle(USERBIT_LINE,0xffff,NORM_WIDTH);
setfillstyle(SOLID_FILL,solid_clr);
setcolor(edge_clr);

polary[0][0]=sx1;polary[0][1]=sy1;polary[1][0]=sx2;polary[1][1]=sy2;
polary[2][0]=sx3;polary[2][1]=sy3;polary[3][0]=sx4;polary[3][1]=sy4;

fillpoly (4,(int far*) polary);
return;
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: MAP CARTESIAN COORDS TO PHYSICAL SCREEN COORDS */

void window(void){
sx=sx+399;sy=sy+299;rx=screen_x/799;ry=screen_y/599;sx=sx*rx;
sy=sy*ry;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CHACK THE KEYBOARD BUFFER */
void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: GRACEFUL EXIT FROM PROGRAM */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: VGA/EGA/MCGA/CGA COMPATIBILITY MODULE */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;
if (graphics_mode==EGAHI) goto EGA_ECD_mode;
if (graphics_mode==EGALO) goto EGA_SCD_mode;
if (graphics_adapter==CGA) goto CGA_mode;
if (graphics_adapter==MCGA) goto CGA_mode;
goto abort_message;

VGA_mode:
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=480;mode_flag=1;
        maxx=639;minx=0;maxy=479;miny=0;screen_x=639;screen_y=479;
        setcolor(7);moveto(0,472);
		  outtext("Revisions by A. Helder");
        moveto(472,472);
        outtext("Press any key to quit");
        moveto(160,0);
        outtext("USING C TO GENERATE A 3D WIRE FRAME CUBE");
        return;

EGA_ECD_mode:
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=350;mode_flag=2;
        maxx=639;minx=0;maxy=349;miny=0;screen_x=639;screen_y=349;
        setcolor(7);moveto(0,342);
		  outtext("Revisions by A. Helder");
        moveto(472,342);
        outtext ("Press any key to quit");
        moveto(160,0);
		  outtext("USING C TO MAP DESIGNS ONTO A SOLID 3D MODEL");
        return;

EGA_SCD_mode:
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=3;
        maxx=639;minx=0;maxy=199;miny=0;screen_x=639;screen_y=199;
        setcolor(7);moveto(0,192);
		  outtext("Revisions by A. Helder");
        moveto(472,192);
        outtext("PRESS ANY KEY TO QUIT");
        moveto(160,0);
		  outtext("USING C TO MAP DESIGNS ONTO A SOLID 3D MODEL");
        return;

CGA_mode:
graphics_adapter=CGA;graphics_mode=CGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=320;y_res=200;mode_flag=1;C7=3;
        maxx=319;minx=0;maxy=199;miny=0;screen_x=319;screen_y=199;
        setcolor(3);moveto(48,192);
		  outtext("Revisions by A. Helder");
        moveto(88,0);
		  outtext ("MAPPING A CYLINDER");
        return;

abort_message:
printf("\n\nUnable to proceed - Requires VGA,EGA,CGA or MCGA adapter");
printf("\nWith appropriate monitor");
exit(0);
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: MAP 640*480 TEMPLATE TO 2D SCREEN */
void coords(void)
{
sx=sx*(x_res/640);sy=sy*(y_res/480);return;
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: COPYRIGHT NOTICE */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(int x, int y){
int a,b,c; int t1=0;

for (t1=0;t1<=6;t1++)
	{
	a=copyright[t1][0];b=copyright[t1][1];
	c=copyright[t1][2];
	setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
	moveto(x,y);lineto(x+15,y);
	setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
	moveto(x+16,y);lineto(x+31,y);
	setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
	moveto(x+32,y);lineto(x+47,y);y++;
	};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/* end of source code */
