/* tc-06 */
/* draws cubic parametric curves in 3d.
	Supports MCGA,CGA,EGA and VGA monitors */

/* ----------------------------------------------------------------------- */
/* INCLUDE FILES */
#include <process.h>
#include <bios.h>
#include <stdio.h>
#include <graphics.h>
#include <math.h>

/* ----------------------------------------------------------------------- */
/* DECLARATIONS */

float		j01=0.0,j2=0.0,j3=0.0,j4=0.0;
float		t=0.0,t2=0.0,t3=0.0;
float		x=0.0,y=0.0,z=0.0;
float		sx=0.0,sy=0.0;
float		xa=0.0,ya=0.0,za=0.0;
float		d=1200.0;														/* angular perspective factor */
double	r1=5.88319;														/* yaw angle in radians */
double	r2=6.28319;														/* roll angle in radians */
double	r3=5.79778;														/* pitch angle in radians */
double	sr1=0.0,sr2=0.0,sr3=0.0;									/* sine rotation factors */
double	cr1=0.0,cr2=0.0,cr3=0.0;									/* cosine rotation factors */
float		mx=0.0,my=0.0,mz=-150.0;									/* viewpoint position */
int		maxx=639,minx=0,maxy=199,miny=0;
float		screen_x=639,screen_y=199;
float		rx=0.0,ry=0.0;
int		C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,
			C10=10,C11=11,C12=12,C13=13,C14=14,C15=15,
			mode_flag=0;
int		edge_clr=7;														/* used to draw edges of models */
int		t1=0;
int		h=0;																/* loop counter and pointer into array */

float		B11[21][2];														/* 21 sets of sx,sy coordinates for near curve */
float		B12[21][2];														/* 21 sets of sx,sy coordinates for far curve */
float		x1=-30,y01=0.0,x4=30.0,y4=0.0,							/* curve endpoints */
			x2=-10.0,y2=15.0,x3=10.0,y3=-35.0;						/* curve control points */
float		sx1=0.0,sy1=0.0,sx2=0.0,sy2=0.0;							/* line endpoints */

/* global subroutines */
void keyboard(void);void quit_pgm(void);void calc_3d(void);
void rotation(void);void window(void);void graphics_setup(void);
void notice(int x,int y); void freeform(void);

/* ----------------------------------------------------------------------- */
/* MAIN ROUTINE */

main(){
graphics_setup();
setviewport(minx,miny,maxx,maxy,1);
edge_clr=C7;
setcolor(edge_clr); 														/* active drawing color */
rotation();

/* draw near edge of mesh and store vertices in array */
t=0.0;t2=t*t;t3=t*t*t;
freeform();z=30.0;calc_3d();window();
moveto(sx,sy);
putpixel (sx,sy,edge_clr);
h=0;
for (t=0.0;t<=1.01;t+=.05){
	t2=t*t;t3=t*t*t;freeform();z=30.0;calc_3d();window();
	lineto(sx,sy);B11[h][0]=sx;B11[h][1]=sy;h=h+1;}

/* draw far edge of mesh and store vertices in array */
t=0.0;t2=t*t;t3=t*t*t;
freeform();z=-30.0;calc_3d();window();
moveto(sx,sy);
putpixel (sx,sy,edge_clr);
h=0;																			/* establish start point */
for (t=0.0;t<=1.01;t+=.05){
	t2=t*t;t3=t*t*t;freeform();z=-30.0;calc_3d();window();
	lineto(sx,sy);B12[h][0]=sx;B12[h][1]=sy;h=h+1;}

for (h=-20;h<=20;h+=10){
	t=0.0;t2=t*t;t3=t*t*t;
	freeform();z=h;calc_3d();window();moveto(sx,sy);
	putpixel(sx,sy,edge_clr);
	for (t=0.0;t<=1.01;t+=.05){
		t2=t*t;t3=t*t*t;freeform();z=h;calc_3d();window();
		lineto(sx,sy);
		}																		/* logical end of t loop */

}																				/* logical end of h loop */

/* connect previosly stored vertices */
for (h=0;h<=20;h+=2){
	sx1=B11[h][0];sy1=B11[h][1];
	sx2=B12[h][0];sy2=B12[h][1];
	moveto(sx1,sy1);lineto(sx2,sy2);}

setcolor(C7);notice(0,0);
for (t1=1;t1!=2;) keyboard();
quit_pgm();}

/* SUBROUTINE: CALCULATE POINT ON FREE-FORM CURVE */
void freeform(void){
j01=x1*(-t3+3*t2-3*t+1);j2=x2*(3*t3-6*t2+3*t);j3=x3*(-3*t3+3*t2);
j4=x4*t3;x=j01+j2+j3+j4;
j01=y01*(-t3+3*t2-3*t+1);j2=y2*(3*t3-6*t2+3*t);j3=y3*(-3*t3+3*t2);
j4=y4*t3;y=j01+j2+j3+j4;
return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CALCULATE SIN,COS FACTORS */

void rotation(void){
sr1=sin(r1);sr2=sin(r2);sr3=sin(r3);cr1=cos(r1);cr2=cos(r2);
cr3=cos(r3);return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: STANDARD 3D FORMULAS */
/* Pass: x,y,z cartesian world coordinates.
   Returns: sx,sy cartesian display coordinates.
		  x,y,z catesian view coordinates */

void calc_3d(void){
x=(-1)*x;xa=cr1*x-sr1*z;za=sr1*x+cr1*z;x=cr2*xa+sr2*y;
ya=cr2*y-sr2*xa;z=cr3*za-sr3*ya;y=sr3*za+cr3*ya;x=x+mx;y=y+my;
z=z+mz;sx=d*x/z;sy=d*y/z;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: MAP CARTESIAN COORDS TO PHYSICAL SCREEN COORDS */

void window(void){
sx=sx+399;sy=sy+299;rx=screen_x/799;ry=screen_y/599;sx=sx*rx;
sy=sy*ry;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CHACK THE KEYBOARD BUFFER */
void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: GRACEFUL EXIT FROM PROGRAM */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: VGA/EGA/MCGA/CGA COMPATIBILITY MODULE */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;
if (graphics_mode==EGAHI) goto EGA_ECD_mode;
if (graphics_mode==EGALO) goto EGA_SCD_mode;
if (graphics_adapter==CGA) goto CGA_mode;
if (graphics_adapter==MCGA) goto CGA_mode;
goto abort_message;

VGA_mode:
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
	maxx=639;minx=0;maxy=479;miny=0;screen_x=639;screen_y=479;
	setcolor(7);moveto(0,472);
	outtext("Revisions by A. Helder");
	moveto(472,472);
	outtext("Press any key to quit");
	moveto(160,0);
	outtext("USING C TO GENERATE 3D CURVES");
	return;

EGA_ECD_mode:
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
	maxx=639;minx=0;maxy=349;miny=0;screen_x=639;screen_y=349;
	setcolor(7);moveto(0,342);
	outtext("Revisions by A. Helder");
	moveto(472,342);
	outtext ("Press any key to quit");
	moveto(160,0);
	outtext("USING C TO GENERATE 3D CURVES");
	return;

EGA_SCD_mode:
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
	maxx=639;minx=0;maxy=199;miny=0;screen_x=639;screen_y=199;
	setcolor(7);moveto(0,192);
	outtext("Revisions by A. Helder");
	moveto(472,192);
	outtext("PRESS ANY KEY TO QUIT");
	moveto(160,0);
	outtext("USING C TO GENERATE 3D CURVES");
	return;

CGA_mode:
graphics_adapter=CGA;graphics_mode=CGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
C7=3;
	maxx=319;minx=0;maxy=199;miny=0;screen_x=319;screen_y=199;
	setcolor(3);moveto(48,192);
	outtext("Revisions by A. Helder");
	moveto(88,0);
	outtext ("3D WIRE FRAME CUBE");
	return;

abort_message:
printf("\n\nUnable to proceed - Requires VGA,EGA,CGA or MCGA adapter");
printf("\nWith appropriate monitor");
exit(0);
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: COPYRIGHT NOTICE */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(int x, int y){
int a,b,c; int t1=0;

for (t1=0;t1<=6;t1++)
	{
	a=copyright[t1][0];b=copyright[t1][1];
	c=copyright[t1][2];
	setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
	moveto(x,y);lineto(x+15,y);
	setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
	moveto(x+16,y);lineto(x+31,y);
	setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
	moveto(x+32,y);lineto(x+47,y);y++;
	};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}


/* END OF SOURCE CODE */
